/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToIntegerAsIntNode.class)
public final class JSToIntegerAsIntNodeGen
extends JSToIntegerAsIntNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private JSToIntegerAsIntNode string_nestedToIntegerNode_;
    @Node.Child
    private JSStringToNumberNode string_stringToNumberNode_;

    private JSToIntegerAsIntNodeGen() {
    }

    @Override
    public int executeInt(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return JSToIntegerAsIntNode.doInteger(arg0Value_2);
        }
        if ((state & 2) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_3 = (Boolean)arg0Value;
            return JSToIntegerAsIntNode.doBoolean(arg0Value_3);
        }
        if ((state & 0xC) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_4 = (SafeInteger)arg0Value;
            if ((state & 4) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_4.longValue())) {
                return JSToIntegerAsIntNode.doSafeIntegerInt32Range(arg0Value_4);
            }
            if ((state & 8) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_4.longValue())) {
                return JSToIntegerAsIntNode.doSafeIntegerOther(arg0Value_4);
            }
        }
        if ((state & 0x30) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E000) >>> 13, arg0Value)) {
            double arg0Value_5 = JSTypesGen.asImplicitDouble((state & 0x1E000) >>> 13, arg0Value);
            if ((state & 0x10) != 0 && JSToIntegerAsIntNode.inInt32Range(arg0Value_5)) {
                return JSToIntegerAsIntNode.doDoubleInt32Range(arg0Value_5);
            }
            if ((state & 0x20) != 0 && !JSToIntegerAsIntNode.inInt32Range(arg0Value_5)) {
                return JSToIntegerAsIntNode.doDoubleOther(arg0Value_5);
            }
        }
        if ((state & 0xC0) != 0) {
            if ((state & 0x40) != 0 && JSGuards.isUndefined(arg0Value)) {
                return JSToIntegerAsIntNode.doUndefined(arg0Value);
            }
            if ((state & 0x80) != 0 && JSGuards.isJSNull(arg0Value)) {
                return JSToIntegerAsIntNode.doNull(arg0Value);
            }
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_6 = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_6);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_7 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_7);
        }
        if ((state & 0x400) != 0 && JSTypesGen.isImplicitString((state & 0x1E0000) >>> 17, arg0Value)) {
            String arg0Value_8 = JSTypesGen.asImplicitString((state & 0x1E0000) >>> 17, arg0Value);
            return this.doString(arg0Value_8, this.string_nestedToIntegerNode_, this.string_stringToNumberNode_);
        }
        if ((state & 0x800) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject(arg0Value_);
        }
        if ((state & 0x1000) != 0 && JSGuards.isForeignObject(arg0Value)) {
            return this.doForeignObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private int executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DynamicObject arg0Value_;
            int doubleCast0;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = JSToIntegerAsIntNode.doInteger(arg0Value_2);
                return n;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_3 = (Boolean)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                int n = JSToIntegerAsIntNode.doBoolean(arg0Value_3);
                return n;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_4 = (SafeInteger)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(arg0Value_4.longValue())) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = JSToIntegerAsIntNode.doSafeIntegerInt32Range(arg0Value_4);
                    return n;
                }
                if (!JSGuards.isLongRepresentableAsInt32(arg0Value_4.longValue())) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = JSToIntegerAsIntNode.doSafeIntegerOther(arg0Value_4);
                    return n;
                }
            }
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                if (JSToIntegerAsIntNode.inInt32Range(arg0Value_5)) {
                    state |= doubleCast0 << 13;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int n = JSToIntegerAsIntNode.doDoubleInt32Range(arg0Value_5);
                    return n;
                }
                if (!JSToIntegerAsIntNode.inInt32Range(arg0Value_5)) {
                    state |= doubleCast0 << 13;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int n = JSToIntegerAsIntNode.doDoubleOther(arg0Value_5);
                    return n;
                }
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                doubleCast0 = JSToIntegerAsIntNode.doUndefined(arg0Value);
                return doubleCast0;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                doubleCast0 = JSToIntegerAsIntNode.doNull(arg0Value);
                return doubleCast0;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_6 = (Symbol)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                int arg0Value_5 = this.doSymbol(arg0Value_6);
                return arg0Value_5;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_7 = (BigInt)arg0Value;
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                int arg0Value_5 = this.doBigInt(arg0Value_7);
                return arg0Value_5;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_8 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                this.string_nestedToIntegerNode_ = super.insert(JSToIntegerAsIntNode.create());
                this.string_stringToNumberNode_ = super.insert(JSStringToNumberNode.create());
                state |= stringCast0 << 17;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                int n = this.doString(arg0Value_8, this.string_nestedToIntegerNode_, this.string_stringToNumberNode_);
                return n;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                int n = this.doJSObject(arg0Value_);
                return n;
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                int n = this.doForeignObject(arg0Value);
                return n;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFF & (state & 0x1FFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[14];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeIntegerInt32Range";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doSafeIntegerOther";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDoubleInt32Range";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleOther";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.string_nestedToIntegerNode_, this.string_stringToNumberNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        return Introspection.Provider.create(data);
    }

    public static JSToIntegerAsIntNode create() {
        return new JSToIntegerAsIntNodeGen();
    }
}

