/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSStringToNumberNode.class)
public final class JSStringToNumberNodeGen
extends JSStringToNumberNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile infinity_endsWithInfinity_;

    private JSStringToNumberNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double executeNoTrim(String arg0Value) {
        int state = this.state_;
        if ((state & 0xFFF) != 0) {
            if ((state & 1) != 0 && arg0Value.length() == 0) {
                return this.doLengthIsZero(arg0Value);
            }
            if ((state & 2) != 0 && JSStringToNumberNode.startsWithI(arg0Value)) {
                return this.doInfinity(arg0Value, this.infinity_endsWithInfinity_);
            }
            if (!((state & 4) == 0 || arg0Value.length() <= 0 || JSStringToNumberNode.startsWithI(arg0Value) || JSStringToNumberNode.startsWithValidDouble(arg0Value) || JSStringToNumberNode.isHex(arg0Value) || JSStringToNumberNode.isOctal(arg0Value) || JSStringToNumberNode.isBinary(arg0Value))) {
                return this.doNaN(arg0Value);
            }
            if ((state & 8) != 0 && JSStringToNumberNode.isHex(arg0Value) && arg0Value.length() <= 15) {
                return this.doHexSafe(arg0Value);
            }
            if ((state & 0x10) != 0 && JSStringToNumberNode.isHex(arg0Value) && arg0Value.length() > 15) {
                return this.doHex(arg0Value);
            }
            if ((state & 0x20) != 0 && JSStringToNumberNode.isOctal(arg0Value) && arg0Value.length() <= 19) {
                return this.doOctalSafe(arg0Value);
            }
            if ((state & 0x40) != 0 && JSStringToNumberNode.isOctal(arg0Value) && arg0Value.length() > 19) {
                return this.doOctal(arg0Value);
            }
            if ((state & 0x80) != 0 && JSStringToNumberNode.isBinary(arg0Value) && arg0Value.length() <= 55) {
                return this.doBinarySafe(arg0Value);
            }
            if ((state & 0x100) != 0 && JSStringToNumberNode.isBinary(arg0Value) && arg0Value.length() > 55) {
                return this.doBinary(arg0Value);
            }
            if ((state & 0x200) != 0 && arg0Value.length() > 0 && arg0Value.length() <= 9 && JSStringToNumberNode.allDigits(arg0Value, 9)) {
                return this.doSmallPosInt(arg0Value);
            }
            if ((state & 0x400) != 0 && arg0Value.length() > 0 && arg0Value.length() <= 17 && JSStringToNumberNode.startsWithValidInt(arg0Value)) {
                try {
                    return this.doInteger(arg0Value);
                }
                catch (SlowPathException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 2;
                        this.state_ &= 0xFFFFFBFF;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(arg0Value);
                }
            }
            if ((state & 0x800) != 0 && arg0Value.length() > 0 && JSStringToNumberNode.startsWithValidDouble(arg0Value)) {
                return this.doDouble(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private double executeAndSpecialize(String arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value.length() == 0) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                double d = this.doLengthIsZero(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.startsWithI(arg0Value)) {
                this.infinity_endsWithInfinity_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                double d = this.doInfinity(arg0Value, this.infinity_endsWithInfinity_);
                return d;
            }
            if (!(arg0Value.length() <= 0 || JSStringToNumberNode.startsWithI(arg0Value) || JSStringToNumberNode.startsWithValidDouble(arg0Value) || JSStringToNumberNode.isHex(arg0Value) || JSStringToNumberNode.isOctal(arg0Value) || JSStringToNumberNode.isBinary(arg0Value))) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                double d = this.doNaN(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isHex(arg0Value) && arg0Value.length() <= 15) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                double d = this.doHexSafe(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isHex(arg0Value) && arg0Value.length() > 15) {
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                double d = this.doHex(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isOctal(arg0Value) && arg0Value.length() <= 19) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                double d = this.doOctalSafe(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isOctal(arg0Value) && arg0Value.length() > 19) {
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                double d = this.doOctal(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isBinary(arg0Value) && arg0Value.length() <= 55) {
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                double d = this.doBinarySafe(arg0Value);
                return d;
            }
            if (JSStringToNumberNode.isBinary(arg0Value) && arg0Value.length() > 55) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                double d = this.doBinary(arg0Value);
                return d;
            }
            if ((exclude & 1) == 0 && arg0Value.length() > 0 && arg0Value.length() <= 9 && JSStringToNumberNode.allDigits(arg0Value, 9)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                double d = this.doSmallPosInt(arg0Value);
                return d;
            }
            if ((exclude & 2) == 0 && arg0Value.length() > 0 && arg0Value.length() <= 17 && JSStringToNumberNode.startsWithValidInt(arg0Value)) {
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFDFF;
                this.state_ = state |= 0x400;
                try {
                    lock.unlock();
                    hasLock = false;
                    double d = this.doInteger(arg0Value);
                    return d;
                }
                catch (SlowPathException ex) {
                    lock.lock();
                    try {
                        this.exclude_ |= 2;
                        this.state_ &= 0xFFFFFBFF;
                    }
                    finally {
                        lock.unlock();
                    }
                    double d = this.executeAndSpecialize(arg0Value);
                    if (hasLock) {
                        lock.unlock();
                    }
                    return d;
                }
            }
            if (arg0Value.length() > 0 && JSStringToNumberNode.startsWithValidDouble(arg0Value)) {
                this.exclude_ = exclude |= 3;
                state &= 0xFFFFF9FF;
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                double d = this.doDouble(arg0Value);
                return d;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xFFF & (state & 0xFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[13];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doLengthIsZero";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doInfinity";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.infinity_endsWithInfinity_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doNaN";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doHexSafe";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doHex";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doOctalSafe";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doOctal";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBinarySafe";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBinary";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doSmallPosInt";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[10] = s;
        s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[11] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        return Introspection.Provider.create(data);
    }

    public static JSStringToNumberNode create() {
        return new JSStringToNumberNodeGen();
    }
}

