/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import com.oracle.truffle.js.nodes.binary.JSRightShiftNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.runtime.BigInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSRightShiftNode.class)
public final class JSRightShiftNodeGen
extends JSRightShiftNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSLeftShiftNode bigInt_leftShift_;
    @Node.Child
    private DoubleData double_cache;
    @Node.Child
    private GenericData generic_cache;

    private JSRightShiftNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        GenericData s5_;
        int state = this.state_;
        if ((state & 1) != 0 && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (Integer)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                return this.doInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 2) != 0 && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_, rightNodeValue_, this.bigInt_leftShift_);
            }
        }
        if ((state & 0xC) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue)) {
            double rightNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue);
            if ((state & 4) != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
                    return this.doIntDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue);
                DoubleData s4_ = this.double_cache;
                if (s4_ != null) {
                    return this.doDouble(leftNodeValue_, rightNodeValue_, s4_.rightShift_, s4_.leftInt32_, s4_.rightUInt32_);
                }
            }
        }
        if ((state & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue, rightNodeValue, s5_.rightShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && (state & 0x1F) != 0) {
            return this.execute_int_int0(frameValue, state);
        }
        if ((state & 0x1B) == 0 && (state & 0x1F) != 0) {
            return this.execute_int_double1(frameValue, state);
        }
        if ((state & 0x17) == 0 && (state & 0x1F) != 0) {
            return this.execute_double_double2(frameValue, state);
        }
        return this.execute_generic3(frameValue, state);
    }

    private Object execute_int_int0(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int_double1(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 4) != 0);
        if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
            return this.doIntDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private Object execute_double_double2(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C00) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A00) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x1600) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x1A00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 8) != 0);
        DoubleData s4_ = this.double_cache;
        if (s4_ != null) {
            return this.doDouble(leftNodeValue_, rightNodeValue_, s4_.rightShift_, s4_.leftInt32_, s4_.rightUInt32_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x1C00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x1A00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private Object execute_generic3(VirtualFrame frameValue, int state) {
        GenericData s5_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 1) != 0 && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (Integer)rightNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 2) != 0 && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__, rightNodeValue__, this.bigInt_leftShift_);
            }
        }
        if ((state & 0xC) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_)) {
            double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_);
            if ((state & 4) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                if (!JSBinaryNode.largerThan2e32(rightNodeValue__)) {
                    return this.doIntDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue_);
                DoubleData s4_ = this.double_cache;
                if (s4_ != null) {
                    return this.doDouble(leftNodeValue__, rightNodeValue__, s4_.rightShift_, s4_.leftInt32_, s4_.rightUInt32_);
                }
            }
        }
        if ((state & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue_, rightNodeValue_, s5_.rightShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int leftNodeValue_;
        int state = this.state_;
        if ((state & 0x18) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        if ((state & 4) == 0 && (state & 5) != 0) {
            return this.executeInt_int4(frameValue, state, leftNodeValue_);
        }
        if ((state & 1) == 0 && (state & 5) != 0) {
            return this.executeInt_double5(frameValue, state, leftNodeValue_);
        }
        return this.executeInt_generic6(frameValue, state, leftNodeValue_);
    }

    private int executeInt_int4(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        int rightNodeValue_;
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private int executeInt_double5(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        double rightNodeValue_;
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 4) != 0);
        if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
            return this.doIntDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_)));
    }

    private int executeInt_generic6(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        double rightNodeValue__;
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 1) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__2 = (Integer)rightNodeValue_;
            return this.doInteger(leftNodeValue_, rightNodeValue__2);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_) && !JSBinaryNode.largerThan2e32(rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_))) {
            return this.doIntDouble(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x1A) == 0 && (state & 0x1F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast1;
            if ((exclude & 1) == 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (Integer)rightNodeValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if ((exclude & 2) == 0 && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                    this.bigInt_leftShift_ = super.insert(JSLeftShiftNode.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    BigInt bigInt = this.doBigInt(leftNodeValue_, rightNodeValue_, this.bigInt_leftShift_);
                    return bigInt;
                }
            }
            if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                int doubleCast0;
                double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                if ((exclude & 4) == 0 && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (Integer)leftNodeValue;
                    if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
                        state |= doubleCast1 << 5;
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Integer n = this.doIntDouble(leftNodeValue_, rightNodeValue_);
                        return n;
                    }
                }
                if ((exclude & 8) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                    DoubleData s4_ = super.insert(new DoubleData());
                    s4_.rightShift_ = s4_.insertAccessor(JSRightShiftNode.create());
                    s4_.leftInt32_ = s4_.insertAccessor(JSToInt32Node.create());
                    s4_.rightUInt32_ = s4_.insertAccessor(JSToUInt32Node.create());
                    this.double_cache = s4_;
                    state |= doubleCast0 << 9;
                    state |= doubleCast1 << 5;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doDouble(leftNodeValue_, rightNodeValue_, s4_.rightShift_, s4_.leftInt32_, s4_.rightUInt32_);
                    return object;
                }
            }
            GenericData s5_ = super.insert(new GenericData());
            s5_.rightShift_ = s5_.insertAccessor(JSRightShiftNode.create());
            s5_.leftToNumeric_ = s5_.insertAccessor(JSToNumericNode.create());
            s5_.rightToNumeric_ = s5_.insertAccessor(JSToNumericNode.create());
            s5_.mixedNumericTypes_ = BranchProfile.create();
            this.generic_cache = s5_;
            this.exclude_ = exclude |= 0xF;
            this.double_cache = null;
            state &= 0xFFFFFFF0;
            this.state_ = state |= 0x10;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(leftNodeValue, rightNodeValue, s5_.rightShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1F & (state & 0x1F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(this.bigInt_leftShift_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doIntDouble";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            DoubleData s4_ = this.double_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(s4_.rightShift_, s4_.leftInt32_, s4_.rightUInt32_));
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s5_ = this.generic_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(s5_.rightShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create(data);
    }

    public static JSRightShiftNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSRightShiftNodeGen(left, right);
    }

    @GeneratedBy(value=JSRightShiftNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        JSRightShiftNode rightShift_;
        @Node.Child
        JSToNumericNode leftToNumeric_;
        @Node.Child
        JSToNumericNode rightToNumeric_;
        @CompilerDirectives.CompilationFinal
        BranchProfile mixedNumericTypes_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=JSRightShiftNode.class)
    private static final class DoubleData
    extends Node {
        @Node.Child
        JSRightShiftNode rightShift_;
        @Node.Child
        JSToInt32Node leftInt32_;
        @Node.Child
        JSToUInt32Node rightUInt32_;

        DoubleData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

