/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSLessOrEqualNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringOrNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSLessOrEqualNode.class)
public final class JSLessOrEqualNodeGen
extends JSLessOrEqualNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile long state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private GenericData generic_cache;

    private JSLessOrEqualNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        long state = this.state_;
        if ((state & 3L) != 0L && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (Integer)leftNodeValue;
            if ((state & 1L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                return this.doInt(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 2L) != 0L && rightNodeValue instanceof SafeInteger) {
                SafeInteger rightNodeValue_ = (SafeInteger)rightNodeValue;
                return this.doSafeInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0xCL) != 0L && leftNodeValue instanceof SafeInteger) {
            SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
            if ((state & 4L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                return this.doSafeInteger(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 8L) != 0L && rightNodeValue instanceof SafeInteger) {
                SafeInteger rightNodeValue_ = (SafeInteger)rightNodeValue;
                return this.doSafeInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue);
                return this.doDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x60L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            String leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if ((state & 0x20L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                String rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doString(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x40L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue);
                return this.doStringDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x80L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue);
            if (JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                String rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doDoubleString(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x100L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            String leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doStringBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x1E00L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt)leftNodeValue;
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                String rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doBigIntString(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x400L) != 0L && rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x800L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                return this.doBigIntAndInt(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue);
                return this.doBigIntAndNumber(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x6000L) != 0L && rightNodeValue instanceof BigInt) {
            BigInt rightNodeValue_ = (BigInt)rightNodeValue;
            if ((state & 0x2000L) != 0L && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                return this.doIntAndBigInt(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x4000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue);
                return this.doNumberAndBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x18000L) != 0L) {
            GenericData s17_;
            if ((state & 0x8000L) != 0L && JSGuards.isJavaNumber(leftNodeValue) && JSGuards.isJavaNumber(rightNodeValue)) {
                return this.doJavaNumber(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x10000L) != 0L && (s17_ = this.generic_cache) != null) {
                return this.doGeneric(leftNodeValue, rightNodeValue, s17_.toStringOrNumber1_, s17_.toPrimitive1_, s17_.toStringOrNumber2_, s17_.toPrimitive2_, s17_.lessOrEqualNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        long state = this.state_;
        if ((state & 0x1FFFEL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_int_int0(frameValue, state);
        }
        if ((state & 0x1FFEFL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_double_double1(frameValue, state);
        }
        if ((state & 0x1DFFDL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_int2(frameValue, state);
        }
        if ((state & 0x1F7FBL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_int3(frameValue, state);
        }
        if ((state & 0x1EFBFL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_double4(frameValue, state);
        }
        if ((state & 0x1BF7FL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.executeBoolean_double5(frameValue, state);
        }
        return this.executeBoolean_generic6(frameValue, state);
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1L) != 0L);
        return this.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 0x10L) != 0L);
        return this.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int2(VirtualFrame frameValue, long state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 2L) != 0L && rightNodeValue_ instanceof SafeInteger) {
            SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
            return this.doSafeInteger(leftNodeValue_, rightNodeValue__);
        }
        if ((state & 0x2000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return this.doIntAndBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int3(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 4L) != 0L && leftNodeValue_ instanceof SafeInteger) {
            SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
            return this.doSafeInteger(leftNodeValue__, rightNodeValue_);
        }
        if ((state & 0x800L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return this.doBigIntAndInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double4(VirtualFrame frameValue, long state) {
        Object leftNodeValue__;
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0x40L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            return this.doStringDouble((String)leftNodeValue__, rightNodeValue_);
        }
        if ((state & 0x1000L) != 0L && leftNodeValue_ instanceof BigInt) {
            leftNodeValue__ = (BigInt)leftNodeValue_;
            return this.doBigIntAndNumber((BigInt)leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)rightNodeValue_long : (Number)((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private boolean executeBoolean_double5(VirtualFrame frameValue, long state) {
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0x80L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
            String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
            return this.doDoubleString(leftNodeValue_, rightNodeValue__);
        }
        if ((state & 0x4000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return this.doNumberAndBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), rightNodeValue_);
    }

    private boolean executeBoolean_generic6(VirtualFrame frameValue, long state) {
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3L) != 0L && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if ((state & 1L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (Integer)rightNodeValue_;
                return this.doInt(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 2L) != 0L && rightNodeValue_ instanceof SafeInteger) {
                SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
                return this.doSafeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0xCL) != 0L && leftNodeValue_ instanceof SafeInteger) {
            SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
            if ((state & 4L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (Integer)rightNodeValue_;
                return this.doSafeInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 8L) != 0L && rightNodeValue_ instanceof SafeInteger) {
                SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
                return this.doSafeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_);
                return this.doDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x60L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            String leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if ((state & 0x20L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doString(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x40L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_);
                return this.doStringDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x80L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_);
            if (JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doDoubleString(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x100L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            String leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doStringBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x1E00L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doBigIntString(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x400L) != 0L && rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x800L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (Integer)rightNodeValue_;
                return this.doBigIntAndInt(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_);
                return this.doBigIntAndNumber(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x6000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            if ((state & 0x2000L) != 0L && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doIntAndBigInt(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x4000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_);
                return this.doNumberAndBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x18000L) != 0L) {
            GenericData s17_;
            if ((state & 0x8000L) != 0L && JSGuards.isJavaNumber(leftNodeValue_) && JSGuards.isJavaNumber(rightNodeValue_)) {
                return this.doJavaNumber(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x10000L) != 0L && (s17_ = this.generic_cache) != null) {
                return this.doGeneric(leftNodeValue_, rightNodeValue_, s17_.toStringOrNumber1_, s17_.toPrimitive1_, s17_.toStringOrNumber2_, s17_.toPrimitive2_, s17_.lessOrEqualNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        long state = this.state_;
        int exclude = this.exclude_;
        try {
            boolean rightNodeValue_14;
            boolean bl;
            int stringCast0;
            int doubleCast0;
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if ((exclude & 1) == 0 && rightNodeValue instanceof Integer) {
                    int rightNodeValue_2 = (Integer)rightNodeValue;
                    this.state_ = state |= 1L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = this.doInt(leftNodeValue_, rightNodeValue_2);
                    return bl2;
                }
                if (rightNodeValue instanceof SafeInteger) {
                    SafeInteger rightNodeValue_3 = (SafeInteger)rightNodeValue;
                    this.state_ = state |= 2L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl3 = this.doSafeInteger(leftNodeValue_, rightNodeValue_3);
                    return bl3;
                }
            }
            if (leftNodeValue instanceof SafeInteger) {
                SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_4 = (Integer)rightNodeValue;
                    this.state_ = state |= 4L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl4 = this.doSafeInteger(leftNodeValue_, rightNodeValue_4);
                    return bl4;
                }
                if (rightNodeValue instanceof SafeInteger) {
                    SafeInteger rightNodeValue_5 = (SafeInteger)rightNodeValue;
                    this.state_ = state |= 8L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl5 = this.doSafeInteger(leftNodeValue_, rightNodeValue_5);
                    return bl5;
                }
            }
            if ((exclude & 2) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_6 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast0 << 17;
                    state |= (long)doubleCast1 << 21;
                    this.state_ = state |= 0x10L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl6 = this.doDouble(leftNodeValue_, rightNodeValue_6);
                    return bl6;
                }
            }
            if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                int doubleCast1;
                int stringCast1;
                String leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                if ((exclude & 4) == 0 && (stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                    String rightNodeValue_7 = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                    state |= (long)stringCast0 << 25;
                    state |= (long)stringCast1 << 29;
                    this.state_ = state |= 0x20L;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_6 = this.doString(leftNodeValue_, rightNodeValue_7);
                    return rightNodeValue_6;
                }
                if ((exclude & 8) == 0 && (doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_8 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)stringCast0 << 25;
                    state |= (long)doubleCast1 << 21;
                    this.state_ = state |= 0x40L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl7 = this.doStringDouble(leftNodeValue_, rightNodeValue_8);
                    return bl7;
                }
            }
            if ((exclude & 0x10) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast1 != 0) {
                    String rightNodeValue_9 = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                    state |= (long)doubleCast0 << 17;
                    state |= (long)stringCast1 << 29;
                    this.state_ = state |= 0x80L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl8 = this.doDoubleString(leftNodeValue_, rightNodeValue_9);
                    return bl8;
                }
            }
            if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                String leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_10 = (BigInt)rightNodeValue;
                    state |= (long)stringCast0 << 25;
                    this.state_ = state |= 0x100L;
                    lock.unlock();
                    hasLock = false;
                    bl = this.doStringBigInt(leftNodeValue_, rightNodeValue_10);
                    return bl;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                int doubleCast1;
                BigInt leftNodeValue_ = (BigInt)leftNodeValue;
                int stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast1 != 0) {
                    String rightNodeValue_11 = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                    state |= (long)stringCast1 << 29;
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    bl = this.doBigIntString(leftNodeValue_, rightNodeValue_11);
                    return bl;
                }
                if ((exclude & 0x20) == 0 && rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_12 = (BigInt)rightNodeValue;
                    this.state_ = state |= 0x400L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_14 = this.doBigInt(leftNodeValue_, rightNodeValue_12);
                    return rightNodeValue_14;
                }
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_13 = (Integer)rightNodeValue;
                    this.state_ = state |= 0x800L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_14 = this.doBigIntAndInt(leftNodeValue_, rightNodeValue_13);
                    return rightNodeValue_14;
                }
                if ((exclude & 0x40) == 0 && (doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_14 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast1 << 21;
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl9 = this.doBigIntAndNumber(leftNodeValue_, rightNodeValue_14);
                    return bl9;
                }
            }
            if (rightNodeValue instanceof BigInt) {
                int doubleCast02;
                BigInt rightNodeValue_15 = (BigInt)rightNodeValue;
                if (leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (Integer)leftNodeValue;
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_14 = this.doIntAndBigInt(leftNodeValue_, rightNodeValue_15);
                    return rightNodeValue_14;
                }
                if ((exclude & 0x80) == 0 && (doubleCast02 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast02, leftNodeValue);
                    state |= (long)doubleCast02 << 17;
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl10 = this.doNumberAndBigInt(leftNodeValue_, rightNodeValue_15);
                    return bl10;
                }
            }
            if ((exclude & 0x100) == 0 && JSGuards.isJavaNumber(leftNodeValue) && JSGuards.isJavaNumber(rightNodeValue)) {
                this.state_ = state |= 0x8000L;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_15 = this.doJavaNumber(leftNodeValue, rightNodeValue);
                return rightNodeValue_15;
            }
            GenericData s17_ = super.insert(new GenericData());
            s17_.toStringOrNumber1_ = s17_.insertAccessor(JSToStringOrNumberNode.create());
            s17_.toPrimitive1_ = s17_.insertAccessor(JSToPrimitiveNode.createHintNumber());
            s17_.toStringOrNumber2_ = s17_.insertAccessor(JSToStringOrNumberNode.create());
            s17_.toPrimitive2_ = s17_.insertAccessor(JSToPrimitiveNode.createHintNumber());
            s17_.lessOrEqualNode_ = s17_.insertAccessor(JSLessOrEqualNode.create());
            this.generic_cache = s17_;
            this.exclude_ = exclude |= 0x1FF;
            state &= 0xFFFFFFFFFFFF2B0EL;
            this.state_ = state |= 0x10000L;
            lock.unlock();
            hasLock = false;
            boolean bl11 = this.doGeneric(leftNodeValue, rightNodeValue, s17_.toStringOrNumber1_, s17_.toPrimitive1_, s17_.toStringOrNumber2_, s17_.toPrimitive2_, s17_.lessOrEqualNode_);
            return bl11;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        long state = this.state_;
        if ((state & 0x1FFFFL) == 0L) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFFFL & (state & 0x1FFFFL) - 1L) == 0L) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[18];
        data[0] = 0;
        long state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 2L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 4L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 8L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x10L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x20L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doStringDouble";
        s[1] = (state & 0x40L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[7] = s;
        s = new Object[3];
        s[0] = "doDoubleString";
        s[1] = (state & 0x80L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[8] = s;
        s = new Object[3];
        s[0] = "doStringBigInt";
        s[1] = (state & 0x100L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doBigIntString";
        s[1] = (state & 0x200L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x400L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[11] = s;
        s = new Object[3];
        s[0] = "doBigIntAndInt";
        s[1] = (state & 0x800L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doBigIntAndNumber";
        s[1] = (state & 0x1000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x40) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[13] = s;
        s = new Object[3];
        s[0] = "doIntAndBigInt";
        s[1] = (state & 0x2000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "doNumberAndBigInt";
        s[1] = (state & 0x4000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x80) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[15] = s;
        s = new Object[3];
        s[0] = "doJavaNumber";
        s[1] = (state & 0x8000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x100) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[16] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x10000L) != 0L) {
            s[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            GenericData s17_ = this.generic_cache;
            if (s17_ != null) {
                cached.add(Arrays.asList(s17_.toStringOrNumber1_, s17_.toPrimitive1_, s17_.toStringOrNumber2_, s17_.toPrimitive2_, s17_.lessOrEqualNode_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[17] = s;
        return Introspection.Provider.create(data);
    }

    public static JSLessOrEqualNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSLessOrEqualNodeGen(left, right);
    }

    @GeneratedBy(value=JSLessOrEqualNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        JSToStringOrNumberNode toStringOrNumber1_;
        @Node.Child
        JSToPrimitiveNode toPrimitive1_;
        @Node.Child
        JSToStringOrNumberNode toStringOrNumber2_;
        @Node.Child
        JSToPrimitiveNode toPrimitive2_;
        @Node.Child
        JSLessOrEqualNode lessOrEqualNode_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

