/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSIdenticalNode.class)
public final class JSIdenticalNodeGen
extends JSIdenticalNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile long state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile flattenA;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile flattenB;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile sameLen;
    @Node.Child
    private NullA0Data nullA0_cache;
    @Node.Child
    private NullB0Data nullB0_cache;
    @CompilerDirectives.CompilationFinal
    private DifferentTypesCachedData differentTypesCached_cache;
    @CompilerDirectives.CompilationFinal
    private NumberCachedData numberCached_cache;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;

    private JSIdenticalNodeGen(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        Object rightNodeValue_;
        CharSequence leftNodeValue_;
        long state = this.state_;
        if ((state & 1L) != 0L && leftNodeValue instanceof Integer) {
            int n = (Integer)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                return JSIdenticalNode.doInt(n, rightNodeValue_2);
            }
        }
        if ((state & 2L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue)) {
                double rightNodeValue_3 = JSTypesGen.asImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue);
                return this.doDouble(d, rightNodeValue_3);
            }
        }
        if ((state & 4L) != 0L && leftNodeValue instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue_4);
            }
        }
        if ((state & 0x18L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if ((state & 8L) != 0L && rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_5 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue_5);
            }
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue)) {
                double rightNodeValue_6 = JSTypesGen.asImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_6);
            }
        }
        if ((state & 0x20L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue);
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_7 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue_7);
            }
        }
        if ((state & 0x1C0L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0xC0L) != 0L) {
                if ((state & 0x40L) != 0L && JSGuards.isUndefined(leftNodeValue)) {
                    return JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
                }
                if ((state & 0x80L) != 0L && JSGuards.isUndefined(rightNodeValue)) {
                    return JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x100L) != 0L && JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)leftNodeValue)) {
                return JSIdenticalNode.doJSObjectA(dynamicObject, rightNodeValue);
            }
        }
        if ((state & 0x1FE00L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0x200L) != 0L && JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue)) {
                return JSIdenticalNode.doJSObjectB(leftNodeValue, dynamicObject);
            }
            if ((state & 0x1FC00L) != 0L) {
                if ((state & 0x400L) != 0L && JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
                }
                if ((state & 0x800L) != 0L && JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
                    return JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
                }
                if ((state & 0x1000L) != 0L && JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
                }
                if ((state & 0x2000L) != 0L) {
                    void var5_12;
                    NullA0Data nullA0Data = this.nullA0_cache;
                    while (var5_12 != null) {
                        if (var5_12.bInterop_.accepts(rightNodeValue) && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                            return JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, var5_12.bInterop_);
                        }
                        NullA0Data nullA0Data2 = var5_12.next_;
                    }
                }
                if ((state & 0x4000L) != 0L && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                    return this.nullA1Boundary(state, leftNodeValue, rightNodeValue);
                }
                if ((state & 0x8000L) != 0L) {
                    void var5_15;
                    NullB0Data nullB0Data = this.nullB0_cache;
                    while (var5_15 != null) {
                        if (var5_15.aInterop_.accepts(leftNodeValue) && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                            return JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, var5_15.aInterop_);
                        }
                        NullB0Data nullB0Data2 = var5_15.next_;
                    }
                }
                if ((state & 0x10000L) != 0L && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return this.nullB1Boundary(state, leftNodeValue, rightNodeValue);
                }
            }
        }
        if ((state & 0xE0000L) != 0L && rightNodeValue instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
            if ((state & 0x60000L) != 0L && leftNodeValue instanceof JSLazyString) {
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                if ((state & 0x20000L) != 0L && JSGuards.isReferenceEquals(leftNodeValue_, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue_, jSLazyString);
                }
                if ((state & 0x40000L) != 0L) {
                    return JSIdenticalNode.doLazyString(leftNodeValue_, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                }
            }
            if ((state & 0x80000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue);
                return JSIdenticalNode.doStringLazyString((String)leftNodeValue_, jSLazyString, this.flattenB, this.sameLen);
            }
        }
        if ((state & 0x700000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C00000000000L) >>> 46), rightNodeValue)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x3C00000000000L) >>> 46), rightNodeValue);
            if ((state & 0x100000L) != 0L && leftNodeValue instanceof JSLazyString) {
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                return JSIdenticalNode.doLazyStringString(leftNodeValue_, string, this.flattenA, this.sameLen);
            }
            if ((state & 0x600000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue);
                if ((state & 0x200000L) != 0L && JSGuards.isReferenceEquals(leftNodeValue_, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue_, string);
                }
                if ((state & 0x400000L) != 0L) {
                    return JSIdenticalNode.doString((String)leftNodeValue_, string);
                }
            }
        }
        if ((state & 0x800000L) != 0L && leftNodeValue instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue_);
            }
        }
        if ((state & 0x3F000000L) != 0L) {
            if ((state & 0x1000000L) != 0L && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x2000000L) != 0L && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x4000000L) != 0L) {
                void var5_21;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var5_21 != null) {
                    if (leftNodeValue.getClass() == var5_21.cachedClassA_ && rightNodeValue.getClass() == var5_21.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var5_21.cachedClassA_) || JSIdenticalNode.isNonObjectType(var5_21.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var5_21.cachedClassA_, var5_21.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, var5_21.cachedClassA_, var5_21.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var5_21.next_;
                }
            }
            if ((state & 0x8000000L) != 0L && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x10000000L) != 0L && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x20000000L) != 0L) {
                void var5_24;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var5_24 != null) {
                    assert (var5_24.cachedClassA_ != null);
                    assert (var5_24.cachedClassB_ != null);
                    if (leftNodeValue.getClass() == var5_24.cachedClassA_ && rightNodeValue.getClass() == var5_24.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue, rightNodeValue, var5_24.cachedClassA_, var5_24.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var5_24.next_;
                }
            }
        }
        if ((state & 0x40000000L) != 0L && leftNodeValue instanceof Number) {
            Number number = (Number)leftNodeValue;
            if (rightNodeValue instanceof Number) {
                rightNodeValue_ = (Number)rightNodeValue;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_)) {
                    return this.doNumber(number, (Number)rightNodeValue_);
                }
            }
        }
        if ((state & 0x380000000L) != 0L) {
            if ((state & 0x80000000L) != 0L) {
                void var5_28;
                ForeignObject0Data foreignObject0Data = this.foreignObject0_cache;
                while (var5_28 != null) {
                    if (var5_28.aInterop_.accepts(leftNodeValue) && var5_28.bInterop_.accepts(rightNodeValue) && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                        return JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, var5_28.aInterop_, var5_28.bInterop_);
                    }
                    ForeignObject0Data foreignObject0Data2 = var5_28.next_;
                }
            }
            if ((state & 0x100000000L) != 0L && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                return this.foreignObject1Boundary(state, leftNodeValue, rightNodeValue);
            }
            if ((state & 0x200000000L) != 0L && JSIdenticalNodeGen.fallbackGuard_(state, leftNodeValue, rightNodeValue)) {
                return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullA1Boundary(long state, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary nullA1_bInterop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue);
            boolean bl = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, nullA1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullB1Boundary(long state, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary nullB1_aInterop__ = INTEROP_LIBRARY_.getUncached(leftNodeValue);
            boolean bl = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, nullB1_aInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary(long state, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignObject1_aInterop__ = INTEROP_LIBRARY_.getUncached(leftNodeValue);
            InteropLibrary foreignObject1_bInterop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue);
            boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, foreignObject1_aInterop__, foreignObject1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        long state = this.state_;
        if ((state & 0x3FFFFFFFEL) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
            return this.executeBoolean_int_int0(frameValue, state);
        }
        if ((state & 0x3FFFFFFFDL) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
            return this.executeBoolean_double_double1(frameValue, state);
        }
        if ((state & 0x3FFFFFFFBL) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean_boolean2(frameValue, state);
        }
        if ((state & 0x3FFFFFFEFL) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
            return this.executeBoolean_double3(frameValue, state);
        }
        if ((state & 0x3FFFFFFDFL) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
            return this.executeBoolean_double4(frameValue, state);
        }
        return this.executeBoolean_generic5(frameValue, state);
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1L) != 0L);
        return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x3800000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x3400000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x2C00000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x38000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x34000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x2C000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x3800000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x3400000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 2L) != 0L);
        return this.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean2(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 4L) != 0L);
        return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double3(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x38000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x34000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x2C000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x10L) != 0L);
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x38000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)rightNodeValue_long : (Number)((state & 0x34000000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private boolean executeBoolean_double4(VirtualFrame frameValue, long state) {
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x3800000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x3400000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x2C00000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 0x20L) != 0L);
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x3800000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x3400000000L) == 0L && (state & 0x3FFFFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullA1Boundary0(long state, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary nullA1_bInterop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = JSIdenticalNode.doNullA(leftNodeValue_, rightNodeValue_, nullA1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullB1Boundary1(long state, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary nullB1_aInterop__ = INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            boolean bl = JSIdenticalNode.doNullB(leftNodeValue_, rightNodeValue_, nullB1_aInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary2(long state, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignObject1_aInterop__ = INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            InteropLibrary foreignObject1_bInterop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue_, rightNodeValue_, foreignObject1_aInterop__, foreignObject1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExplodeLoop
    private boolean executeBoolean_generic5(VirtualFrame frameValue, long state) {
        Object rightNodeValue__;
        CharSequence leftNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 1L) != 0L && leftNodeValue_ instanceof Integer) {
            int n = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof Integer) {
                int rightNodeValue__2 = (Integer)rightNodeValue_;
                return JSIdenticalNode.doInt(n, rightNodeValue__2);
            }
        }
        if ((state & 2L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue_)) {
                double rightNodeValue__3 = JSTypesGen.asImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue_);
                return this.doDouble(d, rightNodeValue__3);
            }
        }
        if ((state & 4L) != 0L && leftNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__4 = (Boolean)rightNodeValue_;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue__4);
            }
        }
        if ((state & 0x18L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if ((state & 8L) != 0L && rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__5 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue__5);
            }
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue_)) {
                double rightNodeValue__6 = JSTypesGen.asImplicitDouble((int)((state & 0x3C000000000L) >>> 38), rightNodeValue_);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue__6);
            }
        }
        if ((state & 0x20L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x3C00000000L) >>> 34), leftNodeValue_);
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__7 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue__7);
            }
        }
        if ((state & 0x1C0L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0xC0L) != 0L) {
                if ((state & 0x40L) != 0L && JSGuards.isUndefined(leftNodeValue_)) {
                    return JSIdenticalNode.doUndefinedA(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x80L) != 0L && JSGuards.isUndefined(rightNodeValue_)) {
                    return JSIdenticalNode.doUndefinedB(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x100L) != 0L && JSTypes.isDynamicObject(leftNodeValue_) && JSGuards.isJSObject(dynamicObject = (DynamicObject)leftNodeValue_)) {
                return JSIdenticalNode.doJSObjectA(dynamicObject, rightNodeValue_);
            }
        }
        if ((state & 0x1FE00L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0x200L) != 0L && JSTypes.isDynamicObject(rightNodeValue_) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue_)) {
                return JSIdenticalNode.doJSObjectB(leftNodeValue_, dynamicObject);
            }
            if ((state & 0x1FC00L) != 0L) {
                if ((state & 0x400L) != 0L && JSGuards.isJSNull(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return JSIdenticalNode.doNullNull(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x800L) != 0L && JSGuards.isJSNull(leftNodeValue_) && JSGuards.isUndefined(rightNodeValue_)) {
                    return JSIdenticalNode.doNullUndefined(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x1000L) != 0L && JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return JSIdenticalNode.doUndefinedNull(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x2000L) != 0L) {
                    void var6_13;
                    NullA0Data nullA0Data = this.nullA0_cache;
                    while (var6_13 != null) {
                        if (var6_13.bInterop_.accepts(rightNodeValue_) && JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isJSNull(rightNodeValue_) && !JSGuards.isUndefined(rightNodeValue_)) {
                            return JSIdenticalNode.doNullA(leftNodeValue_, rightNodeValue_, var6_13.bInterop_);
                        }
                        NullA0Data nullA0Data2 = var6_13.next_;
                    }
                }
                if ((state & 0x4000L) != 0L && JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isJSNull(rightNodeValue_) && !JSGuards.isUndefined(rightNodeValue_)) {
                    return this.nullA1Boundary0(state, leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x8000L) != 0L) {
                    void var6_16;
                    NullB0Data nullB0Data = this.nullB0_cache;
                    while (var6_16 != null) {
                        if (var6_16.aInterop_.accepts(leftNodeValue_) && !JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                            return JSIdenticalNode.doNullB(leftNodeValue_, rightNodeValue_, var6_16.aInterop_);
                        }
                        NullB0Data nullB0Data2 = var6_16.next_;
                    }
                }
                if ((state & 0x10000L) != 0L && !JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return this.nullB1Boundary1(state, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0xE0000L) != 0L && rightNodeValue_ instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue_;
            if ((state & 0x60000L) != 0L && leftNodeValue_ instanceof JSLazyString) {
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                if ((state & 0x20000L) != 0L && JSGuards.isReferenceEquals(leftNodeValue__, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue__, jSLazyString);
                }
                if ((state & 0x40000L) != 0L) {
                    return JSIdenticalNode.doLazyString(leftNodeValue__, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                }
            }
            if ((state & 0x80000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue_);
                return JSIdenticalNode.doStringLazyString((String)leftNodeValue__, jSLazyString, this.flattenB, this.sameLen);
            }
        }
        if ((state & 0x700000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C00000000000L) >>> 46), rightNodeValue_)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x3C00000000000L) >>> 46), rightNodeValue_);
            if ((state & 0x100000L) != 0L && leftNodeValue_ instanceof JSLazyString) {
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                return JSIdenticalNode.doLazyStringString(leftNodeValue__, string, this.flattenA, this.sameLen);
            }
            if ((state & 0x600000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x3C0000000000L) >>> 42), leftNodeValue_);
                if ((state & 0x200000L) != 0L && JSGuards.isReferenceEquals(leftNodeValue__, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue__, string);
                }
                if ((state & 0x400000L) != 0L) {
                    return JSIdenticalNode.doString((String)leftNodeValue__, string);
                }
            }
        }
        if ((state & 0x800000L) != 0L && leftNodeValue_ instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue_;
            if (rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue__);
            }
        }
        if ((state & 0x3F000000L) != 0L) {
            if ((state & 0x1000000L) != 0L && JSGuards.isBoolean(leftNodeValue_) != JSGuards.isBoolean(rightNodeValue_)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x2000000L) != 0L && JSGuards.isSymbol(leftNodeValue_) != JSGuards.isSymbol(rightNodeValue_)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x4000000L) != 0L) {
                void var6_22;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var6_22 != null) {
                    if (leftNodeValue_.getClass() == var6_22.cachedClassA_ && rightNodeValue_.getClass() == var6_22.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var6_22.cachedClassA_) || JSIdenticalNode.isNonObjectType(var6_22.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var6_22.cachedClassA_, var6_22.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue_, rightNodeValue_, var6_22.cachedClassA_, var6_22.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var6_22.next_;
                }
            }
            if ((state & 0x8000000L) != 0L && JSRuntime.isJavaNumber(leftNodeValue_) != JSRuntime.isJavaNumber(rightNodeValue_)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x10000000L) != 0L && JSRuntime.isString(leftNodeValue_) != JSRuntime.isString(rightNodeValue_)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x20000000L) != 0L) {
                void var6_25;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var6_25 != null) {
                    assert (var6_25.cachedClassA_ != null);
                    assert (var6_25.cachedClassB_ != null);
                    if (leftNodeValue_.getClass() == var6_25.cachedClassA_ && rightNodeValue_.getClass() == var6_25.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue_, rightNodeValue_, var6_25.cachedClassA_, var6_25.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var6_25.next_;
                }
            }
        }
        if ((state & 0x40000000L) != 0L && leftNodeValue_ instanceof Number) {
            Number number = (Number)leftNodeValue_;
            if (rightNodeValue_ instanceof Number) {
                rightNodeValue__ = (Number)rightNodeValue_;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue__)) {
                    return this.doNumber(number, (Number)rightNodeValue__);
                }
            }
        }
        if ((state & 0x380000000L) != 0L) {
            if ((state & 0x80000000L) != 0L) {
                void var6_29;
                ForeignObject0Data foreignObject0Data = this.foreignObject0_cache;
                while (var6_29 != null) {
                    if (var6_29.aInterop_.accepts(leftNodeValue_) && var6_29.bInterop_.accepts(rightNodeValue_) && JSRuntime.isForeignObject(leftNodeValue_) && JSRuntime.isForeignObject(rightNodeValue_)) {
                        return JSIdenticalNode.doForeignObject(leftNodeValue_, rightNodeValue_, var6_29.aInterop_, var6_29.bInterop_);
                    }
                    ForeignObject0Data foreignObject0Data2 = var6_29.next_;
                }
            }
            if ((state & 0x100000000L) != 0L && JSRuntime.isForeignObject(leftNodeValue_) && JSRuntime.isForeignObject(rightNodeValue_)) {
                return this.foreignObject1Boundary2(state, leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x200000000L) != 0L && JSIdenticalNodeGen.fallbackGuard_(state, leftNodeValue_, rightNodeValue_)) {
                return JSIdenticalNode.doFallback(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        long state = this.state_;
        int exclude = this.exclude_;
        long oldState = state & 0x3FFFFFFFFL;
        int oldExclude = exclude;
        int oldCacheCount = state == 0L ? 0 : this.countCaches();
        try {
            int n;
            CharSequence leftNodeValue_;
            boolean rightNodeValue_82;
            DynamicObject dynamicObject;
            DynamicObject dynamicObject2;
            int n2;
            int n3;
            if (leftNodeValue instanceof Integer) {
                int n4 = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_3 = (Integer)rightNodeValue;
                    this.state_ = state |= 1L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doInt(n4, rightNodeValue_3);
                    return bl;
                }
            }
            if ((n3 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_4 = JSTypesGen.asImplicitDouble(n3, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_4 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)n3 << 34;
                    state |= (long)doubleCast1 << 38;
                    this.state_ = state |= 2L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doDouble(leftNodeValue_4, rightNodeValue_4);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_5 = (Boolean)rightNodeValue;
                    this.state_ = state |= 4L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = JSIdenticalNode.doBoolean(bl, rightNodeValue_5);
                    return bl2;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_6 = (BigInt)rightNodeValue;
                    this.state_ = state |= 8L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigInt(bigInt, rightNodeValue_6);
                    return bl;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_7 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast1 << 38;
                    this.state_ = state |= 0x10L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_7);
                    return bl;
                }
            }
            if ((n2 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_6 = JSTypesGen.asImplicitDouble(n2, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_82 = (BigInt)rightNodeValue;
                    state |= (long)n2 << 34;
                    this.state_ = state |= 0x20L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doDoubleBigInt(leftNodeValue_6, rightNodeValue_82);
                    return bl;
                }
            }
            if (JSGuards.isUndefined(leftNodeValue)) {
                this.state_ = state |= 0x40L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(rightNodeValue)) {
                this.state_ = state |= 0x80L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject(dynamicObject2 = (DynamicObject)leftNodeValue)) {
                this.state_ = state |= 0x100L;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_6 = JSIdenticalNode.doJSObjectA(dynamicObject2, rightNodeValue);
                return leftNodeValue_6;
            }
            if (JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue)) {
                this.state_ = state |= 0x200L;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_6 = JSIdenticalNode.doJSObjectB(leftNodeValue, dynamicObject);
                return leftNodeValue_6;
            }
            if (JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                this.state_ = state |= 0x400L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
                this.state_ = state |= 0x800L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                this.state_ = state |= 0x1000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 1) == 0) {
                void var12_23;
                boolean bl = false;
                NullA0Data s14_ = this.nullA0_cache;
                if ((state & 0x2000L) != 0L) {
                    while (s14_ != null && (!s14_.bInterop_.accepts(rightNodeValue) || !JSGuards.isJSNull(leftNodeValue) || JSGuards.isJSNull(rightNodeValue) || JSGuards.isUndefined(rightNodeValue))) {
                        s14_ = s14_.next_;
                        ++var12_23;
                    }
                }
                if (s14_ == null && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue) && var12_23 < 5) {
                    s14_ = super.insert(new NullA0Data(this.nullA0_cache));
                    s14_.bInterop_ = s14_.insertAccessor(INTEROP_LIBRARY_.create(rightNodeValue));
                    this.nullA0_cache = s14_;
                    this.state_ = state |= 0x2000L;
                }
                if (s14_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_7 = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, s14_.bInterop_);
                    return rightNodeValue_7;
                }
            }
            Object var12_24 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_22 = encapsulating_.set(this);
            try {
                if (JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                    InteropLibrary interopLibrary = INTEROP_LIBRARY_.getUncached(rightNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.nullA0_cache = null;
                    state &= 0xFFFFFFFFFFFFDFFFL;
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, interopLibrary);
                    return rightNodeValue_82;
                }
            }
            finally {
                encapsulating_.set(prev_22);
            }
            if ((exclude & 2) == 0) {
                void var12_27;
                boolean bl = false;
                NullB0Data s16_ = this.nullB0_cache;
                if ((state & 0x8000L) != 0L) {
                    while (s16_ != null && (!s16_.aInterop_.accepts(leftNodeValue) || JSGuards.isJSNull(leftNodeValue) || JSGuards.isUndefined(leftNodeValue) || !JSGuards.isJSNull(rightNodeValue))) {
                        s16_ = s16_.next_;
                        ++var12_27;
                    }
                }
                if (s16_ == null && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue) && var12_27 < 5) {
                    s16_ = super.insert(new NullB0Data(this.nullB0_cache));
                    s16_.aInterop_ = s16_.insertAccessor(INTEROP_LIBRARY_.create(leftNodeValue));
                    this.nullB0_cache = s16_;
                    this.state_ = state |= 0x8000L;
                }
                if (s16_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean prev_22 = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, s16_.aInterop_);
                    return prev_22;
                }
            }
            Object var12_28 = null;
            encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_32 = encapsulating_.set(this);
            try {
                if (!JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    InteropLibrary interopLibrary = INTEROP_LIBRARY_.getUncached(leftNodeValue);
                    this.exclude_ = exclude |= 2;
                    this.nullB0_cache = null;
                    state &= 0xFFFFFFFFFFFF7FFFL;
                    this.state_ = state |= 0x10000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, interopLibrary);
                    return rightNodeValue_82;
                }
            }
            finally {
                encapsulating_.set(prev_32);
            }
            if (rightNodeValue instanceof JSLazyString) {
                JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
                if (leftNodeValue instanceof JSLazyString) {
                    JSLazyString leftNodeValue_7 = (JSLazyString)leftNodeValue;
                    if ((exclude & 4) == 0 && JSGuards.isReferenceEquals(leftNodeValue_7, jSLazyString)) {
                        this.state_ = state |= 0x20000L;
                        lock.unlock();
                        hasLock = false;
                        boolean prev_32 = JSIdenticalNode.doLazyStringReference(leftNodeValue_7, jSLazyString);
                        return prev_32;
                    }
                    if (this.flattenA == null) {
                        this.flattenA = ConditionProfile.createBinaryProfile();
                    }
                    if (this.flattenB == null) {
                        this.flattenB = ConditionProfile.createBinaryProfile();
                    }
                    if (this.sameLen == null) {
                        this.sameLen = ConditionProfile.createBinaryProfile();
                    }
                    this.exclude_ = exclude |= 4;
                    state &= 0xFFFFFFFFFFFDFFFFL;
                    this.state_ = state |= 0x40000L;
                    lock.unlock();
                    hasLock = false;
                    boolean prev_32 = JSIdenticalNode.doLazyString(leftNodeValue_7, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                    return prev_32;
                }
                int stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast0 != 0) {
                    leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                    if (this.flattenB == null) {
                        this.flattenB = ConditionProfile.createBinaryProfile();
                    }
                    if (this.sameLen == null) {
                        this.sameLen = ConditionProfile.createBinaryProfile();
                    }
                    state |= (long)stringCast0 << 42;
                    this.state_ = state |= 0x80000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doStringLazyString(leftNodeValue_, jSLazyString, this.flattenB, this.sameLen);
                    return rightNodeValue_82;
                }
            }
            if ((n = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                String rightNodeValue_10 = JSTypesGen.asImplicitString(n, rightNodeValue);
                if (leftNodeValue instanceof JSLazyString) {
                    leftNodeValue_ = (JSLazyString)leftNodeValue;
                    if (this.flattenA == null) {
                        this.flattenA = ConditionProfile.createBinaryProfile();
                    }
                    if (this.sameLen == null) {
                        this.sameLen = ConditionProfile.createBinaryProfile();
                    }
                    state |= (long)n << 46;
                    this.state_ = state |= 0x100000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doLazyStringString((JSLazyString)leftNodeValue_, rightNodeValue_10, this.flattenA, this.sameLen);
                    return rightNodeValue_82;
                }
                int stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast0 != 0) {
                    String leftNodeValue_8 = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                    if ((exclude & 8) == 0 && JSGuards.isReferenceEquals(leftNodeValue_8, rightNodeValue_10)) {
                        state |= (long)stringCast0 << 42;
                        state |= (long)n << 46;
                        this.state_ = state |= 0x200000L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSIdenticalNode.doStringIdentity(leftNodeValue_8, rightNodeValue_10);
                        return bl;
                    }
                    this.exclude_ = exclude |= 8;
                    state &= 0xFFFFFFFFFFDFFFFFL;
                    state |= (long)stringCast0 << 42;
                    state |= (long)n << 46;
                    this.state_ = state |= 0x400000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doString(leftNodeValue_8, rightNodeValue_10);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Symbol) {
                Symbol bl = (Symbol)leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_11 = (Symbol)rightNodeValue;
                    this.state_ = state |= 0x800000L;
                    lock.unlock();
                    hasLock = false;
                    boolean stringCast0 = JSIdenticalNode.doSymbol(bl, rightNodeValue_11);
                    return stringCast0;
                }
            }
            if (JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                this.state_ = state |= 0x1000000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                this.state_ = state |= 0x2000000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 0x10) == 0) {
                void var12_37;
                boolean bl = false;
                DifferentTypesCachedData s27_ = this.differentTypesCached_cache;
                if ((state & 0x4000000L) != 0L) {
                    while (s27_ != null) {
                        if (leftNodeValue.getClass() == s27_.cachedClassA_ && rightNodeValue.getClass() == s27_.cachedClassB_) {
                            assert (JSIdenticalNode.isNonObjectType(s27_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s27_.cachedClassB_));
                            assert (JSIdenticalNode.differentNonObjectTypes(s27_.cachedClassA_, s27_.cachedClassB_));
                            break;
                        }
                        s27_ = s27_.next_;
                        ++var12_37;
                    }
                }
                if (s27_ == null) {
                    Class<?> cachedClassA__ = leftNodeValue.getClass();
                    if (leftNodeValue.getClass() == cachedClassA__) {
                        Class<?> cachedClassB__ = rightNodeValue.getClass();
                        if (rightNodeValue.getClass() == cachedClassB__ && (JSIdenticalNode.isNonObjectType(cachedClassA__) || JSIdenticalNode.isNonObjectType(cachedClassB__)) && JSIdenticalNode.differentNonObjectTypes(cachedClassA__, cachedClassB__) && var12_37 < 3) {
                            s27_ = new DifferentTypesCachedData(this.differentTypesCached_cache);
                            s27_.cachedClassA_ = cachedClassA__;
                            s27_.cachedClassB_ = cachedClassB__;
                            this.differentTypesCached_cache = s27_;
                            this.state_ = state |= 0x4000000L;
                        }
                    }
                }
                if (s27_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__ = JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, s27_.cachedClassA_, s27_.cachedClassB_);
                    return cachedClassA__;
                }
            }
            if (JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                this.exclude_ = exclude |= 0x10;
                this.differentTypesCached_cache = null;
                state &= 0xFFFFFFFFFBFFFFFFL;
                this.state_ = state |= 0x8000000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                this.exclude_ = exclude |= 0x10;
                this.differentTypesCached_cache = null;
                state &= 0xFFFFFFFFFBFFFFFFL;
                this.state_ = state |= 0x10000000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 0x20) == 0) {
                Class<? extends Number> cachedClassB__1;
                Class<? extends Number> cachedClassA__122;
                void var12_41;
                boolean bl = false;
                NumberCachedData s30_ = this.numberCached_cache;
                if ((state & 0x20000000L) != 0L) {
                    while (s30_ != null) {
                        assert (s30_.cachedClassA_ != null);
                        assert (s30_.cachedClassB_ != null);
                        if (leftNodeValue.getClass() == s30_.cachedClassA_ && rightNodeValue.getClass() == s30_.cachedClassB_) break;
                        s30_ = s30_.next_;
                        ++var12_41;
                    }
                }
                if (s30_ == null && (cachedClassA__122 = JSGuards.getJavaNumberClass(leftNodeValue)) != null && (cachedClassB__1 = JSGuards.getJavaNumberClass(rightNodeValue)) != null && leftNodeValue.getClass() == cachedClassA__122 && rightNodeValue.getClass() == cachedClassB__1 && var12_41 < 3) {
                    s30_ = new NumberCachedData(this.numberCached_cache);
                    s30_.cachedClassA_ = cachedClassA__122;
                    s30_.cachedClassB_ = cachedClassB__1;
                    this.numberCached_cache = s30_;
                    this.state_ = state |= 0x20000000L;
                }
                if (s30_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__122 = this.doNumberCached(leftNodeValue, rightNodeValue, s30_.cachedClassA_, s30_.cachedClassB_);
                    return cachedClassA__122;
                }
            }
            if (leftNodeValue instanceof Number) {
                Number number = (Number)leftNodeValue;
                if (rightNodeValue instanceof Number) {
                    Number rightNodeValue_12 = (Number)rightNodeValue;
                    if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_12)) {
                        this.exclude_ = exclude |= 0x20;
                        this.numberCached_cache = null;
                        state &= 0xFFFFFFFFDFFFFFFFL;
                        this.state_ = state |= 0x40000000L;
                        lock.unlock();
                        hasLock = false;
                        boolean cachedClassA__122 = this.doNumber(number, rightNodeValue_12);
                        return cachedClassA__122;
                    }
                }
            }
            if ((exclude & 0x40) == 0) {
                void var12_44;
                boolean bl = false;
                ForeignObject0Data s32_ = this.foreignObject0_cache;
                if ((state & 0x80000000L) != 0L) {
                    while (!(s32_ == null || s32_.aInterop_.accepts(leftNodeValue) && s32_.bInterop_.accepts(rightNodeValue) && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue))) {
                        s32_ = s32_.next_;
                        ++var12_44;
                    }
                }
                if (s32_ == null && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue) && var12_44 < 5) {
                    s32_ = super.insert(new ForeignObject0Data(this.foreignObject0_cache));
                    s32_.aInterop_ = s32_.insertAccessor(INTEROP_LIBRARY_.create(leftNodeValue));
                    s32_.bInterop_ = s32_.insertAccessor(INTEROP_LIBRARY_.create(rightNodeValue));
                    this.foreignObject0_cache = s32_;
                    this.state_ = state |= 0x80000000L;
                }
                if (s32_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__122 = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, s32_.aInterop_, s32_.bInterop_);
                    return cachedClassA__122;
                }
            }
            Object var12_45 = null;
            InteropLibrary foreignObject1_aInterop__ = null;
            EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
            Node prev_4 = encapsulating_2.set(this);
            try {
                if (JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                    foreignObject1_aInterop__ = INTEROP_LIBRARY_.getUncached(leftNodeValue);
                    InteropLibrary interopLibrary = INTEROP_LIBRARY_.getUncached(rightNodeValue);
                    this.exclude_ = exclude |= 0x40;
                    this.foreignObject0_cache = null;
                    state &= 0xFFFFFFFF7FFFFFFFL;
                    this.state_ = state |= 0x100000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, foreignObject1_aInterop__, interopLibrary);
                    return bl;
                }
            }
            finally {
                encapsulating_2.set(prev_4);
            }
            this.state_ = state |= 0x200000000L;
            lock.unlock();
            hasLock = false;
            boolean bl = JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            return bl;
        }
        finally {
            if (oldState != 0L || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude, int oldCacheCount) {
        long newState = this.state_ & 0x3FFFFFFFFL;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0L || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        NullA0Data s14_ = this.nullA0_cache;
        while (s14_ != null) {
            ++cacheCount;
            s14_ = s14_.next_;
        }
        NullB0Data s16_ = this.nullB0_cache;
        while (s16_ != null) {
            ++cacheCount;
            s16_ = s16_.next_;
        }
        DifferentTypesCachedData s27_ = this.differentTypesCached_cache;
        while (s27_ != null) {
            ++cacheCount;
            s27_ = s27_.next_;
        }
        NumberCachedData s30_ = this.numberCached_cache;
        while (s30_ != null) {
            ++cacheCount;
            s30_ = s30_.next_;
        }
        ForeignObject0Data s32_ = this.foreignObject0_cache;
        while (s32_ != null) {
            ++cacheCount;
            s32_ = s32_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        long state = this.state_;
        if ((state & 0x3FFFFFFFFL) == 0L) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FFFFFFFFL & (state & 0x3FFFFFFFFL) - 1L) == 0L) {
            NullA0Data s14_ = this.nullA0_cache;
            NullB0Data s16_ = this.nullB0_cache;
            DifferentTypesCachedData s27_ = this.differentTypesCached_cache;
            NumberCachedData s30_ = this.numberCached_cache;
            ForeignObject0Data s32_ = this.foreignObject0_cache;
            if (!(s14_ != null && s14_.next_ != null || s16_ != null && s16_.next_ != null || s27_ != null && s27_.next_ != null || s30_ != null && s30_.next_ != null || s32_ != null && s32_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[35];
        data[0] = 0;
        long state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 2L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 4L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigIntDouble";
        s[1] = (state & 0x10L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleBigInt";
        s[1] = (state & 0x20L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doUndefinedA";
        s[1] = (state & 0x40L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doUndefinedB";
        s[1] = (state & 0x80L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectA";
        s[1] = (state & 0x100L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObjectB";
        s[1] = (state & 0x200L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doNullNull";
        s[1] = (state & 0x400L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doNullUndefined";
        s[1] = (state & 0x800L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doUndefinedNull";
        s[1] = (state & 0x1000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doNullA";
        if ((state & 0x2000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            NullA0Data s14_ = this.nullA0_cache;
            while (s14_ != null) {
                cached.add(Arrays.asList(s14_.bInterop_));
                s14_ = s14_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doNullA";
        if ((state & 0x4000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doNullB";
        if ((state & 0x8000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NullB0Data s16_ = this.nullB0_cache;
            while (s16_ != null) {
                cached.add(Arrays.asList(s16_.aInterop_));
                s16_ = s16_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "doNullB";
        if ((state & 0x10000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[17] = s;
        s = new Object[3];
        s[0] = "doLazyStringReference";
        s[1] = (state & 0x20000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[18] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 0x40000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenA, this.flattenB, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[19] = s;
        s = new Object[3];
        s[0] = "doStringLazyString";
        if ((state & 0x80000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenB, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[20] = s;
        s = new Object[3];
        s[0] = "doLazyStringString";
        if ((state & 0x100000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenA, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[21] = s;
        s = new Object[3];
        s[0] = "doStringIdentity";
        s[1] = (state & 0x200000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[22] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x400000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[23] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x800000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[24] = s;
        s = new Object[3];
        s[0] = "doBooleanNotBoolean";
        s[1] = (state & 0x1000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[25] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        s[1] = (state & 0x2000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[26] = s;
        s = new Object[3];
        s[0] = "doDifferentTypesCached";
        if ((state & 0x4000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            DifferentTypesCachedData s27_ = this.differentTypesCached_cache;
            while (s27_ != null) {
                cached.add(Arrays.asList(s27_.cachedClassA_, s27_.cachedClassB_));
                s27_ = s27_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[27] = s;
        s = new Object[3];
        s[0] = "doNumberNotNumber";
        s[1] = (state & 0x8000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[28] = s;
        s = new Object[3];
        s[0] = "doStringNotString";
        s[1] = (state & 0x10000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[29] = s;
        s = new Object[3];
        s[0] = "doNumberCached";
        if ((state & 0x20000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NumberCachedData s30_ = this.numberCached_cache;
            while (s30_ != null) {
                cached.add(Arrays.asList(s30_.cachedClassA_, s30_.cachedClassB_));
                s30_ = s30_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[30] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x40000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[31] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x80000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObject0Data s32_ = this.foreignObject0_cache;
            while (s32_ != null) {
                cached.add(Arrays.asList(s32_.aInterop_, s32_.bInterop_));
                s32_ = s32_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x40) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[32] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x100000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[33] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 0x200000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[34] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(long state, Object leftNodeValue, Object rightNodeValue) {
        Number rightNodeValue_;
        DynamicObject rightNodeValue_2;
        Object leftNodeValue_;
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if ((state & 4L) == 0L && leftNodeValue instanceof Boolean && rightNodeValue instanceof Boolean) {
            return false;
        }
        if (leftNodeValue instanceof BigInt) {
            if ((state & 8L) == 0L && rightNodeValue instanceof BigInt) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if ((state & 0x40L) == 0L && JSGuards.isUndefined(leftNodeValue)) {
            return false;
        }
        if ((state & 0x80L) == 0L && JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject((DynamicObject)(leftNodeValue_ = (DynamicObject)leftNodeValue))) {
            return false;
        }
        if (JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(rightNodeValue_2 = (DynamicObject)rightNodeValue)) {
            return false;
        }
        if ((state & 0x400L) == 0L && JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if ((state & 0x800L) == 0L && JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if ((state & 0x1000L) == 0L && JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if ((state & 0x4000L) == 0L && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if ((state & 0x10000L) == 0L && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitString(leftNodeValue) && JSTypesGen.isImplicitString(rightNodeValue)) {
            return false;
        }
        if ((state & 0x800000L) == 0L && leftNodeValue instanceof Symbol && rightNodeValue instanceof Symbol) {
            return false;
        }
        if ((state & 0x1000000L) == 0L && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
            return false;
        }
        if ((state & 0x2000000L) == 0L && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
            return false;
        }
        if ((state & 0x8000000L) == 0L && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
            return false;
        }
        if ((state & 0x10000000L) == 0L && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
            return false;
        }
        if (leftNodeValue instanceof Number && rightNodeValue instanceof Number && JSRuntime.isJavaNumber(leftNodeValue_ = (Number)leftNodeValue) && JSRuntime.isJavaNumber(rightNodeValue_ = (Number)rightNodeValue)) {
            return false;
        }
        return (state & 0x100000000L) != 0L || !JSRuntime.isForeignObject(leftNodeValue) || !JSRuntime.isForeignObject(rightNodeValue);
    }

    public static JSIdenticalNode create(JavaScriptNode left, JavaScriptNode right, int type) {
        return new JSIdenticalNodeGen(left, right, type);
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary aInterop_;
        @Node.Child
        InteropLibrary bInterop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NumberCachedData {
        @CompilerDirectives.CompilationFinal
        NumberCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        NumberCachedData(NumberCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class DifferentTypesCachedData {
        @CompilerDirectives.CompilationFinal
        DifferentTypesCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        DifferentTypesCachedData(DifferentTypesCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NullB0Data
    extends Node {
        @Node.Child
        NullB0Data next_;
        @Node.Child
        InteropLibrary aInterop_;

        NullB0Data(NullB0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NullA0Data
    extends Node {
        @Node.Child
        NullA0Data next_;
        @Node.Child
        InteropLibrary bInterop_;

        NullA0Data(NullA0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

