/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSEqualNode.class)
public final class JSEqualNodeGen
extends JSEqualNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile long state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private InteropLibrary bInterop;
    @Node.Child
    private InteropLibrary aInterop;
    @Node.Child
    private JSToPrimitiveNode toPrimitive;
    @Node.Child
    private JSEqualNode equal;
    @CompilerDirectives.CompilationFinal
    private NumberCachedData numberCached_cache;

    private JSEqualNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        Object rightNodeValue_;
        long state = this.state_;
        if ((state & 3L) != 0L && leftNodeValue instanceof Integer) {
            int n = (Integer)leftNodeValue;
            if ((state & 1L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                return JSEqualNode.doInt(n, rightNodeValue_2);
            }
            if ((state & 2L) != 0L && rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_3 = (Boolean)rightNodeValue;
                return JSEqualNode.doIntBoolean(n, rightNodeValue_3);
            }
        }
        if ((state & 4L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue)) {
                double rightNodeValue_4 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue);
                return JSEqualNode.doDouble(d, rightNodeValue_4);
            }
        }
        if ((state & 8L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_5 = (BigInt)rightNodeValue;
                return JSEqualNode.doBigInt(bigInt, rightNodeValue_5);
            }
        }
        if ((state & 0x30L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue);
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue)) {
                String rightNodeValue_6 = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue);
                return this.doDoubleString(d, rightNodeValue_6);
            }
            if ((state & 0x20L) != 0L && rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_7 = (Boolean)rightNodeValue;
                return JSEqualNode.doDoubleBoolean(d, rightNodeValue_7);
            }
        }
        if ((state & 0x3C0L) != 0L && leftNodeValue instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue;
            if ((state & 0x40L) != 0L && rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_8 = (Boolean)rightNodeValue;
                return JSEqualNode.doBoolean(bl, rightNodeValue_8);
            }
            if ((state & 0x80L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_9 = (Integer)rightNodeValue;
                return JSEqualNode.doBooleanInt(bl, rightNodeValue_9);
            }
            if ((state & 0x100L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue)) {
                double rightNodeValue_10 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue);
                return JSEqualNode.doBooleanDouble(bl, rightNodeValue_10);
            }
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue)) {
                String rightNodeValue_11 = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue);
                return this.doBooleanString(bl, rightNodeValue_11);
            }
        }
        if ((state & 0x7C00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue);
            if ((state & 0xC00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue)) {
                rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue);
                if ((state & 0x400L) != 0L && JSGuards.isReferenceEquals(string, rightNodeValue_)) {
                    return JSEqualNode.doStringIdentity(string, (String)rightNodeValue_);
                }
                if ((state & 0x800L) != 0L) {
                    return JSEqualNode.doString(string, (String)rightNodeValue_);
                }
            }
            if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue)) {
                double rightNodeValue_12 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue);
                return this.doStringDouble(string, rightNodeValue_12);
            }
            if ((state & 0x2000L) != 0L && rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_13 = (Boolean)rightNodeValue;
                return this.doStringBoolean(string, rightNodeValue_13);
            }
            if ((state & 0x4000L) != 0L && rightNodeValue instanceof BigInt) {
                rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doStringBigInt(string, (BigInt)rightNodeValue_);
            }
        }
        if ((state & 0x8000L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if (JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue)) {
                rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue);
                return this.doBigIntString(bigInt, (String)rightNodeValue_);
            }
        }
        if ((state & 0x10000L) != 0L && leftNodeValue instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBooleanBigInt(bl, (BigInt)rightNodeValue_);
            }
        }
        if ((state & 0x20000L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_14 = (Boolean)rightNodeValue;
                return this.doBigIntBoolean(bigInt, rightNodeValue_14);
            }
        }
        if ((state & 0x3C0000L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0x1C0000L) != 0L) {
                if ((state & 0x40000L) != 0L && JSRuntime.isNullOrUndefined(leftNodeValue) && JSRuntime.isNullOrUndefined(rightNodeValue)) {
                    return JSEqualNode.doBothNullOrUndefined(leftNodeValue, rightNodeValue);
                }
                if ((state & 0x80000L) != 0L && JSRuntime.isNullOrUndefined(leftNodeValue)) {
                    return JSEqualNode.doLeftNullOrUndefined(leftNodeValue, rightNodeValue, this.bInterop);
                }
                if ((state & 0x100000L) != 0L && JSRuntime.isNullOrUndefined(rightNodeValue)) {
                    return JSEqualNode.doRightNullOrUndefined(leftNodeValue, rightNodeValue, this.aInterop);
                }
            }
            if ((state & 0x200000L) != 0L && JSTypes.isDynamicObject(leftNodeValue) && JSRuntime.isObject(dynamicObject = (DynamicObject)leftNodeValue) && !JSRuntime.isObject(rightNodeValue)) {
                return this.doJSObject(dynamicObject, rightNodeValue, this.bInterop, this.toPrimitive, this.equal);
            }
        }
        if ((state & 0x400000L) != 0L && JSTypes.isDynamicObject(rightNodeValue)) {
            DynamicObject dynamicObject = (DynamicObject)rightNodeValue;
            if (!JSRuntime.isObject(leftNodeValue) && JSRuntime.isObject(dynamicObject)) {
                return this.doJSObject(leftNodeValue, dynamicObject, this.aInterop, this.toPrimitive, this.equal);
            }
        }
        if ((state & 0x1800000L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if ((state & 0x800000L) != 0L && rightNodeValue instanceof Integer) {
                int rightNodeValue_16 = (Integer)rightNodeValue;
                return this.doBigIntAndInt(bigInt, rightNodeValue_16);
            }
            if ((state & 0x1000000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue)) {
                double rightNodeValue_17 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue);
                return this.doBigIntAndNumber(bigInt, rightNodeValue_17);
            }
        }
        if ((state & 0x6000000L) != 0L && rightNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)rightNodeValue;
            if ((state & 0x2000000L) != 0L && leftNodeValue instanceof Integer) {
                int leftNodeValue_11 = (Integer)leftNodeValue;
                return this.doIntAndBigInt(leftNodeValue_11, bigInt);
            }
            if ((state & 0x4000000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue)) {
                double leftNodeValue_12 = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue);
                return this.doNumberAndBigInt(leftNodeValue_12, bigInt);
            }
        }
        if ((state & 0x8000000L) != 0L && JSTypes.isDynamicObject(leftNodeValue)) {
            DynamicObject dynamicObject = (DynamicObject)leftNodeValue;
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                rightNodeValue_ = (DynamicObject)rightNodeValue;
                if (!JSRuntime.isNullOrUndefined(dynamicObject) && JSGuards.isJSType(dynamicObject) && JSGuards.isJSType((DynamicObject)rightNodeValue_)) {
                    return JSEqualNode.doJSObject(dynamicObject, (DynamicObject)rightNodeValue_);
                }
            }
        }
        if ((state & 0x30000000L) != 0L && leftNodeValue instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue;
            if ((state & 0x10000000L) != 0L && rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                return JSEqualNode.doSymbol(symbol, (Symbol)rightNodeValue_);
            }
            if ((state & 0x20000000L) != 0L && !JSGuards.isSymbol(rightNodeValue) && !JSRuntime.isObject(rightNodeValue)) {
                return JSEqualNode.doSymbolNotSymbol(symbol, rightNodeValue);
            }
        }
        if ((state & 0x1C0000000L) != 0L) {
            if ((state & 0x40000000L) != 0L && rightNodeValue instanceof Symbol) {
                Symbol symbol = (Symbol)rightNodeValue;
                if (!JSGuards.isSymbol(leftNodeValue) && !JSRuntime.isObject(leftNodeValue)) {
                    return JSEqualNode.doSymbolNotSymbol(leftNodeValue, symbol);
                }
            }
            if ((state & 0x180000000L) != 0L) {
                if ((state & 0x80000000L) != 0L && (JSRuntime.isForeignObject(leftNodeValue) || JSRuntime.isForeignObject(rightNodeValue))) {
                    return this.doForeign(leftNodeValue, rightNodeValue, this.aInterop, this.bInterop, this.equal);
                }
                if ((state & 0x100000000L) != 0L && leftNodeValue != null && rightNodeValue != null) {
                    void var5_21;
                    NumberCachedData numberCachedData = this.numberCached_cache;
                    while (var5_21 != null) {
                        assert (var5_21.cachedClassA_ != null);
                        assert (var5_21.cachedClassB_ != null);
                        if (leftNodeValue.getClass() == var5_21.cachedClassA_ && rightNodeValue.getClass() == var5_21.cachedClassB_) {
                            return JSEqualNode.doNumberCached(leftNodeValue, rightNodeValue, var5_21.cachedClassA_, var5_21.cachedClassB_);
                        }
                        NumberCachedData numberCachedData2 = var5_21.next_;
                    }
                }
            }
        }
        if ((state & 0x200000000L) != 0L && leftNodeValue instanceof Number) {
            Number number = (Number)leftNodeValue;
            if (rightNodeValue instanceof Number) {
                rightNodeValue_ = (Number)rightNodeValue;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_)) {
                    return JSEqualNode.doNumber(number, (Number)rightNodeValue_);
                }
            }
        }
        if ((state & 0x400000000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue);
            if (JSRuntime.isJavaNumber(leftNodeValue)) {
                return this.doStringNumber(leftNodeValue, string);
            }
        }
        if ((state & 0x1800000000L) != 0L) {
            if ((state & 0x800000000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue)) {
                String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue);
                if (JSRuntime.isJavaNumber(rightNodeValue)) {
                    return this.doStringNumber(string, rightNodeValue);
                }
            }
            if ((state & 0x1000000000L) != 0L && JSEqualNodeGen.fallbackGuard_(state, leftNodeValue, rightNodeValue)) {
                return JSEqualNode.doFallback(leftNodeValue, rightNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        long state = this.state_;
        if ((state & 0x1FFFFFFFFEL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_int_int0(frameValue, state);
        }
        if ((state & 0x1FFFFFFFFDL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_int_boolean1(frameValue, state);
        }
        if ((state & 0x1FFFFFFFFBL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_double_double2(frameValue, state);
        }
        if ((state & 0x1FFFFFFFDFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_double_boolean3(frameValue, state);
        }
        if ((state & 0x1FFFFFFFBFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean_boolean4(frameValue, state);
        }
        if ((state & 0x1FFFFFFF7FL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean_int5(frameValue, state);
        }
        if ((state & 0x1FFFFFFEFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean_double6(frameValue, state);
        }
        if ((state & 0x1FFBFFFFCFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_double7(frameValue, state);
        }
        if ((state & 0x1FFFFEFDFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean8(frameValue, state);
        }
        if ((state & 0x1FFEFFEFFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_double9(frameValue, state);
        }
        if ((state & 0x1FFFFDDFFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_boolean10(frameValue, state);
        }
        if ((state & 0x1FFF7FFFFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_int11(frameValue, state);
        }
        if ((state & 0x1FFDFFFFFFL) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
            return this.executeBoolean_int12(frameValue, state);
        }
        return this.executeBoolean_generic13(frameValue, state);
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1L) != 0L);
        return JSEqualNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int_boolean1(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 2L) != 0L);
        return JSEqualNode.doIntBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double2(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 4L) != 0L);
        return JSEqualNode.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_boolean3(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 0x20L) != 0L);
        return JSEqualNode.doDoubleBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean4(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x40L) != 0L);
        return JSEqualNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_int5(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x80L) != 0L);
        return JSEqualNode.doBooleanInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_double6(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x100L) != 0L);
        return JSEqualNode.doBooleanDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double7(VirtualFrame frameValue, long state) {
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0x10L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
            String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
            return this.doDoubleString(leftNodeValue_, rightNodeValue__);
        }
        if ((state & 0x20L) != 0L && rightNodeValue_ instanceof Boolean) {
            boolean rightNodeValue__ = (Boolean)rightNodeValue_;
            return JSEqualNode.doDoubleBoolean(leftNodeValue_, rightNodeValue__);
        }
        if ((state & 0x4000000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return this.doNumberAndBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x1C000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), rightNodeValue_);
    }

    private boolean executeBoolean_boolean8(VirtualFrame frameValue, long state) {
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
            String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
            return this.doBooleanString(leftNodeValue_, rightNodeValue__);
        }
        if ((state & 0x10000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return this.doBooleanBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double9(VirtualFrame frameValue, long state) {
        Object leftNodeValue__;
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_)) {
            leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_);
            return this.doStringDouble((String)leftNodeValue__, rightNodeValue_);
        }
        if ((state & 0x1000000L) != 0L && leftNodeValue_ instanceof BigInt) {
            leftNodeValue__ = (BigInt)leftNodeValue_;
            return this.doBigIntAndNumber((BigInt)leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)rightNodeValue_long : (Number)((state & 0x1A0000000000L) == 0L && (state & 0x1FFFFFFFFFL) != 0L ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private boolean executeBoolean_boolean10(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0x2000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_)) {
            String leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_);
            return this.doStringBoolean(leftNodeValue__, rightNodeValue_);
        }
        if ((state & 0x20000L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return this.doBigIntBoolean(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int11(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x800000L) != 0L);
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return this.doBigIntAndInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_int12(VirtualFrame frameValue, long state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 0x2000000L) != 0L);
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return this.doIntAndBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - void declaration
     */
    @ExplodeLoop
    private boolean executeBoolean_generic13(VirtualFrame frameValue, long state) {
        Object rightNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3L) != 0L && leftNodeValue_ instanceof Integer) {
            int n = (Integer)leftNodeValue_;
            if ((state & 1L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__2 = (Integer)rightNodeValue_;
                return JSEqualNode.doInt(n, rightNodeValue__2);
            }
            if ((state & 2L) != 0L && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__3 = (Boolean)rightNodeValue_;
                return JSEqualNode.doIntBoolean(n, rightNodeValue__3);
            }
        }
        if ((state & 4L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_)) {
                double rightNodeValue__4 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_);
                return JSEqualNode.doDouble(d, rightNodeValue__4);
            }
        }
        if ((state & 8L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__5 = (BigInt)rightNodeValue_;
                return JSEqualNode.doBigInt(bigInt, rightNodeValue__5);
            }
        }
        if ((state & 0x30L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_);
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
                String rightNodeValue__6 = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
                return this.doDoubleString(d, rightNodeValue__6);
            }
            if ((state & 0x20L) != 0L && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__7 = (Boolean)rightNodeValue_;
                return JSEqualNode.doDoubleBoolean(d, rightNodeValue__7);
            }
        }
        if ((state & 0x3C0L) != 0L && leftNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue_;
            if ((state & 0x40L) != 0L && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__8 = (Boolean)rightNodeValue_;
                return JSEqualNode.doBoolean(bl, rightNodeValue__8);
            }
            if ((state & 0x80L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__9 = (Integer)rightNodeValue_;
                return JSEqualNode.doBooleanInt(bl, rightNodeValue__9);
            }
            if ((state & 0x100L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_)) {
                double rightNodeValue__10 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_);
                return JSEqualNode.doBooleanDouble(bl, rightNodeValue__10);
            }
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
                String rightNodeValue__11 = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
                return this.doBooleanString(bl, rightNodeValue__11);
            }
        }
        if ((state & 0x7C00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_);
            if ((state & 0xC00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
                rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
                if ((state & 0x400L) != 0L && JSGuards.isReferenceEquals(string, rightNodeValue__)) {
                    return JSEqualNode.doStringIdentity(string, (String)rightNodeValue__);
                }
                if ((state & 0x800L) != 0L) {
                    return JSEqualNode.doString(string, (String)rightNodeValue__);
                }
            }
            if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_)) {
                double rightNodeValue__12 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_);
                return this.doStringDouble(string, rightNodeValue__12);
            }
            if ((state & 0x2000L) != 0L && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__13 = (Boolean)rightNodeValue_;
                return this.doStringBoolean(string, rightNodeValue__13);
            }
            if ((state & 0x4000L) != 0L && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doStringBigInt(string, (BigInt)rightNodeValue__);
            }
        }
        if ((state & 0x8000L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if (JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
                rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
                return this.doBigIntString(bigInt, (String)rightNodeValue__);
            }
        }
        if ((state & 0x10000L) != 0L && leftNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBooleanBigInt(bl, (BigInt)rightNodeValue__);
            }
        }
        if ((state & 0x20000L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__14 = (Boolean)rightNodeValue_;
                return this.doBigIntBoolean(bigInt, rightNodeValue__14);
            }
        }
        if ((state & 0x3C0000L) != 0L) {
            DynamicObject dynamicObject;
            if ((state & 0x1C0000L) != 0L) {
                if ((state & 0x40000L) != 0L && JSRuntime.isNullOrUndefined(leftNodeValue_) && JSRuntime.isNullOrUndefined(rightNodeValue_)) {
                    return JSEqualNode.doBothNullOrUndefined(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0x80000L) != 0L && JSRuntime.isNullOrUndefined(leftNodeValue_)) {
                    return JSEqualNode.doLeftNullOrUndefined(leftNodeValue_, rightNodeValue_, this.bInterop);
                }
                if ((state & 0x100000L) != 0L && JSRuntime.isNullOrUndefined(rightNodeValue_)) {
                    return JSEqualNode.doRightNullOrUndefined(leftNodeValue_, rightNodeValue_, this.aInterop);
                }
            }
            if ((state & 0x200000L) != 0L && JSTypes.isDynamicObject(leftNodeValue_) && JSRuntime.isObject(dynamicObject = (DynamicObject)leftNodeValue_) && !JSRuntime.isObject(rightNodeValue_)) {
                return this.doJSObject(dynamicObject, rightNodeValue_, this.bInterop, this.toPrimitive, this.equal);
            }
        }
        if ((state & 0x400000L) != 0L && JSTypes.isDynamicObject(rightNodeValue_)) {
            DynamicObject dynamicObject = (DynamicObject)rightNodeValue_;
            if (!JSRuntime.isObject(leftNodeValue_) && JSRuntime.isObject(dynamicObject)) {
                return this.doJSObject(leftNodeValue_, dynamicObject, this.aInterop, this.toPrimitive, this.equal);
            }
        }
        if ((state & 0x1800000L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if ((state & 0x800000L) != 0L && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__16 = (Integer)rightNodeValue_;
                return this.doBigIntAndInt(bigInt, rightNodeValue__16);
            }
            if ((state & 0x1000000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_)) {
                double rightNodeValue__17 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000000L) >>> 41), rightNodeValue_);
                return this.doBigIntAndNumber(bigInt, rightNodeValue__17);
            }
        }
        if ((state & 0x6000000L) != 0L && rightNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)rightNodeValue_;
            if ((state & 0x2000000L) != 0L && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__11 = (Integer)leftNodeValue_;
                return this.doIntAndBigInt(leftNodeValue__11, bigInt);
            }
            if ((state & 0x4000000L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_)) {
                double leftNodeValue__12 = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000000L) >>> 37), leftNodeValue_);
                return this.doNumberAndBigInt(leftNodeValue__12, bigInt);
            }
        }
        if ((state & 0x8000000L) != 0L && JSTypes.isDynamicObject(leftNodeValue_)) {
            DynamicObject dynamicObject = (DynamicObject)leftNodeValue_;
            if (JSTypes.isDynamicObject(rightNodeValue_)) {
                rightNodeValue__ = (DynamicObject)rightNodeValue_;
                if (!JSRuntime.isNullOrUndefined(dynamicObject) && JSGuards.isJSType(dynamicObject) && JSGuards.isJSType((DynamicObject)rightNodeValue__)) {
                    return JSEqualNode.doJSObject(dynamicObject, (DynamicObject)rightNodeValue__);
                }
            }
        }
        if ((state & 0x30000000L) != 0L && leftNodeValue_ instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue_;
            if ((state & 0x10000000L) != 0L && rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return JSEqualNode.doSymbol(symbol, (Symbol)rightNodeValue__);
            }
            if ((state & 0x20000000L) != 0L && !JSGuards.isSymbol(rightNodeValue_) && !JSRuntime.isObject(rightNodeValue_)) {
                return JSEqualNode.doSymbolNotSymbol(symbol, rightNodeValue_);
            }
        }
        if ((state & 0x1C0000000L) != 0L) {
            if ((state & 0x40000000L) != 0L && rightNodeValue_ instanceof Symbol) {
                Symbol symbol = (Symbol)rightNodeValue_;
                if (!JSGuards.isSymbol(leftNodeValue_) && !JSRuntime.isObject(leftNodeValue_)) {
                    return JSEqualNode.doSymbolNotSymbol(leftNodeValue_, symbol);
                }
            }
            if ((state & 0x180000000L) != 0L) {
                if ((state & 0x80000000L) != 0L && (JSRuntime.isForeignObject(leftNodeValue_) || JSRuntime.isForeignObject(rightNodeValue_))) {
                    return this.doForeign(leftNodeValue_, rightNodeValue_, this.aInterop, this.bInterop, this.equal);
                }
                if ((state & 0x100000000L) != 0L && leftNodeValue_ != null && rightNodeValue_ != null) {
                    void var6_22;
                    NumberCachedData numberCachedData = this.numberCached_cache;
                    while (var6_22 != null) {
                        assert (var6_22.cachedClassA_ != null);
                        assert (var6_22.cachedClassB_ != null);
                        if (leftNodeValue_.getClass() == var6_22.cachedClassA_ && rightNodeValue_.getClass() == var6_22.cachedClassB_) {
                            return JSEqualNode.doNumberCached(leftNodeValue_, rightNodeValue_, var6_22.cachedClassA_, var6_22.cachedClassB_);
                        }
                        NumberCachedData numberCachedData2 = var6_22.next_;
                    }
                }
            }
        }
        if ((state & 0x200000000L) != 0L && leftNodeValue_ instanceof Number) {
            Number number = (Number)leftNodeValue_;
            if (rightNodeValue_ instanceof Number) {
                rightNodeValue__ = (Number)rightNodeValue_;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue__)) {
                    return JSEqualNode.doNumber(number, (Number)rightNodeValue__);
                }
            }
        }
        if ((state & 0x400000000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E00000000000L) >>> 45), rightNodeValue_);
            if (JSRuntime.isJavaNumber(leftNodeValue_)) {
                return this.doStringNumber(leftNodeValue_, string);
            }
        }
        if ((state & 0x1800000000L) != 0L) {
            if ((state & 0x800000000L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_)) {
                String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000000L) >>> 49), leftNodeValue_);
                if (JSRuntime.isJavaNumber(rightNodeValue_)) {
                    return this.doStringNumber(string, rightNodeValue_);
                }
            }
            if ((state & 0x1000000000L) != 0L && JSEqualNodeGen.fallbackGuard_(state, leftNodeValue_, rightNodeValue_)) {
                return JSEqualNode.doFallback(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        long state = this.state_;
        int exclude = this.exclude_;
        long oldState = state & 0x1FFFFFFFFFL;
        int oldExclude = exclude;
        int oldCacheCount = state == 0L ? 0 : this.countCaches();
        try {
            int stringCast1;
            boolean leftNodeValue_13;
            DynamicObject leftNodeValue_2;
            boolean rightNodeValue_;
            int stringCast0;
            boolean rightNodeValue_2;
            double leftNodeValue_3;
            int doubleCast0;
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_4 = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_3 = (Integer)rightNodeValue;
                    this.state_ = state |= 1L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doInt(leftNodeValue_4, rightNodeValue_3);
                    return bl;
                }
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                    this.state_ = state |= 2L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doIntBoolean(leftNodeValue_4, rightNodeValue_4);
                    return bl;
                }
            }
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                leftNodeValue_3 = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_5 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast0 << 37;
                    state |= (long)doubleCast1 << 41;
                    this.state_ = state |= 4L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doDouble(leftNodeValue_3, rightNodeValue_5);
                    return bl;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_5 = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_6 = (BigInt)rightNodeValue;
                    this.state_ = state |= 8L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doBigInt(leftNodeValue_5, rightNodeValue_6);
                    return bl;
                }
            }
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                leftNodeValue_3 = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int stringCast12 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast12 != 0) {
                    String rightNodeValue_7 = JSTypesGen.asImplicitString(stringCast12, rightNodeValue);
                    state |= (long)doubleCast0 << 37;
                    state |= (long)stringCast12 << 45;
                    this.state_ = state |= 0x10L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doDoubleString(leftNodeValue_3, rightNodeValue_7);
                    return bl;
                }
                if (rightNodeValue instanceof Boolean) {
                    rightNodeValue_2 = (Boolean)rightNodeValue;
                    state |= (long)doubleCast0 << 37;
                    this.state_ = state |= 0x20L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doDoubleBoolean(leftNodeValue_3, rightNodeValue_2);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_6 = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_8 = (Boolean)rightNodeValue;
                    this.state_ = state |= 0x40L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doBoolean(leftNodeValue_6, rightNodeValue_8);
                    return bl;
                }
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_9 = (Integer)rightNodeValue;
                    this.state_ = state |= 0x80L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doBooleanInt(leftNodeValue_6, rightNodeValue_9);
                    return bl;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_10 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast1 << 41;
                    this.state_ = state |= 0x100L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doBooleanDouble(leftNodeValue_6, rightNodeValue_10);
                    return bl;
                }
                int stringCast13 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast13 != 0) {
                    String rightNodeValue_11 = JSTypesGen.asImplicitString(stringCast13, rightNodeValue);
                    state |= (long)stringCast13 << 45;
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_2 = this.doBooleanString(leftNodeValue_6, rightNodeValue_11);
                    return rightNodeValue_2;
                }
            }
            if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                String leftNodeValue_7 = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                int stringCast14 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast14 != 0) {
                    String rightNodeValue_12 = JSTypesGen.asImplicitString(stringCast14, rightNodeValue);
                    if ((exclude & 1) == 0 && JSGuards.isReferenceEquals(leftNodeValue_7, rightNodeValue_12)) {
                        state |= (long)stringCast0 << 49;
                        state |= (long)stringCast14 << 45;
                        this.state_ = state |= 0x400L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSEqualNode.doStringIdentity(leftNodeValue_7, rightNodeValue_12);
                        return bl;
                    }
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFFFFFFFBFFL;
                    state |= (long)stringCast0 << 49;
                    state |= (long)stringCast14 << 45;
                    this.state_ = state |= 0x800L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doString(leftNodeValue_7, rightNodeValue_12);
                    return bl;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_13 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)stringCast0 << 49;
                    state |= (long)doubleCast1 << 41;
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doStringDouble(leftNodeValue_7, rightNodeValue_13);
                    return bl;
                }
                if (rightNodeValue instanceof Boolean) {
                    rightNodeValue_ = (Boolean)rightNodeValue;
                    state |= (long)stringCast0 << 49;
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_2 = this.doStringBoolean(leftNodeValue_7, rightNodeValue_);
                    return rightNodeValue_2;
                }
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_14 = (BigInt)rightNodeValue;
                    state |= (long)stringCast0 << 49;
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_2 = this.doStringBigInt(leftNodeValue_7, rightNodeValue_14);
                    return rightNodeValue_2;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_8 = (BigInt)leftNodeValue;
                int stringCast15 = JSTypesGen.specializeImplicitString(rightNodeValue);
                if (stringCast15 != 0) {
                    String rightNodeValue_15 = JSTypesGen.asImplicitString(stringCast15, rightNodeValue);
                    state |= (long)stringCast15 << 45;
                    this.state_ = state |= 0x8000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_2 = this.doBigIntString(leftNodeValue_8, rightNodeValue_15);
                    return rightNodeValue_2;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_9 = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_16 = (BigInt)rightNodeValue;
                    this.state_ = state |= 0x10000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_ = this.doBooleanBigInt(leftNodeValue_9, rightNodeValue_16);
                    return rightNodeValue_;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_10 = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_17 = (Boolean)rightNodeValue;
                    this.state_ = state |= 0x20000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_ = this.doBigIntBoolean(leftNodeValue_10, rightNodeValue_17);
                    return rightNodeValue_;
                }
            }
            if (JSRuntime.isNullOrUndefined(leftNodeValue) && JSRuntime.isNullOrUndefined(rightNodeValue)) {
                this.state_ = state |= 0x40000L;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_10 = JSEqualNode.doBothNullOrUndefined(leftNodeValue, rightNodeValue);
                return leftNodeValue_10;
            }
            if (JSRuntime.isNullOrUndefined(leftNodeValue)) {
                if (this.bInterop == null) {
                    this.bInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                }
                this.state_ = state |= 0x80000L;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_10 = JSEqualNode.doLeftNullOrUndefined(leftNodeValue, rightNodeValue, this.bInterop);
                return leftNodeValue_10;
            }
            if (JSRuntime.isNullOrUndefined(rightNodeValue)) {
                if (this.aInterop == null) {
                    this.aInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                }
                this.state_ = state |= 0x100000L;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_10 = JSEqualNode.doRightNullOrUndefined(leftNodeValue, rightNodeValue, this.aInterop);
                return leftNodeValue_10;
            }
            if (JSTypes.isDynamicObject(leftNodeValue) && JSRuntime.isObject(leftNodeValue_2 = (DynamicObject)leftNodeValue) && !JSRuntime.isObject(rightNodeValue)) {
                if (this.bInterop == null) {
                    this.bInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                }
                if (this.toPrimitive == null) {
                    this.toPrimitive = super.insert(JSToPrimitiveNode.createHintNone());
                }
                if (this.equal == null) {
                    this.equal = super.insert(JSEqualNode.create());
                }
                this.state_ = state |= 0x200000L;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_17 = this.doJSObject(leftNodeValue_2, rightNodeValue, this.bInterop, this.toPrimitive, this.equal);
                return rightNodeValue_17;
            }
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_18 = (DynamicObject)rightNodeValue;
                if (!JSRuntime.isObject(leftNodeValue) && JSRuntime.isObject(rightNodeValue_18)) {
                    if (this.aInterop == null) {
                        this.aInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    if (this.toPrimitive == null) {
                        this.toPrimitive = super.insert(JSToPrimitiveNode.createHintNone());
                    }
                    if (this.equal == null) {
                        this.equal = super.insert(JSEqualNode.create());
                    }
                    this.state_ = state |= 0x400000L;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_17 = this.doJSObject(leftNodeValue, rightNodeValue_18, this.aInterop, this.toPrimitive, this.equal);
                    return rightNodeValue_17;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_11 = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_19 = (Integer)rightNodeValue;
                    this.state_ = state |= 0x800000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_ = this.doBigIntAndInt(leftNodeValue_11, rightNodeValue_19);
                    return rightNodeValue_;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_20 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast1 << 41;
                    this.state_ = state |= 0x1000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doBigIntAndNumber(leftNodeValue_11, rightNodeValue_20);
                    return bl;
                }
            }
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_21 = (BigInt)rightNodeValue;
                if (leftNodeValue instanceof Integer) {
                    int leftNodeValue_12 = (Integer)leftNodeValue;
                    this.state_ = state |= 0x2000000L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_ = this.doIntAndBigInt(leftNodeValue_12, rightNodeValue_21);
                    return rightNodeValue_;
                }
                int doubleCast02 = JSTypesGen.specializeImplicitDouble(leftNodeValue);
                if (doubleCast02 != 0) {
                    double leftNodeValue_13 = JSTypesGen.asImplicitDouble(doubleCast02, leftNodeValue);
                    state |= (long)doubleCast02 << 37;
                    this.state_ = state |= 0x4000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doNumberAndBigInt(leftNodeValue_13, rightNodeValue_21);
                    return bl;
                }
            }
            if (JSTypes.isDynamicObject(leftNodeValue)) {
                DynamicObject leftNodeValue_14 = (DynamicObject)leftNodeValue;
                if (JSTypes.isDynamicObject(rightNodeValue)) {
                    DynamicObject rightNodeValue_22 = (DynamicObject)rightNodeValue;
                    if (!JSRuntime.isNullOrUndefined(leftNodeValue_14) && JSGuards.isJSType(leftNodeValue_14) && JSGuards.isJSType(rightNodeValue_22)) {
                        this.state_ = state |= 0x8000000L;
                        lock.unlock();
                        hasLock = false;
                        leftNodeValue_13 = JSEqualNode.doJSObject(leftNodeValue_14, rightNodeValue_22);
                        return leftNodeValue_13;
                    }
                }
            }
            if (leftNodeValue instanceof Symbol) {
                Symbol leftNodeValue_15 = (Symbol)leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_23 = (Symbol)rightNodeValue;
                    this.state_ = state |= 0x10000000L;
                    lock.unlock();
                    hasLock = false;
                    leftNodeValue_13 = JSEqualNode.doSymbol(leftNodeValue_15, rightNodeValue_23);
                    return leftNodeValue_13;
                }
                if (!JSGuards.isSymbol(rightNodeValue) && !JSRuntime.isObject(rightNodeValue)) {
                    this.state_ = state |= 0x20000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_23 = JSEqualNode.doSymbolNotSymbol(leftNodeValue_15, rightNodeValue);
                    return rightNodeValue_23;
                }
            }
            if (rightNodeValue instanceof Symbol) {
                Symbol rightNodeValue_24 = (Symbol)rightNodeValue;
                if (!JSGuards.isSymbol(leftNodeValue) && !JSRuntime.isObject(leftNodeValue)) {
                    this.state_ = state |= 0x40000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_23 = JSEqualNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue_24);
                    return rightNodeValue_23;
                }
            }
            if (JSRuntime.isForeignObject(leftNodeValue) || JSRuntime.isForeignObject(rightNodeValue)) {
                if (this.aInterop == null) {
                    this.aInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                }
                if (this.bInterop == null) {
                    this.bInterop = super.insert(INTEROP_LIBRARY_.createDispatched(5));
                }
                if (this.equal == null) {
                    this.equal = super.insert(JSEqualNode.create());
                }
                this.state_ = state |= 0x80000000L;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_24 = this.doForeign(leftNodeValue, rightNodeValue, this.aInterop, this.bInterop, this.equal);
                return rightNodeValue_24;
            }
            if ((exclude & 2) == 0 && leftNodeValue != null && rightNodeValue != null) {
                Class<? extends Number> cachedClassB__;
                Class<? extends Number> cachedClassA__;
                int count33_ = 0;
                NumberCachedData s33_ = this.numberCached_cache;
                if ((state & 0x100000000L) != 0L) {
                    while (s33_ != null) {
                        assert (s33_.cachedClassA_ != null);
                        assert (s33_.cachedClassB_ != null);
                        if (leftNodeValue.getClass() == s33_.cachedClassA_ && rightNodeValue.getClass() == s33_.cachedClassB_) break;
                        s33_ = s33_.next_;
                        ++count33_;
                    }
                }
                if (s33_ == null && (cachedClassA__ = JSGuards.getJavaNumberClass(leftNodeValue)) != null && (cachedClassB__ = JSGuards.getJavaNumberClass(rightNodeValue)) != null && leftNodeValue.getClass() == cachedClassA__ && rightNodeValue.getClass() == cachedClassB__ && count33_ < 3) {
                    s33_ = new NumberCachedData(this.numberCached_cache);
                    s33_.cachedClassA_ = cachedClassA__;
                    s33_.cachedClassB_ = cachedClassB__;
                    this.numberCached_cache = s33_;
                    this.state_ = state |= 0x100000000L;
                }
                if (s33_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSEqualNode.doNumberCached(leftNodeValue, rightNodeValue, s33_.cachedClassA_, s33_.cachedClassB_);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Number) {
                Number leftNodeValue_16 = (Number)leftNodeValue;
                if (rightNodeValue instanceof Number) {
                    Number rightNodeValue_25 = (Number)rightNodeValue;
                    if (JSRuntime.isJavaNumber(leftNodeValue_16) && JSRuntime.isJavaNumber(rightNodeValue_25)) {
                        this.exclude_ = exclude |= 2;
                        this.numberCached_cache = null;
                        state &= 0xFFFFFFFEFFFFFFFFL;
                        this.state_ = state |= 0x200000000L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSEqualNode.doNumber(leftNodeValue_16, rightNodeValue_25);
                        return bl;
                    }
                }
            }
            if ((stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                String rightNodeValue_26 = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                if (JSRuntime.isJavaNumber(leftNodeValue)) {
                    state |= (long)stringCast1 << 45;
                    this.state_ = state |= 0x400000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doStringNumber(leftNodeValue, rightNodeValue_26);
                    return bl;
                }
            }
            if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                String leftNodeValue_17 = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                if (JSRuntime.isJavaNumber(rightNodeValue)) {
                    state |= (long)stringCast0 << 49;
                    this.state_ = state |= 0x800000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doStringNumber(leftNodeValue_17, rightNodeValue);
                    return bl;
                }
            }
            this.state_ = state |= 0x1000000000L;
            lock.unlock();
            hasLock = false;
            boolean bl = JSEqualNode.doFallback(leftNodeValue, rightNodeValue);
            return bl;
        }
        finally {
            if (oldState != 0L || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude, int oldCacheCount) {
        long newState = this.state_ & 0x1FFFFFFFFFL;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0L || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        NumberCachedData s33_ = this.numberCached_cache;
        while (s33_ != null) {
            ++cacheCount;
            s33_ = s33_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        NumberCachedData s33_;
        long state = this.state_;
        if ((state & 0x1FFFFFFFFFL) == 0L) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFFFFFFFFL & (state & 0x1FFFFFFFFFL) - 1L) == 0L && ((s33_ = this.numberCached_cache) == null || s33_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[38];
        data[0] = 0;
        long state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doIntBoolean";
        s[1] = (state & 2L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 4L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDoubleString";
        s[1] = (state & 0x10L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleBoolean";
        s[1] = (state & 0x20L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x40L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBooleanInt";
        s[1] = (state & 0x80L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBooleanDouble";
        s[1] = (state & 0x100L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doBooleanString";
        s[1] = (state & 0x200L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doStringIdentity";
        s[1] = (state & 0x400L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[11] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x800L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doStringDouble";
        s[1] = (state & 0x1000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doStringBoolean";
        s[1] = (state & 0x2000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "doStringBigInt";
        s[1] = (state & 0x4000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        s = new Object[3];
        s[0] = "doBigIntString";
        s[1] = (state & 0x8000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[16] = s;
        s = new Object[3];
        s[0] = "doBooleanBigInt";
        s[1] = (state & 0x10000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[17] = s;
        s = new Object[3];
        s[0] = "doBigIntBoolean";
        s[1] = (state & 0x20000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[18] = s;
        s = new Object[3];
        s[0] = "doBothNullOrUndefined";
        s[1] = (state & 0x40000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[19] = s;
        s = new Object[3];
        s[0] = "doLeftNullOrUndefined";
        if ((state & 0x80000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.bInterop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[20] = s;
        s = new Object[3];
        s[0] = "doRightNullOrUndefined";
        if ((state & 0x100000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.aInterop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[21] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x200000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.bInterop, this.toPrimitive, this.equal));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[22] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x400000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.aInterop, this.toPrimitive, this.equal));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[23] = s;
        s = new Object[3];
        s[0] = "doBigIntAndInt";
        s[1] = (state & 0x800000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[24] = s;
        s = new Object[3];
        s[0] = "doBigIntAndNumber";
        s[1] = (state & 0x1000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[25] = s;
        s = new Object[3];
        s[0] = "doIntAndBigInt";
        s[1] = (state & 0x2000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[26] = s;
        s = new Object[3];
        s[0] = "doNumberAndBigInt";
        s[1] = (state & 0x4000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[27] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 0x8000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[28] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x10000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[29] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        s[1] = (state & 0x20000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[30] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        s[1] = (state & 0x40000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[31] = s;
        s = new Object[3];
        s[0] = "doForeign";
        if ((state & 0x80000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.aInterop, this.bInterop, this.equal));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[32] = s;
        s = new Object[3];
        s[0] = "doNumberCached";
        if ((state & 0x100000000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NumberCachedData s33_ = this.numberCached_cache;
            while (s33_ != null) {
                cached.add(Arrays.asList(s33_.cachedClassA_, s33_.cachedClassB_));
                s33_ = s33_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[33] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x200000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[34] = s;
        s = new Object[3];
        s[0] = "doStringNumber";
        s[1] = (state & 0x400000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[35] = s;
        s = new Object[3];
        s[0] = "doStringNumber";
        s[1] = (state & 0x800000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[36] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 0x1000000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[37] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(long state, Object leftNodeValue, Object rightNodeValue) {
        Object rightNodeValue_;
        DynamicObject rightNodeValue_2;
        Object leftNodeValue_;
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if ((state & 8L) == 0L && leftNodeValue instanceof BigInt && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue)) {
            if (JSTypesGen.isImplicitString(rightNodeValue)) {
                return false;
            }
            if ((state & 0x20L) == 0L && rightNodeValue instanceof Boolean) {
                return false;
            }
        }
        if (leftNodeValue instanceof Boolean) {
            if ((state & 0x40L) == 0L && rightNodeValue instanceof Boolean) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
            if (JSTypesGen.isImplicitString(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitString(leftNodeValue)) {
            if (JSTypesGen.isImplicitString(rightNodeValue)) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
            if ((state & 0x2000L) == 0L && rightNodeValue instanceof Boolean) {
                return false;
            }
            if ((state & 0x4000L) == 0L && rightNodeValue instanceof BigInt) {
                return false;
            }
        }
        if (leftNodeValue instanceof BigInt && JSTypesGen.isImplicitString(rightNodeValue)) {
            return false;
        }
        if ((state & 0x10000L) == 0L && leftNodeValue instanceof Boolean && rightNodeValue instanceof BigInt) {
            return false;
        }
        if ((state & 0x20000L) == 0L && leftNodeValue instanceof BigInt && rightNodeValue instanceof Boolean) {
            return false;
        }
        if ((state & 0x40000L) == 0L && JSRuntime.isNullOrUndefined(leftNodeValue) && JSRuntime.isNullOrUndefined(rightNodeValue)) {
            return false;
        }
        if ((state & 0x80000L) == 0L && JSRuntime.isNullOrUndefined(leftNodeValue)) {
            return false;
        }
        if ((state & 0x100000L) == 0L && JSRuntime.isNullOrUndefined(rightNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(leftNodeValue) && JSRuntime.isObject((DynamicObject)(leftNodeValue_ = (DynamicObject)leftNodeValue)) && !JSRuntime.isObject(rightNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(rightNodeValue) && !JSRuntime.isObject(leftNodeValue) && JSRuntime.isObject(rightNodeValue_2 = (DynamicObject)rightNodeValue)) {
            return false;
        }
        if (leftNodeValue instanceof BigInt && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (JSTypes.isDynamicObject(leftNodeValue) && JSTypes.isDynamicObject(rightNodeValue) && !JSRuntime.isNullOrUndefined((DynamicObject)(leftNodeValue_ = (DynamicObject)leftNodeValue)) && JSGuards.isJSType((DynamicObject)leftNodeValue_) && JSGuards.isJSType((DynamicObject)(rightNodeValue_ = (DynamicObject)rightNodeValue))) {
            return false;
        }
        if (leftNodeValue instanceof Symbol) {
            if ((state & 0x10000000L) == 0L && rightNodeValue instanceof Symbol) {
                return false;
            }
            if ((state & 0x20000000L) == 0L && !JSGuards.isSymbol(rightNodeValue) && !JSRuntime.isObject(rightNodeValue)) {
                return false;
            }
        }
        if ((state & 0x40000000L) == 0L && rightNodeValue instanceof Symbol && !JSGuards.isSymbol(leftNodeValue) && !JSRuntime.isObject(leftNodeValue)) {
            return false;
        }
        if ((state & 0x80000000L) == 0L && (JSRuntime.isForeignObject(leftNodeValue) || JSRuntime.isForeignObject(rightNodeValue))) {
            return false;
        }
        if (leftNodeValue instanceof Number && rightNodeValue instanceof Number && JSRuntime.isJavaNumber(leftNodeValue_ = (Number)leftNodeValue) && JSRuntime.isJavaNumber(rightNodeValue_ = (Number)rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitString(rightNodeValue) && JSRuntime.isJavaNumber(leftNodeValue)) {
            return false;
        }
        return !JSTypesGen.isImplicitString(leftNodeValue) || !JSRuntime.isJavaNumber(rightNodeValue);
    }

    public static JSEqualNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSEqualNodeGen(left, right);
    }

    @GeneratedBy(value=JSEqualNode.class)
    private static final class NumberCachedData {
        @CompilerDirectives.CompilationFinal
        NumberCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        NumberCachedData(NumberCachedData next_) {
            this.next_ = next_;
        }
    }
}

