/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSConcatStringsNode.class)
public final class JSConcatStringsNodeGen
extends JSConcatStringsNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private ConcatData concat_cache;

    private JSConcatStringsNodeGen(int stringLengthLimit) {
        super(stringLengthLimit);
    }

    @Override
    public CharSequence executeCharSequence(CharSequence arg0Value, CharSequence arg1Value) {
        int state = this.state_;
        if ((state & 7) != 0) {
            ConcatData s3_;
            if ((state & 1) != 0 && JSConcatStringsNode.isEmptyString(arg0Value)) {
                return JSConcatStringsNode.doLeftEmpty(arg0Value, arg1Value);
            }
            if ((state & 2) != 0 && JSConcatStringsNode.isEmptyString(arg1Value)) {
                return JSConcatStringsNode.doRightEmpty(arg0Value, arg1Value);
            }
            if ((state & 4) != 0 && (s3_ = this.concat_cache) != null && !JSConcatStringsNode.isEmptyString(arg0Value) && !JSConcatStringsNode.isEmptyString(arg1Value)) {
                return this.doConcat(arg0Value, arg1Value, s3_.leftIsString_, s3_.leftIsLazyString_, s3_.leftIsFlat_, s3_.rightIsString_, s3_.rightIsLazyString_, s3_.rightIsFlat_, s3_.stringLength_, s3_.shortStringAppend_, s3_.errorBranch_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private CharSequence executeAndSpecialize(CharSequence arg0Value, CharSequence arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSConcatStringsNode.isEmptyString(arg0Value)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                CharSequence charSequence = JSConcatStringsNode.doLeftEmpty(arg0Value, arg1Value);
                return charSequence;
            }
            if (JSConcatStringsNode.isEmptyString(arg1Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                CharSequence charSequence = JSConcatStringsNode.doRightEmpty(arg0Value, arg1Value);
                return charSequence;
            }
            if (!JSConcatStringsNode.isEmptyString(arg0Value) && !JSConcatStringsNode.isEmptyString(arg1Value)) {
                ConcatData s3_ = new ConcatData();
                s3_.leftIsString_ = ConditionProfile.createBinaryProfile();
                s3_.leftIsLazyString_ = ConditionProfile.createBinaryProfile();
                s3_.leftIsFlat_ = ConditionProfile.createBinaryProfile();
                s3_.rightIsString_ = ConditionProfile.createBinaryProfile();
                s3_.rightIsLazyString_ = ConditionProfile.createBinaryProfile();
                s3_.rightIsFlat_ = ConditionProfile.createBinaryProfile();
                s3_.stringLength_ = ConditionProfile.createBinaryProfile();
                s3_.shortStringAppend_ = ConditionProfile.createBinaryProfile();
                s3_.errorBranch_ = BranchProfile.create();
                this.concat_cache = s3_;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                CharSequence charSequence = this.doConcat(arg0Value, arg1Value, s3_.leftIsString_, s3_.leftIsLazyString_, s3_.leftIsFlat_, s3_.rightIsString_, s3_.rightIsLazyString_, s3_.rightIsFlat_, s3_.stringLength_, s3_.shortStringAppend_, s3_.errorBranch_);
                return charSequence;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 7 & (state & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doLeftEmpty";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doRightEmpty";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doConcat";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Profile>> cached = new ArrayList<List<Profile>>();
            ConcatData s3_ = this.concat_cache;
            if (s3_ != null) {
                cached.add(Arrays.asList(s3_.leftIsString_, s3_.leftIsLazyString_, s3_.leftIsFlat_, s3_.rightIsString_, s3_.rightIsLazyString_, s3_.rightIsFlat_, s3_.stringLength_, s3_.shortStringAppend_, s3_.errorBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create(data);
    }

    public static JSConcatStringsNode create(int stringLengthLimit) {
        return new JSConcatStringsNodeGen(stringLengthLimit);
    }

    @GeneratedBy(value=JSConcatStringsNode.class)
    private static final class ConcatData {
        @CompilerDirectives.CompilationFinal
        ConditionProfile leftIsString_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile leftIsLazyString_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile leftIsFlat_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile rightIsString_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile rightIsLazyString_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile rightIsFlat_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile stringLength_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile shortStringAppend_;
        @CompilerDirectives.CompilationFinal
        BranchProfile errorBranch_;

        ConcatData() {
        }
    }
}

