/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSBitwiseXorNode.class)
public final class JSBitwiseXorNodeGen
extends JSBitwiseXorNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSToInt32Node double_leftInt32_;
    @Node.Child
    private JSToInt32Node double_rightInt32_;
    @Node.Child
    private GenericData generic_cache;

    private JSBitwiseXorNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object executeObject(Object leftNodeValue, Object rightNodeValue) {
        GenericData s7_;
        int state = this.state_;
        if ((state & 3) != 0 && rightNodeValue instanceof Integer) {
            int rightNodeValue_ = (Integer)rightNodeValue;
            if ((state & 1) != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                return this.doInteger(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 2) != 0 && leftNodeValue instanceof SafeInteger) {
                SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
                return this.doSafeIntegerInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0xC) != 0 && rightNodeValue instanceof SafeInteger) {
            SafeInteger rightNodeValue_ = (SafeInteger)rightNodeValue;
            if ((state & 4) != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                return this.doIntSafeInteger(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 8) != 0 && leftNodeValue instanceof SafeInteger) {
                SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
                return this.doSafeInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x780) >>> 7, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x780) >>> 7, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, rightNodeValue);
                return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        if ((state & 0x20) != 0 && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x40) != 0 && (s7_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue, rightNodeValue, s7_.leftNumeric_, s7_.rightNumeric_, s7_.xor_, s7_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x7E) == 0 && (state & 0x7F) != 0) {
            return this.execute_int_int0(frameValue, state);
        }
        if ((state & 0x6F) == 0 && (state & 0x7F) != 0) {
            return this.execute_double_double1(frameValue, state);
        }
        if ((state & 0x7D) == 0 && (state & 0x7F) != 0) {
            return this.execute_int2(frameValue, state);
        }
        if ((state & 0x7B) == 0 && (state & 0x7F) != 0) {
            return this.execute_int3(frameValue, state);
        }
        return this.execute_generic4(frameValue, state);
    }

    private Object execute_int_int0(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_double_double1(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x700) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x680) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x580) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x780) >>> 7, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x7000) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x6800) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x5800) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x7800) >>> 11, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x700) == 0 && (state & 0x7F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x680) == 0 && (state & 0x7F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 0x10) != 0);
        return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
    }

    private Object execute_int2(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (leftNodeValue_ instanceof SafeInteger) {
            SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
            return this.doSafeIntegerInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int3(VirtualFrame frameValue, int state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 4) != 0);
        if (rightNodeValue_ instanceof SafeInteger) {
            SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
            return this.doIntSafeInteger(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic4(VirtualFrame frameValue, int state) {
        GenericData s7_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__ = (Integer)rightNodeValue_;
            if ((state & 1) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 2) != 0 && leftNodeValue_ instanceof SafeInteger) {
                SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
                return this.doSafeIntegerInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0xC) != 0 && rightNodeValue_ instanceof SafeInteger) {
            SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
            if ((state & 4) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doIntSafeInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 8) != 0 && leftNodeValue_ instanceof SafeInteger) {
                SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
                return this.doSafeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x780) >>> 7, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x780) >>> 7, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, rightNodeValue_);
                return this.doDouble(leftNodeValue__, rightNodeValue__, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        if ((state & 0x20) != 0 && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x40) != 0 && (s7_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue_, rightNodeValue_, s7_.leftNumeric_, s7_.rightNumeric_, s7_.xor_, s7_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state & 0x1E) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_int_int5(frameValue, state);
        }
        if ((state & 0xF) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_double_double6(frameValue, state);
        }
        if ((state & 0x1D) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_int7(frameValue, state);
        }
        if ((state & 0x1B) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_int8(frameValue, state);
        }
        return this.executeInt_generic9(frameValue, state);
    }

    private int executeInt_int_int5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private int executeInt_double_double6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x700) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x680) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x580) == 0 && (state & 0x7F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x780) >>> 7, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x7000) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x6800) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x5800) == 0 && (state & 0x7F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x7800) >>> 11, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize((state & 0x700) == 0 && (state & 0x7F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x680) == 0 && (state & 0x7F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult()));
        }
        assert ((state & 0x10) != 0);
        return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
    }

    private int executeInt_int7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 2) != 0);
        if (leftNodeValue_ instanceof SafeInteger) {
            SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
            return this.doSafeIntegerInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int8(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 4) != 0);
        if (rightNodeValue_ instanceof SafeInteger) {
            SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
            return this.doIntSafeInteger(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_generic9(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__ = (Integer)rightNodeValue_;
            if ((state & 1) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 2) != 0 && leftNodeValue_ instanceof SafeInteger) {
                SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
                return this.doSafeIntegerInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0xC) != 0 && rightNodeValue_ instanceof SafeInteger) {
            SafeInteger rightNodeValue__ = (SafeInteger)rightNodeValue_;
            if ((state & 4) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doIntSafeInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 8) != 0 && leftNodeValue_ instanceof SafeInteger) {
                SafeInteger leftNodeValue__ = (SafeInteger)leftNodeValue_;
                return this.doSafeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x780) >>> 7, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x780) >>> 7, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, rightNodeValue_);
                return this.doDouble(leftNodeValue__, rightNodeValue__, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x60) == 0 && (state & 0x7F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast0;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                if ((exclude & 1) == 0 && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (Integer)leftNodeValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
                if ((exclude & 2) == 0 && leftNodeValue instanceof SafeInteger) {
                    SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doSafeIntegerInt(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if (rightNodeValue instanceof SafeInteger) {
                SafeInteger rightNodeValue_ = (SafeInteger)rightNodeValue;
                if ((exclude & 4) == 0 && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (Integer)leftNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doIntSafeInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
                if ((exclude & 8) == 0 && leftNodeValue instanceof SafeInteger) {
                    SafeInteger leftNodeValue_ = (SafeInteger)leftNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doSafeInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if ((exclude & 0x10) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    this.double_leftInt32_ = super.insert(JSToInt32Node.create());
                    this.double_rightInt32_ = super.insert(JSToInt32Node.create());
                    state |= doubleCast0 << 7;
                    state |= doubleCast1 << 11;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
                    return n;
                }
            }
            if ((exclude & 0x20) == 0 && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    BigInt bigInt = this.doBigInt(leftNodeValue_, rightNodeValue_);
                    return bigInt;
                }
            }
            GenericData s7_ = super.insert(new GenericData());
            s7_.leftNumeric_ = s7_.insertAccessor(JSToNumericNode.create());
            s7_.rightNumeric_ = s7_.insertAccessor(JSToNumericNode.create());
            s7_.xor_ = s7_.insertAccessor(JSBitwiseXorNode.createInner());
            s7_.mixedNumericTypes_ = BranchProfile.create();
            this.generic_cache = s7_;
            this.exclude_ = exclude |= 0x3F;
            state &= 0xFFFFFFC0;
            this.state_ = state |= 0x40;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(leftNodeValue, rightNodeValue, s7_.leftNumeric_, s7_.rightNumeric_, s7_.xor_, s7_.mixedNumericTypes_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x7F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7F & (state & 0x7F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[8];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeIntegerInt";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doIntSafeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(this.double_leftInt32_, this.double_rightInt32_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s7_ = this.generic_cache;
            if (s7_ != null) {
                cached.add(Arrays.asList(s7_.leftNumeric_, s7_.rightNumeric_, s7_.xor_, s7_.mixedNumericTypes_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        return Introspection.Provider.create(data);
    }

    public static JSBitwiseXorNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSBitwiseXorNodeGen(left, right);
    }

    @GeneratedBy(value=JSBitwiseXorNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        JSToNumericNode leftNumeric_;
        @Node.Child
        JSToNumericNode rightNumeric_;
        @Node.Child
        JSBitwiseXorNode xor_;
        @CompilerDirectives.CompilationFinal
        BranchProfile mixedNumericTypes_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

