/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.array.JSArrayElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayFirstElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSArrayFirstElementIndexNode.class)
public final class JSArrayFirstElementIndexNodeGen
extends JSArrayFirstElementIndexNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private WithoutHolesCachedData withoutHolesCached_cache;
    @Node.Child
    private WithHolesCachedData withHolesCached_cache;
    @Node.Child
    private WithHolesUncachedData withHolesUncached_cache;
    @Node.Child
    private JSHasPropertyNode firstObjectViaEnumeration_hasPropertyNode_;
    @Node.Child
    private JSHasPropertyNode firstObjectViaFullEnumeration_hasPropertyNode_;
    @Node.Child
    private JSHasPropertyNode object_hasPropertyNode_;

    private JSArrayFirstElementIndexNodeGen(JSContext context) {
        super(context);
    }

    @Override
    @ExplodeLoop
    public long executeLong(Object arg0Value, long arg1Value, boolean arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 0x3F) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                WithHolesUncachedData s4_;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((state & 1) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
                    while (s1_ != null) {
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s1_.cachedArrayType_ && !s1_.cachedArrayType_.hasHoles(arg0Value_, arg2Value)) {
                            return this.doWithoutHolesCached(arg0Value_, arg1Value, arg2Value, s1_.cachedArrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_) && !JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value)) {
                    return this.doWithoutHolesUncached(arg0Value_, arg1Value, arg2Value);
                }
                if ((state & 4) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    WithHolesCachedData s3_ = this.withHolesCached_cache;
                    while (s3_ != null) {
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s3_.cachedArrayType_ && s3_.cachedArrayType_.hasHoles(arg0Value_, arg2Value)) {
                            return this.doWithHolesCached(arg0Value_, arg1Value, arg2Value, s3_.cachedArrayType_, s3_.nextElementIndexNode_, s3_.isZero_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0 && (s4_ = this.withHolesUncached_cache) != null && arg2Value && (this.hasPrototypeElements(arg0Value_) || JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value))) {
                    return this.doWithHolesUncached(arg0Value_, arg1Value, arg2Value, s4_.nextElementIndexNode_, s4_.isZero_, s4_.arrayTypeProfile_);
                }
                if ((state & 0x10) != 0 && !arg2Value && this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value)) {
                    return this.firstObjectViaEnumeration(arg0Value_, arg1Value, arg2Value, this.firstObjectViaEnumeration_hasPropertyNode_);
                }
                if ((state & 0x20) != 0 && !arg2Value && !this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value) && JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value_, arg1Value)) {
                    return this.firstObjectViaFullEnumeration(arg0Value_, arg1Value, arg2Value, this.firstObjectViaFullEnumeration_hasPropertyNode_);
                }
            }
            if ((state & 0x40) != 0 && !arg2Value && !JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value, arg1Value)) {
                return this.doObject(arg0Value, arg1Value, arg2Value, this.object_hasPropertyNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private long executeAndSpecialize(Object arg0Value, long arg1Value, boolean arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : this.countCaches();
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    int count1_ = 0;
                    WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) != s1_.cachedArrayType_ || s1_.cachedArrayType_.hasHoles(arg0Value_, arg2Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        ScriptArray cachedArrayType__ = JSArrayElementIndexNode.getArrayTypeIfArray(arg0Value_, arg2Value);
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == cachedArrayType__ && !cachedArrayType__.hasHoles(arg0Value_, arg2Value) && count1_ < 4) {
                            s1_ = new WithoutHolesCachedData(this.withoutHolesCached_cache);
                            s1_.cachedArrayType_ = cachedArrayType__;
                            this.withoutHolesCached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long cachedArrayType__ = this.doWithoutHolesCached(arg0Value_, arg1Value, arg2Value, s1_.cachedArrayType_);
                        return cachedArrayType__;
                    }
                }
                if (arg2Value && !this.hasPrototypeElements(arg0Value_) && !JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value)) {
                    this.exclude_ = exclude |= 1;
                    this.withoutHolesCached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    long count1_ = this.doWithoutHolesUncached(arg0Value_, arg1Value, arg2Value);
                    return count1_;
                }
                if ((exclude & 2) == 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    int count3_ = 0;
                    WithHolesCachedData s3_ = this.withHolesCached_cache;
                    if ((state & 4) != 0) {
                        while (!(s3_ == null || JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s3_.cachedArrayType_ && s3_.cachedArrayType_.hasHoles(arg0Value_, arg2Value))) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null) {
                        ScriptArray cachedArrayType__1 = JSArrayElementIndexNode.getArrayTypeIfArray(arg0Value_, arg2Value);
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == cachedArrayType__1 && cachedArrayType__1.hasHoles(arg0Value_, arg2Value) && count3_ < 4) {
                            s3_ = super.insert(new WithHolesCachedData(this.withHolesCached_cache));
                            s3_.cachedArrayType_ = cachedArrayType__1;
                            s3_.nextElementIndexNode_ = s3_.insertAccessor(JSArrayNextElementIndexNode.create(this.context));
                            s3_.isZero_ = ConditionProfile.createBinaryProfile();
                            this.withHolesCached_cache = s3_;
                            this.state_ = state |= 4;
                        }
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l = this.doWithHolesCached(arg0Value_, arg1Value, arg2Value, s3_.cachedArrayType_, s3_.nextElementIndexNode_, s3_.isZero_);
                        return l;
                    }
                }
                if (arg2Value && (this.hasPrototypeElements(arg0Value_) || JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value))) {
                    WithHolesUncachedData s4_ = super.insert(new WithHolesUncachedData());
                    s4_.nextElementIndexNode_ = s4_.insertAccessor(JSArrayNextElementIndexNode.create(this.context));
                    s4_.isZero_ = ConditionProfile.createBinaryProfile();
                    s4_.arrayTypeProfile_ = ValueProfile.createClassProfile();
                    this.withHolesUncached_cache = s4_;
                    this.exclude_ = exclude |= 2;
                    this.withHolesCached_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doWithHolesUncached(arg0Value_, arg1Value, arg2Value, s4_.nextElementIndexNode_, s4_.isZero_, s4_.arrayTypeProfile_);
                    return l;
                }
                if (!arg2Value && this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value)) {
                    this.firstObjectViaEnumeration_hasPropertyNode_ = super.insert(JSHasPropertyNode.create());
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    long l = this.firstObjectViaEnumeration(arg0Value_, arg1Value, arg2Value, this.firstObjectViaEnumeration_hasPropertyNode_);
                    return l;
                }
                if (!arg2Value && !this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value) && JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value_, arg1Value)) {
                    this.firstObjectViaFullEnumeration_hasPropertyNode_ = super.insert(JSHasPropertyNode.create());
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    long l = this.firstObjectViaFullEnumeration(arg0Value_, arg1Value, arg2Value, this.firstObjectViaFullEnumeration_hasPropertyNode_);
                    return l;
                }
            }
            if (!arg2Value && !JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value, arg1Value)) {
                this.object_hasPropertyNode_ = super.insert(JSHasPropertyNode.create());
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                long l = this.doObject(arg0Value, arg1Value, arg2Value, this.object_hasPropertyNode_);
                return l;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
        }
        finally {
            if (oldState != 0 || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
        while (s1_ != null) {
            ++cacheCount;
            s1_ = s1_.next_;
        }
        WithHolesCachedData s3_ = this.withHolesCached_cache;
        while (s3_ != null) {
            ++cacheCount;
            s3_ = s3_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
            WithHolesCachedData s3_ = this.withHolesCached_cache;
            if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[8];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doWithoutHolesCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedArrayType_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doWithoutHolesUncached";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doWithHolesCached";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            WithHolesCachedData s3_ = this.withHolesCached_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(s3_.cachedArrayType_, s3_.nextElementIndexNode_, s3_.isZero_));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doWithHolesUncached";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            WithHolesUncachedData s4_ = this.withHolesUncached_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(s4_.nextElementIndexNode_, s4_.isZero_, s4_.arrayTypeProfile_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "firstObjectViaEnumeration";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.firstObjectViaEnumeration_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "firstObjectViaFullEnumeration";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.firstObjectViaFullEnumeration_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.object_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        return Introspection.Provider.create(data);
    }

    public static JSArrayFirstElementIndexNode create(JSContext context) {
        return new JSArrayFirstElementIndexNodeGen(context);
    }

    @GeneratedBy(value=JSArrayFirstElementIndexNode.class)
    private static final class WithHolesUncachedData
    extends Node {
        @Node.Child
        JSArrayNextElementIndexNode nextElementIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isZero_;
        @CompilerDirectives.CompilationFinal
        ValueProfile arrayTypeProfile_;

        WithHolesUncachedData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayFirstElementIndexNode.class)
    private static final class WithHolesCachedData
    extends Node {
        @Node.Child
        WithHolesCachedData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        JSArrayNextElementIndexNode nextElementIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isZero_;

        WithHolesCachedData(WithHolesCachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayFirstElementIndexNode.class)
    private static final class WithoutHolesCachedData {
        @CompilerDirectives.CompilationFinal
        WithoutHolesCachedData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;

        WithoutHolesCachedData(WithoutHolesCachedData next_) {
            this.next_ = next_;
        }
    }
}

