/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.arguments.ArgumentsObjectNode;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=ArgumentsObjectNode.class)
public final class ArgumentsObjectNodeGen
extends ArgumentsObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private ArgumentsObjectNodeGen(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        super(context, strict, leadingArgCount, trailingArgCount);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 1) != 0 && this.isStrict(frameValue)) {
            return this.doStrict(frameValue);
        }
        if ((state & 2) != 0 && !this.isStrict(frameValue)) {
            return this.doNonStrict(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private DynamicObject executeAndSpecialize(VirtualFrame frameValue) {
        int state = this.state_;
        if (this.isStrict(frameValue)) {
            this.state_ = state |= 1;
            return this.doStrict(frameValue);
        }
        if (!this.isStrict(frameValue)) {
            this.state_ = state |= 2;
            return this.doNonStrict(frameValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[0], new Object[0]);
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doStrict";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doNonStrict";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static ArgumentsObjectNode create(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        return new ArgumentsObjectNodeGen(context, strict, leadingArgCount, trailingArgCount);
    }
}

