/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RequireObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=RequireObjectNode.class)
public final class RequireObjectNodeGen
extends RequireObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ObjectShapeData objectShape_cache;

    private RequireObjectNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    @ExplodeLoop
    public Object execute(Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
            ObjectShapeData s1_ = this.objectShape_cache;
            while (s1_ != null) {
                if (s1_.cachedShape_.check(operandNodeValue_)) {
                    return RequireObjectNode.doObjectShape(operandNodeValue_, s1_.cachedShape_, s1_.cachedResult_);
                }
                s1_ = s1_.next_;
            }
        }
        if ((state & 2) != 0) {
            return RequireObjectNode.doObject(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject)operandNodeValue_;
            ObjectShapeData s1_ = this.objectShape_cache;
            while (s1_ != null) {
                if (s1_.cachedShape_.check(operandNodeValue__)) {
                    return RequireObjectNode.doObjectShape(operandNodeValue__, s1_.cachedShape_, s1_.cachedResult_);
                }
                s1_ = s1_.next_;
            }
        }
        if ((state & 2) != 0) {
            return RequireObjectNode.doObject(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && JSTypes.isDynamicObject(operandNodeValue)) {
                Shape cachedShape__;
                DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
                int count1_ = 0;
                ObjectShapeData s1_ = this.objectShape_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && !s1_.cachedShape_.check(operandNodeValue_)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedShape__ = operandNodeValue_.getShape()).check(operandNodeValue_) && count1_ < 1) {
                    s1_ = new ObjectShapeData(this.objectShape_cache);
                    s1_.cachedShape_ = cachedShape__;
                    s1_.cachedResult_ = JSGuards.isJSObject(operandNodeValue_);
                    this.objectShape_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = RequireObjectNode.doObjectShape(operandNodeValue_, s1_.cachedShape_, s1_.cachedResult_);
                    return object;
                }
            }
            this.exclude_ = exclude |= 1;
            this.objectShape_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = RequireObjectNode.doObject(operandNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ObjectShapeData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.objectShape_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doObjectShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            ObjectShapeData s1_ = this.objectShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static RequireObjectNode create(JavaScriptNode operand) {
        return new RequireObjectNodeGen(operand);
    }

    @GeneratedBy(value=RequireObjectNode.class)
    private static final class ObjectShapeData {
        @CompilerDirectives.CompilationFinal
        ObjectShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        ObjectShapeData(ObjectShapeData next_) {
            this.next_ = next_;
        }
    }
}

