/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNodeGen;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class PrivateFieldSetNode
extends JSTargetableNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode keyNode;
    @Node.Child
    @Executed
    protected JavaScriptNode valueNode;
    protected final JSContext context;

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return PrivateFieldSetNodeGen.create(targetNode, keyNode, valueNode, context);
    }

    protected PrivateFieldSetNode(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        this.targetNode = targetNode;
        this.keyNode = keyNode;
        this.valueNode = valueNode;
        this.context = context;
    }

    @Specialization(guards={"isJSObject(target)", "key == hasNode.getKey()"}, limit="1")
    Object doFieldCachedKey(DynamicObject target, HiddenKey key, Object value, @Cached(value="create(key)") HasHiddenKeyCacheNode hasNode, @Cached(value="createSetHidden(key, context)") PropertySetNode setNode, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        if (hasNode.executeHasHiddenKey(target)) {
            setNode.setValue(target, value);
        } else {
            errorBranch.enter();
            this.missing(target, key, value);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doFieldCachedKey"})
    Object doFieldUncachedKey(DynamicObject target, HiddenKey key, Object value, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        if (!target.set(key, value)) {
            errorBranch.enter();
            this.missing(target, key, value);
        }
        return value;
    }

    @Specialization(guards={"isJSObject(target)"})
    Object doAccessor(DynamicObject target, Accessor accessor, Object value, @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        DynamicObject setter = accessor.getSetter();
        if (setter == Undefined.instance) {
            errorBranch.enter();
            throw Errors.createTypeErrorCannotSetAccessorProperty(this.keyAsString(), target);
        }
        return callNode.executeCall(JSArguments.createOneArg(target, setter, value));
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    Object missing(Object target, Object key, Object value) {
        throw Errors.createTypeErrorCannotSetPrivateMember(this.keyAsString(), this);
    }

    @CompilerDirectives.TruffleBoundary
    private String keyAsString() {
        return this.keyNode.expressionToString();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return PrivateFieldSetNode.create(PrivateFieldSetNode.cloneUninitialized(this.targetNode, materializedTags), PrivateFieldSetNode.cloneUninitialized(this.keyNode, materializedTags), PrivateFieldSetNode.cloneUninitialized(this.valueNode, materializedTags), this.context);
    }
}

