/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldGetNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Accessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PrivateFieldGetNode.class)
public final class PrivateFieldGetNodeGen
extends PrivateFieldGetNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile errorBranch;
    @CompilerDirectives.CompilationFinal
    private HiddenKey fieldCachedKey_cachedKey_;
    @Node.Child
    private HasHiddenKeyCacheNode fieldCachedKey_hasNode_;
    @Node.Child
    private PropertyGetNode fieldCachedKey_getNode_;
    @Node.Child
    private JSFunctionCallNode accessor_callNode_;

    private PrivateFieldGetNodeGen(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        super(targetNode, keyNode, context);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = this.state_;
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        if ((state & 0xF) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
            Object keyNodeValue__;
            DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
            if ((state & 3) != 0 && keyNodeValue_ instanceof HiddenKey) {
                keyNodeValue__ = (HiddenKey)keyNodeValue_;
                if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && keyNodeValue__ == this.fieldCachedKey_cachedKey_) {
                    return this.doFieldCachedKey(targetNodeValue_, (HiddenKey)keyNodeValue__, this.fieldCachedKey_cachedKey_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_getNode_, this.errorBranch);
                }
                if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue_)) {
                    return this.doFieldUncachedKey(targetNodeValue_, (HiddenKey)keyNodeValue__, this.errorBranch);
                }
            }
            if ((state & 4) != 0 && JSTypes.isDynamicObject(keyNodeValue_)) {
                keyNodeValue__ = (DynamicObject)keyNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue_) && JSGuards.isJSFunction((DynamicObject)keyNodeValue__)) {
                    return this.doMethod(targetNodeValue_, (DynamicObject)keyNodeValue__);
                }
            }
            if ((state & 8) != 0 && keyNodeValue_ instanceof Accessor) {
                keyNodeValue__ = (Accessor)keyNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue_)) {
                    return this.doAccessor(targetNodeValue_, (Accessor)keyNodeValue__, this.accessor_callNode_, this.errorBranch);
                }
            }
        }
        if ((state & 0x10) != 0 && PrivateFieldGetNodeGen.fallbackGuard_(targetNodeValue, keyNodeValue_)) {
            return this.missing(targetNodeValue, keyNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, keyNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        if ((state & 0xF) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            Object keyNodeValue__;
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 3) != 0 && keyNodeValue_ instanceof HiddenKey) {
                keyNodeValue__ = (HiddenKey)keyNodeValue_;
                if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue__) && keyNodeValue__ == this.fieldCachedKey_cachedKey_) {
                    return this.doFieldCachedKey(targetNodeValue__, (HiddenKey)keyNodeValue__, this.fieldCachedKey_cachedKey_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_getNode_, this.errorBranch);
                }
                if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue__)) {
                    return this.doFieldUncachedKey(targetNodeValue__, (HiddenKey)keyNodeValue__, this.errorBranch);
                }
            }
            if ((state & 4) != 0 && JSTypes.isDynamicObject(keyNodeValue_)) {
                keyNodeValue__ = (DynamicObject)keyNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue__) && JSGuards.isJSFunction((DynamicObject)keyNodeValue__)) {
                    return this.doMethod(targetNodeValue__, (DynamicObject)keyNodeValue__);
                }
            }
            if ((state & 8) != 0 && keyNodeValue_ instanceof Accessor) {
                keyNodeValue__ = (Accessor)keyNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue__)) {
                    return this.doAccessor(targetNodeValue__, (Accessor)keyNodeValue__, this.accessor_callNode_, this.errorBranch);
                }
            }
        }
        if ((state & 0x10) != 0 && PrivateFieldGetNodeGen.fallbackGuard_(targetNodeValue_, keyNodeValue_)) {
            return this.missing(targetNodeValue_, keyNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, keyNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object targetNodeValue, Object keyNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                Object keyNodeValue_;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    keyNodeValue_ = (HiddenKey)keyNodeValue;
                    if (exclude == 0) {
                        boolean FieldCachedKey_duplicateFound_ = false;
                        if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && keyNodeValue_ == this.fieldCachedKey_cachedKey_) {
                            FieldCachedKey_duplicateFound_ = true;
                        }
                        if (!FieldCachedKey_duplicateFound_ && JSGuards.isJSObject(targetNodeValue_) && (state & 1) == 0) {
                            this.fieldCachedKey_cachedKey_ = keyNodeValue_;
                            this.fieldCachedKey_hasNode_ = super.insert(HasHiddenKeyCacheNode.create((HiddenKey)keyNodeValue_));
                            this.fieldCachedKey_getNode_ = super.insert(PropertyGetNode.createGetHidden((HiddenKey)keyNodeValue_, this.context));
                            if (this.errorBranch == null) {
                                this.errorBranch = BranchProfile.create();
                            }
                            this.state_ = state |= 1;
                            FieldCachedKey_duplicateFound_ = true;
                        }
                        if (FieldCachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doFieldCachedKey(targetNodeValue_, (HiddenKey)keyNodeValue_, this.fieldCachedKey_cachedKey_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_getNode_, this.errorBranch);
                            return object;
                        }
                    }
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        if (this.errorBranch == null) {
                            this.errorBranch = BranchProfile.create();
                        }
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doFieldUncachedKey(targetNodeValue_, (HiddenKey)keyNodeValue_, this.errorBranch);
                        return object;
                    }
                }
                if (JSTypes.isDynamicObject(keyNodeValue)) {
                    keyNodeValue_ = (DynamicObject)keyNodeValue;
                    if (JSGuards.isJSObject(targetNodeValue_) && JSGuards.isJSFunction((DynamicObject)keyNodeValue_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doMethod(targetNodeValue_, (DynamicObject)keyNodeValue_);
                        return object;
                    }
                }
                if (keyNodeValue instanceof Accessor) {
                    keyNodeValue_ = (Accessor)keyNodeValue;
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        this.accessor_callNode_ = super.insert(JSFunctionCallNode.createCall());
                        if (this.errorBranch == null) {
                            this.errorBranch = BranchProfile.create();
                        }
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doAccessor(targetNodeValue_, (Accessor)keyNodeValue_, this.accessor_callNode_, this.errorBranch);
                        return object;
                    }
                }
            }
            this.state_ = state |= 0x10;
            lock.unlock();
            hasLock = false;
            Object object = this.missing(targetNodeValue, keyNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doFieldCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.fieldCachedKey_cachedKey_, this.fieldCachedKey_hasNode_, this.fieldCachedKey_getNode_, this.errorBranch));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doFieldUncachedKey";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.errorBranch));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doMethod";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doAccessor";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.accessor_callNode_, this.errorBranch));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "missing";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object keyNodeValue) {
        if (JSTypes.isDynamicObject(targetNodeValue)) {
            DynamicObject keyNodeValue_;
            DynamicObject targetNodeValue_;
            if (keyNodeValue instanceof HiddenKey && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
            if (JSTypes.isDynamicObject(keyNodeValue) && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue) && JSGuards.isJSFunction(keyNodeValue_ = (DynamicObject)keyNodeValue)) {
                return false;
            }
            if (keyNodeValue instanceof Accessor && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
        }
        return true;
    }

    public static PrivateFieldGetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        return new PrivateFieldGetNodeGen(targetNode, keyNode, context);
    }
}

