/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldGetNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Objects;
import java.util.Set;

public abstract class PrivateFieldGetNode
extends JSTargetableNode
implements ReadNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode keyNode;
    protected final JSContext context;

    public static PrivateFieldGetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        return PrivateFieldGetNodeGen.create(targetNode, keyNode, context);
    }

    protected PrivateFieldGetNode(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        this.targetNode = targetNode;
        this.keyNode = keyNode;
        this.context = context;
    }

    @Specialization(guards={"isJSObject(target)", "key == cachedKey"}, limit="1")
    Object doFieldCachedKey(DynamicObject target, HiddenKey key, @Cached(value="key") HiddenKey cachedKey, @Cached(value="create(key)") HasHiddenKeyCacheNode hasNode, @Cached(value="createGetHidden(key, context)") PropertyGetNode getNode, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        if (hasNode.executeHasHiddenKey(target)) {
            return getNode.getValue(target);
        }
        errorBranch.enter();
        return this.missing(target, key);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doFieldCachedKey"})
    Object doFieldUncachedKey(DynamicObject target, HiddenKey key, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        if (target.containsKey(key)) {
            return target.get(key, Undefined.instance);
        }
        errorBranch.enter();
        return this.missing(target, key);
    }

    @Specialization(guards={"isJSObject(target)", "isJSFunction(method)"})
    Object doMethod(DynamicObject target, DynamicObject method) {
        return method;
    }

    @Specialization(guards={"isJSObject(target)"})
    Object doAccessor(DynamicObject target, Accessor accessor, @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch) {
        DynamicObject getter = accessor.getGetter();
        if (getter == Undefined.instance) {
            errorBranch.enter();
            throw Errors.createTypeErrorCannotGetAccessorProperty(this.keyAsString(), target, this);
        }
        return callNode.executeCall(JSArguments.createZeroArg(target, getter));
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    Object missing(Object target, Object key) {
        throw Errors.createTypeErrorCannotGetPrivateMember(this.keyAsString(), this);
    }

    @CompilerDirectives.TruffleBoundary
    private String keyAsString() {
        return this.keyNode.expressionToString();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return PrivateFieldGetNode.create(PrivateFieldGetNode.cloneUninitialized(this.targetNode, materializedTags), PrivateFieldGetNode.cloneUninitialized(this.keyNode, materializedTags), this.context);
    }

    @Override
    public String expressionToString() {
        if (this.targetNode != null && this.keyNode != null) {
            return Objects.toString(this.targetNode.expressionToString(), "(intermediate value)") + "." + Objects.toString(this.keyAsString(), "(intermediate value)");
        }
        return null;
    }
}

