/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateBrandCheckNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PrivateBrandCheckNode.class)
public final class PrivateBrandCheckNodeGen
extends PrivateBrandCheckNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private HasHiddenKeyCacheNode cachedKey_hasNode_;

    private PrivateBrandCheckNodeGen(JavaScriptNode targetNode, JavaScriptNode brandNode) {
        super(targetNode, brandNode);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = this.state_;
        Object brandNodeValue_ = this.brandNode.execute(frameValue);
        if ((state & 7) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
            TruffleObject brandNodeValue__;
            DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
            if ((state & 3) != 0 && brandNodeValue_ instanceof HiddenKey) {
                brandNodeValue__ = (HiddenKey)brandNodeValue_;
                if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && brandNodeValue__ == this.cachedKey_hasNode_.getKey()) {
                    return this.doCachedKey(targetNodeValue_, (HiddenKey)brandNodeValue__, this.cachedKey_hasNode_);
                }
                if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue_)) {
                    return this.doUncachedKey(targetNodeValue_, (HiddenKey)brandNodeValue__);
                }
            }
            if ((state & 4) != 0 && JSTypes.isDynamicObject(brandNodeValue_)) {
                brandNodeValue__ = (DynamicObject)brandNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue_)) {
                    return this.doStatic(targetNodeValue_, (DynamicObject)brandNodeValue__);
                }
            }
        }
        if ((state & 8) != 0 && PrivateBrandCheckNodeGen.fallbackGuard_(targetNodeValue, brandNodeValue_)) {
            return this.denied(targetNodeValue, brandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, brandNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object brandNodeValue_ = this.brandNode.execute(frameValue);
        if ((state & 7) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            TruffleObject brandNodeValue__;
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 3) != 0 && brandNodeValue_ instanceof HiddenKey) {
                brandNodeValue__ = (HiddenKey)brandNodeValue_;
                if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue__) && brandNodeValue__ == this.cachedKey_hasNode_.getKey()) {
                    return this.doCachedKey(targetNodeValue__, (HiddenKey)brandNodeValue__, this.cachedKey_hasNode_);
                }
                if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue__)) {
                    return this.doUncachedKey(targetNodeValue__, (HiddenKey)brandNodeValue__);
                }
            }
            if ((state & 4) != 0 && JSTypes.isDynamicObject(brandNodeValue_)) {
                brandNodeValue__ = (DynamicObject)brandNodeValue_;
                if (JSGuards.isJSObject(targetNodeValue__)) {
                    return this.doStatic(targetNodeValue__, (DynamicObject)brandNodeValue__);
                }
            }
        }
        if ((state & 8) != 0 && PrivateBrandCheckNodeGen.fallbackGuard_(targetNodeValue_, brandNodeValue_)) {
            return this.denied(targetNodeValue_, brandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, brandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object targetNodeValue, Object brandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                TruffleObject brandNodeValue_;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (brandNodeValue instanceof HiddenKey) {
                    brandNodeValue_ = (HiddenKey)brandNodeValue;
                    if (exclude == 0) {
                        HasHiddenKeyCacheNode cachedKey_hasNode__;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 1) != 0 && JSGuards.isJSObject(targetNodeValue_) && brandNodeValue_ == this.cachedKey_hasNode_.getKey()) {
                            CachedKey_duplicateFound_ = true;
                        }
                        if (!CachedKey_duplicateFound_ && JSGuards.isJSObject(targetNodeValue_) && brandNodeValue_ == (cachedKey_hasNode__ = super.insert(HasHiddenKeyCacheNode.create(brandNodeValue_))).getKey() && (state & 1) == 0) {
                            this.cachedKey_hasNode_ = super.insert(cachedKey_hasNode__);
                            this.state_ = state |= 1;
                            CachedKey_duplicateFound_ = true;
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doCachedKey(targetNodeValue_, (HiddenKey)brandNodeValue_, this.cachedKey_hasNode_);
                            return object;
                        }
                    }
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doUncachedKey(targetNodeValue_, (HiddenKey)brandNodeValue_);
                        return object;
                    }
                }
                if (JSTypes.isDynamicObject(brandNodeValue)) {
                    brandNodeValue_ = (DynamicObject)brandNodeValue;
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doStatic(targetNodeValue_, (DynamicObject)brandNodeValue_);
                        return object;
                    }
                }
            }
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Object object = this.denied(targetNodeValue, brandNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<HasHiddenKeyCacheNode>> cached = new ArrayList<List<HasHiddenKeyCacheNode>>();
            cached.add(Arrays.asList(this.cachedKey_hasNode_));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doStatic";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "denied";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object brandNodeValue) {
        if (JSTypes.isDynamicObject(targetNodeValue)) {
            DynamicObject targetNodeValue_;
            if (brandNodeValue instanceof HiddenKey && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
            if (JSTypes.isDynamicObject(brandNodeValue) && JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return false;
            }
        }
        return true;
    }

    public static PrivateBrandCheckNode create(JavaScriptNode targetNode, JavaScriptNode brandNode) {
        return new PrivateBrandCheckNodeGen(targetNode, brandNode);
    }
}

