/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateBrandCheckNodeGen;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class PrivateBrandCheckNode
extends JSTargetableNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode brandNode;

    public static PrivateBrandCheckNode create(JavaScriptNode targetNode, JavaScriptNode brandNode) {
        return PrivateBrandCheckNodeGen.create(targetNode, brandNode);
    }

    protected PrivateBrandCheckNode(JavaScriptNode targetNode, JavaScriptNode brandNode) {
        this.targetNode = targetNode;
        this.brandNode = brandNode;
    }

    @Specialization(guards={"isJSObject(target)", "brandKey == hasNode.getKey()"}, limit="1")
    Object doCachedKey(DynamicObject target, HiddenKey brandKey, @Cached(value="create(brandKey)") HasHiddenKeyCacheNode hasNode) {
        if (hasNode.executeHasHiddenKey(target)) {
            return target;
        }
        return this.denied(target, brandKey);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doCachedKey"})
    Object doUncachedKey(DynamicObject target, HiddenKey brandKey) {
        if (target.containsKey(brandKey)) {
            return target;
        }
        return this.denied(target, brandKey);
    }

    @Specialization(guards={"isJSObject(target)"})
    Object doStatic(DynamicObject target, DynamicObject brand) {
        if (target == brand) {
            return target;
        }
        return this.denied(target, brand);
    }

    @Fallback
    Object denied(Object target, Object brand) {
        return Undefined.instance;
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return PrivateBrandCheckNode.create(PrivateBrandCheckNode.cloneUninitialized(this.targetNode, materializedTags), PrivateBrandCheckNode.cloneUninitialized(this.brandNode, materializedTags));
    }
}

