/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.LocalVarIncNode;
import com.oracle.truffle.js.nodes.access.LocalVarPrefixIncMaterializedNode;
import com.oracle.truffle.js.nodes.access.LocalVarPrefixIncNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class LocalVarPrefixIncNode
extends LocalVarIncNode {
    protected LocalVarPrefixIncNode(LocalVarIncNode.LocalVarOp op, FrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        super(op, frameSlot, hasTemporalDeadZone, scopeFrameNode);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ReadVariableTag.class) || materializedTags.contains(JSTags.WriteVariableTag.class) || materializedTags.contains(StandardTags.ReadVariableTag.class) || materializedTags.contains(StandardTags.WriteVariableTag.class)) {
            return new LocalVarPrefixIncMaterializedNode(this, materializedTags);
        }
        return this;
    }

    @Specialization(guards={"isBoolean(frame)", "isIntegerKind(frame)"})
    public int doBoolean(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setInt(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isBoolean(frame)", "isDoubleKind(frame)"}, replaces={"doBoolean"})
    public int doBooleanDouble(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setDouble(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isBoolean(frame)", "ensureObjectKind(frame)"}, replaces={"doBooleanDouble"})
    public int doBooleanObject(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setObject(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isInt(frame)", "isIntegerKind(frame)"}, rewriteOn={ArithmeticException.class})
    public int doInt(Frame frame) {
        int value = this.getInt(frame);
        int newValue = this.op.doInt(value);
        frame.setInt(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isInt(frame)", "isDoubleKind(frame)"}, replaces={"doInt"})
    public double doIntOverflow(Frame frame) {
        int value = this.getInt(frame);
        double newValue = this.op.doDouble(value);
        frame.setDouble(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isInt(frame)", "ensureObjectKind(frame)"}, replaces={"doIntOverflow"})
    public double doIntOverflowObject(Frame frame) {
        int value = this.getInt(frame);
        double newValue = this.op.doDouble(value);
        frame.setObject(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isDouble(frame)", "isDoubleKind(frame)"})
    public double doDouble(Frame frame) {
        double doubleValue = this.getDouble(frame);
        double newValue = this.op.doDouble(doubleValue);
        frame.setDouble(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isDouble(frame)", "ensureObjectKind(frame)"}, replaces={"doDouble"})
    public double doDoubleObject(Frame frame) {
        double doubleValue = this.getDouble(frame);
        double newValue = this.op.doDouble(doubleValue);
        frame.setObject(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isObject(frame)", "ensureObjectKind(frame)"})
    public Object doObject(Frame frame, @Cached(value="createBinaryProfile()") ConditionProfile isIntegerProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBigIntProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBoundaryProfile, @Cached(value="create()") JSToNumericNode toNumeric, @Cached(value="create()") BranchProfile deadBranch) {
        Object number;
        Object value = this.getObject(frame);
        if (this.hasTemporalDeadZone()) {
            this.checkNotDead(value, deadBranch);
        }
        Object newValue = isBigIntProfile.profile((number = toNumeric.execute(value)) instanceof BigInt) ? this.op.doBigInt((BigInt)number) : this.op.doNumber((Number)number, isIntegerProfile, isBoundaryProfile);
        frame.setObject(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isLong(frame)", "isLongKind(frame)"}, rewriteOn={ArithmeticException.class})
    public SafeInteger doSafeInteger(Frame frame) {
        SafeInteger oldValue = SafeInteger.valueOf(this.getLong(frame));
        SafeInteger newValue = this.op.doSafeInteger(oldValue);
        frame.setLong(this.frameSlot, newValue.longValue());
        return newValue;
    }

    @Specialization(guards={"isLong(frame)", "isDoubleKind(frame)"}, replaces={"doSafeInteger"})
    public double doSafeIntegerToDouble(Frame frame) {
        double oldValue = this.getLong(frame);
        double newValue = this.op.doDouble(oldValue);
        frame.setDouble(this.frameSlot, newValue);
        return newValue;
    }

    @Specialization(guards={"isLong(frame)", "ensureObjectKind(frame)"}, replaces={"doSafeIntegerToDouble"})
    public double doSafeIntegerToObject(Frame frame) {
        double oldValue = this.getLong(frame);
        double newValue = this.op.doDouble(oldValue);
        frame.setObject(this.frameSlot, newValue);
        return newValue;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return LocalVarPrefixIncNodeGen.create(this.op, this.getFrameSlot(), this.hasTemporalDeadZone(), NodeUtil.cloneNode(this.getLevelFrameNode()));
    }
}

