/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.ArrayList;
import java.util.Set;

public abstract class LazyWriteFrameSlotNode
extends JavaScriptNode
implements WriteNode {
    protected final Object identifier;
    @Node.Child
    protected JavaScriptNode rhs;

    public LazyWriteFrameSlotNode(Object identifier, JavaScriptNode rhs) {
        this.identifier = identifier;
        this.rhs = rhs;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public static LazyWriteFrameSlotNode create(Object identifier, JavaScriptNode rhs) {
        return new LazyWriteFrameSlotUninitNode(identifier, rhs);
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhs;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeWrite(frame, this.rhs.execute(frame));
    }

    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class LazyWriteFrameSlotUninitNode
    extends LazyWriteFrameSlotNode {
        LazyWriteFrameSlotUninitNode(Object identifier, JavaScriptNode rhs) {
            super(identifier, rhs);
        }

        @Override
        public Object executeWrite(VirtualFrame frame, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VirtualFrame outerFrame = frame;
            int frameLevel = 0;
            while (true) {
                Frame outerScope = outerFrame;
                ArrayList<FrameSlot> parentSlotList = new ArrayList<FrameSlot>();
                int scopeLevel = 0;
                while (true) {
                    FrameSlot slot;
                    if ((slot = outerScope.getFrameDescriptor().findFrameSlot(this.identifier)) != null) {
                        FrameSlot[] parentSlots = parentSlotList.toArray(ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY);
                        JSWriteFrameSlotNode resolved = JSWriteFrameSlotNode.create(slot, ScopeFrameNode.create(frameLevel, scopeLevel, parentSlots), this.rhs, JSFrameUtil.hasTemporalDeadZone(slot));
                        return this.replace(resolved).executeWrite(frame, value);
                    }
                    FrameSlot parentSlot = outerScope.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
                    if (parentSlot == null) break;
                    outerScope = (Frame)FrameUtil.getObjectSafe(outerScope, parentSlot);
                    parentSlotList.add(parentSlot);
                    ++scopeLevel;
                }
                outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments());
                if (outerFrame == JSFrameUtil.NULL_MATERIALIZED_FRAME) break;
                ++frameLevel;
            }
            throw new RuntimeException("frame slot not found");
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new LazyWriteFrameSlotUninitNode(this.identifier, LazyWriteFrameSlotUninitNode.cloneUninitialized(this.rhs, materializedTags));
        }
    }
}

