/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.access.JSReadScopeFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;

@GeneratedBy(value=JSReadScopeFrameSlotNode.class)
final class JSReadScopeFrameSlotNodeGen
extends JSReadScopeFrameSlotNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private JSReadScopeFrameSlotNodeGen(FrameSlot slot, ScopeFrameNode scopeFrameNode) {
        super(slot, scopeFrameNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && scopeFrameNodeValue_.isBoolean(this.frameSlot)) {
                return this.doBoolean(scopeFrameNodeValue_);
            }
            if ((state & 2) != 0 && scopeFrameNodeValue_.isInt(this.frameSlot)) {
                return this.doInt(scopeFrameNodeValue_);
            }
            if ((state & 4) != 0 && scopeFrameNodeValue_.isDouble(this.frameSlot)) {
                return this.doDouble(scopeFrameNodeValue_);
            }
            if ((state & 8) != 0 && scopeFrameNodeValue_.isObject(this.frameSlot)) {
                assert (!this.hasTemporalDeadZone());
                return this.doObject(scopeFrameNodeValue_);
            }
            if ((state & 0x10) != 0 && scopeFrameNodeValue_.isLong(this.frameSlot)) {
                return this.doSafeInteger(scopeFrameNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame(frameValue);
        if ((state & 1) != 0 && scopeFrameNodeValue_.isBoolean(this.frameSlot)) {
            return this.doBoolean(scopeFrameNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame(frameValue);
        if ((state & 4) != 0 && scopeFrameNodeValue_.isDouble(this.frameSlot)) {
            return this.doDouble(scopeFrameNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame(frameValue);
        if ((state & 2) != 0 && scopeFrameNodeValue_.isInt(this.frameSlot)) {
            return this.doInt(scopeFrameNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x1D) == 0 && state != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x1B) == 0 && state != 0) {
                this.executeDouble(frameValue);
                return;
            }
            if ((state & 0x1E) == 0 && state != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Frame scopeFrameNodeValue) {
        int state = this.state_;
        if (scopeFrameNodeValue.isBoolean(this.frameSlot)) {
            this.state_ = state |= 1;
            return this.doBoolean(scopeFrameNodeValue);
        }
        if (scopeFrameNodeValue.isInt(this.frameSlot)) {
            this.state_ = state |= 2;
            return this.doInt(scopeFrameNodeValue);
        }
        if (scopeFrameNodeValue.isDouble(this.frameSlot)) {
            this.state_ = state |= 4;
            return this.doDouble(scopeFrameNodeValue);
        }
        if (scopeFrameNodeValue.isObject(this.frameSlot) && !this.hasTemporalDeadZone()) {
            this.state_ = state |= 8;
            return this.doObject(scopeFrameNodeValue);
        }
        if (scopeFrameNodeValue.isLong(this.frameSlot)) {
            this.state_ = state |= 0x10;
            return this.doSafeInteger(scopeFrameNodeValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[]{this.scopeFrameNode}, scopeFrameNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        return Introspection.Provider.create(data);
    }

    public static JSReadScopeFrameSlotNode create(FrameSlot slot, ScopeFrameNode scopeFrameNode) {
        return new JSReadScopeFrameSlotNodeGen(slot, scopeFrameNode);
    }
}

