/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.IsJSClassNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsRegExpNode.class)
public final class IsRegExpNodeGen
extends IsRegExpNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private IsObjectData isObject_cache;

    private IsRegExpNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public boolean executeBoolean(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            IsObjectData s1_ = this.isObject_cache;
            if (s1_ != null) {
                return this.doIsObject(arg0Value_, s1_.isObjectNode_, s1_.toBooleanNode_, s1_.isJSRegExpNode_, s1_.hasMatchSymbol_);
            }
        }
        if ((state & 2) != 0 && IsRegExpNodeGen.fallbackGuard_(state, arg0Value)) {
            return this.doNonObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                IsObjectData s1_ = super.insert(new IsObjectData());
                s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                s1_.toBooleanNode_ = s1_.insertAccessor(JSToBooleanNode.create());
                s1_.isJSRegExpNode_ = s1_.insertAccessor(IsRegExpNode.createIsJSRegExpNode());
                s1_.hasMatchSymbol_ = ConditionProfile.createBinaryProfile();
                this.isObject_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doIsObject(arg0Value_, s1_.isObjectNode_, s1_.toBooleanNode_, s1_.isJSRegExpNode_, s1_.hasMatchSymbol_);
                return bl;
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doNonObject(arg0Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doIsObject";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
            IsObjectData s1_ = this.isObject_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.isObjectNode_, s1_.toBooleanNode_, s1_.isJSRegExpNode_, s1_.hasMatchSymbol_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doNonObject";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        return (state & 1) != 0 || !JSTypes.isDynamicObject(arg0Value);
    }

    public static IsRegExpNode create(JSContext context) {
        return new IsRegExpNodeGen(context);
    }

    @GeneratedBy(value=IsRegExpNode.class)
    private static final class IsObjectData
    extends Node {
        @Node.Child
        IsJSObjectNode isObjectNode_;
        @Node.Child
        JSToBooleanNode toBooleanNode_;
        @Node.Child
        IsJSClassNode isJSRegExpNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile hasMatchSymbol_;

        IsObjectData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

