/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsJSObjectNode.class)
public final class IsJSObjectNodeGen
extends IsJSObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsObjectShapeData isObjectShape_cache;
    @CompilerDirectives.CompilationFinal
    private IsObjectJSClassData isObjectJSClass_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile isObject_resultProfile_;

    private IsJSObjectNodeGen(boolean includeNullUndefined) {
        super(includeNullUndefined);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value) {
        int state = this.state_;
        if ((state & 3) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                IsObjectShapeData s1_ = this.isObjectShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(arg0Value_)) {
                        return IsJSObjectNode.isObjectShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
                while (s2_ != null) {
                    assert (s2_.cachedClass_ != null);
                    if (s2_.cachedClass_.isInstance(arg0Value_)) {
                        return IsJSObjectNode.isObjectJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedResult_);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        if ((state & 4) != 0) {
            return IsJSObjectNode.isObject(arg0Value, this.isObject_resultProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape cachedShape__2;
                    int count1_ = 0;
                    IsObjectShapeData s1_ = this.isObjectShape_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.cachedShape_.check(arg0Value_)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedShape__2 = arg0Value_.getShape()).check(arg0Value_) && count1_ < 1) {
                        s1_ = new IsObjectShapeData(this.isObjectShape_cache);
                        s1_.cachedShape_ = cachedShape__2;
                        s1_.cachedResult_ = this.guardIsJSObject(arg0Value_);
                        this.isObjectShape_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean cachedShape__2 = IsJSObjectNode.isObjectShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                        return cachedShape__2;
                    }
                }
                if ((exclude & 2) == 0) {
                    JSClass cachedClass__;
                    int count2_ = 0;
                    IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null) {
                            assert (s2_.cachedClass_ != null);
                            if (s2_.cachedClass_.isInstance(arg0Value_)) break;
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (cachedClass__ = JSGuards.getJSClassChecked(arg0Value_)) != null && cachedClass__.isInstance(arg0Value_) && count2_ < 1) {
                        s2_ = new IsObjectJSClassData(this.isObjectJSClass_cache);
                        s2_.cachedClass_ = cachedClass__;
                        s2_.cachedResult_ = this.guardIsJSObject(arg0Value_);
                        this.isObjectJSClass_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.isObjectShape_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = IsJSObjectNode.isObjectJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedResult_);
                        return bl;
                    }
                }
            }
            this.isObject_resultProfile_ = ConditionProfile.createBinaryProfile();
            this.exclude_ = exclude |= 3;
            this.isObjectShape_cache = null;
            this.isObjectJSClass_cache = null;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = IsJSObjectNode.isObject(arg0Value, this.isObject_resultProfile_);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            IsObjectShapeData s1_ = this.isObjectShape_cache;
            IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "isObjectShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            IsObjectShapeData s1_ = this.isObjectShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "isObjectJSClass";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(s2_.cachedClass_, s2_.cachedResult_));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "isObject";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.isObject_resultProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create(data);
    }

    public static IsJSObjectNode create(boolean includeNullUndefined) {
        return new IsJSObjectNodeGen(includeNullUndefined);
    }

    @GeneratedBy(value=IsJSObjectNode.class)
    private static final class IsObjectJSClassData {
        @CompilerDirectives.CompilationFinal
        IsObjectJSClassData next_;
        @CompilerDirectives.CompilationFinal
        JSClass cachedClass_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsObjectJSClassData(IsObjectJSClassData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=IsJSObjectNode.class)
    private static final class IsObjectShapeData {
        @CompilerDirectives.CompilationFinal
        IsObjectShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsObjectShapeData(IsObjectShapeData next_) {
            this.next_ = next_;
        }
    }
}

