/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GetPrototypeNode.class)
public final class GetPrototypeNodeGen
extends GetPrototypeNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedShapeData cachedShape_cache;
    @CompilerDirectives.CompilationFinal
    private JSClassProfile proxy_jsclassProfile_;

    private GetPrototypeNodeGen() {
    }

    @Override
    @ExplodeLoop
    public DynamicObject executeJSObject(Object arg0Value) {
        int state = this.state_;
        if ((state & 7) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                CachedShapeData s1_ = this.cachedShape_cache;
                while (s1_ != null) {
                    if (arg0Value_.getShape() == s1_.shape_) {
                        assert (s1_.prototypeProperty_ != null);
                        return this.doCachedShape(arg0Value_, s1_.shape_, s1_.prototypeProperty_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && !JSGuards.isJSProxy(arg0Value_)) {
                return this.doGeneric(arg0Value_);
            }
            if ((state & 4) != 0 && JSGuards.isJSProxy(arg0Value_)) {
                return this.doProxy(arg0Value_, this.proxy_jsclassProfile_);
            }
        }
        if ((state & 8) != 0 && !JSGuards.isDynamicObject(arg0Value)) {
            return this.doNotObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    @ExplodeLoop
    protected DynamicObject executeDynamicObject(DynamicObject arg0Value) {
        int state = this.state_;
        if ((state & 7) != 0) {
            if ((state & 1) != 0) {
                CachedShapeData s1_ = this.cachedShape_cache;
                while (s1_ != null) {
                    if (arg0Value.getShape() == s1_.shape_) {
                        assert (s1_.prototypeProperty_ != null);
                        return this.doCachedShape(arg0Value, s1_.shape_, s1_.prototypeProperty_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && !JSGuards.isJSProxy(arg0Value)) {
                return this.doGeneric(arg0Value);
            }
            if ((state & 4) != 0 && JSGuards.isJSProxy(arg0Value)) {
                return this.doProxy(arg0Value, this.proxy_jsclassProfile_);
            }
        }
        if ((state & 8) != 0 && !JSGuards.isDynamicObject(arg0Value)) {
            return this.doNotObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private DynamicObject executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedShapeData s1_ = this.cachedShape_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (arg0Value_.getShape() == s1_.shape_) {
                                assert (s1_.prototypeProperty_ != null);
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        Property prototypeProperty__;
                        Shape shape__ = arg0Value_.getShape();
                        if (arg0Value_.getShape() == shape__ && (prototypeProperty__ = GetPrototypeNode.getPrototypeProperty(shape__)) != null && count1_ < 2) {
                            s1_ = new CachedShapeData(this.cachedShape_cache);
                            s1_.shape_ = shape__;
                            s1_.prototypeProperty_ = prototypeProperty__;
                            this.cachedShape_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doCachedShape(arg0Value_, s1_.shape_, s1_.prototypeProperty_);
                        return dynamicObject;
                    }
                }
                if (!JSGuards.isJSProxy(arg0Value_)) {
                    this.exclude_ = exclude |= 1;
                    this.cachedShape_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doGeneric(arg0Value_);
                    return dynamicObject;
                }
                if (JSGuards.isJSProxy(arg0Value_)) {
                    this.proxy_jsclassProfile_ = JSClassProfile.create();
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doProxy(arg0Value_, this.proxy_jsclassProfile_);
                    return dynamicObject;
                }
            }
            if (!JSGuards.isDynamicObject(arg0Value)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doNotObject(arg0Value);
                return dynamicObject;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedShapeData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cachedShape_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedShapeData s1_ = this.cachedShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.shape_, s1_.prototypeProperty_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doProxy";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.proxy_jsclassProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doNotObject";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create(data);
    }

    public static GetPrototypeNode create() {
        return new GetPrototypeNodeGen();
    }

    @GeneratedBy(value=GetPrototypeNode.class)
    private static final class CachedShapeData {
        @CompilerDirectives.CompilationFinal
        CachedShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape shape_;
        @CompilerDirectives.CompilationFinal
        Property prototypeProperty_;

        CachedShapeData(CachedShapeData next_) {
            this.next_ = next_;
        }
    }
}

