/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.objects.Dead;

public abstract class FrameSlotNode
extends JavaScriptNode {
    @CompilerDirectives.CompilationFinal
    protected FrameSlot frameSlot;

    protected FrameSlotNode(FrameSlot frameSlot) {
        assert (frameSlot != null) : "Frame slot must not be null";
        this.frameSlot = frameSlot;
    }

    public final FrameSlot getFrameSlot() {
        return this.frameSlot;
    }

    public final void setFrameSlot(FrameSlot frameSlot) {
        assert (frameSlot != null);
        this.frameSlot = frameSlot;
    }

    public final Object getIdentifier() {
        return this.frameSlot.getIdentifier();
    }

    public abstract ScopeFrameNode getLevelFrameNode();

    protected final boolean getBoolean(Frame frame) {
        return FrameUtil.getBooleanSafe(frame, this.frameSlot);
    }

    protected final int getInt(Frame frame) {
        return FrameUtil.getIntSafe(frame, this.frameSlot);
    }

    protected final double getDouble(Frame frame) {
        return FrameUtil.getDoubleSafe(frame, this.frameSlot);
    }

    protected final Object getObject(Frame frame) {
        return FrameUtil.getObjectSafe(frame, this.frameSlot);
    }

    protected final long getLong(Frame frame) {
        return FrameUtil.getLongSafe(frame, this.frameSlot);
    }

    protected final boolean isBoolean(Frame frame) {
        return frame.isBoolean(this.frameSlot);
    }

    protected final boolean isInt(Frame frame) {
        return frame.isInt(this.frameSlot);
    }

    protected final boolean isDouble(Frame frame) {
        return frame.isDouble(this.frameSlot);
    }

    protected final boolean isObject(Frame frame) {
        return frame.isObject(this.frameSlot);
    }

    protected final boolean isLong(Frame frame) {
        return frame.isLong(this.frameSlot);
    }

    protected final boolean isBooleanKind(Frame frame) {
        return this.isKind(frame, FrameSlotKind.Boolean);
    }

    protected final boolean isIntegerKind(Frame frame) {
        return this.isKind(frame, FrameSlotKind.Int);
    }

    protected final boolean isDoubleKind(Frame frame) {
        return this.isKind(frame, FrameSlotKind.Double) || this.intToDouble(frame);
    }

    protected final boolean isLongKind(Frame frame) {
        return this.isKind(frame, FrameSlotKind.Long) || this.intToLong(frame);
    }

    protected final boolean ensureObjectKind(Frame frame) {
        if (frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) != FrameSlotKind.Object) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            frame.getFrameDescriptor().setFrameSlotKind(this.frameSlot, FrameSlotKind.Object);
        }
        return true;
    }

    private boolean isKind(Frame frame, FrameSlotKind kind) {
        return frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) == kind || this.initialSetKind(frame, kind);
    }

    private boolean initialSetKind(Frame frame, FrameSlotKind kind) {
        if (frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) == FrameSlotKind.Illegal) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            frame.getFrameDescriptor().setFrameSlotKind(this.frameSlot, kind);
            return true;
        }
        return false;
    }

    private boolean intToDouble(Frame frame) {
        if (frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) == FrameSlotKind.Int || frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) == FrameSlotKind.Long) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            frame.getFrameDescriptor().setFrameSlotKind(this.frameSlot, FrameSlotKind.Double);
            return true;
        }
        return false;
    }

    private boolean intToLong(Frame frame) {
        if (frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot) == FrameSlotKind.Int) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            frame.getFrameDescriptor().setFrameSlotKind(this.frameSlot, FrameSlotKind.Long);
            return true;
        }
        return false;
    }

    protected final FrameSlotKind getKind(Frame frame) {
        return frame.getFrameDescriptor().getFrameSlotKind(this.frameSlot);
    }

    public boolean hasTemporalDeadZone() {
        return false;
    }

    protected final Object checkNotDead(Object value, BranchProfile deadBranch) {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, value == Dead.instance())) {
            deadBranch.enter();
            throw Errors.createReferenceErrorNotDefined(this.frameSlot.getIdentifier(), this);
        }
        return value;
    }
}

