/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public class DeclareEvalVariableNode
extends StatementNode {
    @Node.Child
    private JavaScriptNode dynamicScopeNode;
    @Node.Child
    private WriteNode initScopeNode;
    @Node.Child
    private HasPropertyCacheNode hasProperty;
    @Node.Child
    private PropertySetNode defineProperty;
    private final JSContext context;
    private final String varName;

    public DeclareEvalVariableNode(JSContext context, String varName, JavaScriptNode dynamicScopeNode, WriteNode writeDynamicScopeNode) {
        this.context = context;
        this.varName = varName;
        this.dynamicScopeNode = dynamicScopeNode;
        this.initScopeNode = writeDynamicScopeNode;
        this.hasProperty = HasPropertyCacheNode.create(varName, context);
        this.defineProperty = PropertySetNode.create(varName, false, context, false);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject dynamicScope = (DynamicObject)this.dynamicScopeNode.execute(frame);
        if (dynamicScope == Undefined.instance) {
            dynamicScope = JSUserObject.createWithNullPrototype(this.context);
            this.initScopeNode.executeWrite(frame, dynamicScope);
        }
        assert (DeclareEvalVariableNode.isValidDynamicScopeObject(dynamicScope));
        if (!this.hasProperty.hasProperty(dynamicScope)) {
            assert (frame.getFrameDescriptor().findFrameSlot(this.varName) == null);
            this.defineProperty.setValue(dynamicScope, Undefined.instance);
        }
        return EMPTY;
    }

    private static boolean isValidDynamicScopeObject(DynamicObject dynamicScope) {
        return dynamicScope != Undefined.instance && dynamicScope != Null.instance && dynamicScope != null;
    }

    public String getName() {
        return this.varName;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new DeclareEvalVariableNode(this.context, this.varName, DeclareEvalVariableNode.cloneUninitialized(this.dynamicScopeNode, materializedTags), (WriteNode)((Object)DeclareEvalVariableNode.cloneUninitialized((JavaScriptNode)((Object)this.initScopeNode), materializedTags)));
    }
}

