/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.CachedGetPropertyNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertySetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=CachedSetPropertyNode.class)
final class CachedSetPropertyNodeGen
extends CachedSetPropertyNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedKeyData cachedKey_cache;
    @CompilerDirectives.CompilationFinal
    private JSClassProfile intIndex_jsclassProfile_;
    @Node.Child
    private ArrayIndexData arrayIndex_cache;
    @Node.Child
    private JSProxyPropertySetNode proxy_proxySet_;
    @Node.Child
    private GenericData generic_cache;

    private CachedSetPropertyNodeGen(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        super(context, strict, setOwn, superProperty);
    }

    @Override
    @ExplodeLoop
    public void execute(DynamicObject arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
        int state = this.state_;
        if (state != 0) {
            int arg1Value_;
            if ((state & 1) != 0) {
                CachedKeyData s1_ = this.cachedKey_cache;
                while (s1_ != null) {
                    assert (s1_.cachedKey_ != null);
                    assert (!JSRuntime.isArrayIndex(s1_.cachedKey_));
                    if (JSRuntime.propertyKeyEquals(s1_.cachedKey_, arg1Value)) {
                        this.doCachedKey(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedKey_, s1_.propertyNode_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && arg1Value instanceof Integer && JSRuntime.isArrayIndex(arg1Value_ = ((Integer)arg1Value).intValue()) && !JSGuards.isJSProxy(arg0Value)) {
                this.doIntIndex(arg0Value, arg1Value_, arg2Value, arg3Value, this.intIndex_jsclassProfile_);
                return;
            }
            if ((state & 0x1C) != 0) {
                GenericData s5_;
                if ((state & 4) != 0) {
                    ArrayIndexData s3_ = this.arrayIndex_cache;
                    while (s3_ != null) {
                        if (s3_.toArrayIndexNode_.isArrayIndex(arg1Value) && !JSGuards.isJSProxy(arg0Value)) {
                            this.doArrayIndex(arg0Value, arg1Value, arg2Value, arg3Value, s3_.toArrayIndexNode_, s3_.jsclassProfile_);
                            return;
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0 && JSGuards.isJSProxy(arg0Value)) {
                    this.doProxy(arg0Value, arg1Value, arg2Value, arg3Value, this.proxy_proxySet_);
                    return;
                }
                if ((state & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
                    this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : this.countCaches();
        try {
            int arg1Value_;
            if ((exclude & 1) == 0) {
                Object cachedKey__;
                int count1_ = 0;
                CachedKeyData s1_ = this.cachedKey_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.cachedKey_ != null);
                        assert (!JSRuntime.isArrayIndex(s1_.cachedKey_));
                        if (JSRuntime.propertyKeyEquals(s1_.cachedKey_, arg1Value)) break;
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedKey__ = CachedGetPropertyNode.cachedPropertyKey(arg1Value)) != null && !JSRuntime.isArrayIndex(cachedKey__) && JSRuntime.propertyKeyEquals(cachedKey__, arg1Value) && count1_ < 1) {
                    s1_ = super.insert(new CachedKeyData(this.cachedKey_cache));
                    s1_.cachedKey_ = cachedKey__;
                    s1_.propertyNode_ = s1_.insertAccessor(this.createSet(cachedKey__));
                    this.cachedKey_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doCachedKey(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedKey_, s1_.propertyNode_);
                    return;
                }
            }
            if ((exclude & 2) == 0 && arg1Value instanceof Integer && JSRuntime.isArrayIndex(arg1Value_ = ((Integer)arg1Value).intValue()) && !JSGuards.isJSProxy(arg0Value)) {
                this.intIndex_jsclassProfile_ = JSClassProfile.create();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doIntIndex(arg0Value, arg1Value_, arg2Value, arg3Value, this.intIndex_jsclassProfile_);
                return;
            }
            if ((exclude & 4) == 0) {
                ToArrayIndexNode toArrayIndexNode__;
                int count3_ = 0;
                ArrayIndexData s3_ = this.arrayIndex_cache;
                if ((state & 4) != 0) {
                    while (s3_ != null && (!s3_.toArrayIndexNode_.isArrayIndex(arg1Value) || JSGuards.isJSProxy(arg0Value))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && (toArrayIndexNode__ = super.insert(ToArrayIndexNode.createNoToPropertyKey())).isArrayIndex(arg1Value) && !JSGuards.isJSProxy(arg0Value) && count3_ < 3) {
                    s3_ = super.insert(new ArrayIndexData(this.arrayIndex_cache));
                    s3_.toArrayIndexNode_ = s3_.insertAccessor(toArrayIndexNode__);
                    s3_.jsclassProfile_ = JSClassProfile.create();
                    this.arrayIndex_cache = s3_;
                    this.exclude_ = exclude |= 2;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doArrayIndex(arg0Value, arg1Value, arg2Value, arg3Value, s3_.toArrayIndexNode_, s3_.jsclassProfile_);
                    return;
                }
            }
            if ((exclude & 8) == 0 && JSGuards.isJSProxy(arg0Value)) {
                this.proxy_proxySet_ = super.insert(JSProxyPropertySetNode.create(this.context, this.strict));
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                this.doProxy(arg0Value, arg1Value, arg2Value, arg3Value, this.proxy_proxySet_);
                return;
            }
            GenericData s5_ = super.insert(new GenericData());
            s5_.toArrayIndexNode_ = s5_.insertAccessor(ToArrayIndexNode.create());
            s5_.getType_ = ConditionProfile.createBinaryProfile();
            s5_.jsclassProfile_ = JSClassProfile.create();
            this.generic_cache = s5_;
            this.exclude_ = exclude |= 0xF;
            this.cachedKey_cache = null;
            this.arrayIndex_cache = null;
            state &= 0xFFFFFFF0;
            this.state_ = state |= 0x10;
            lock.unlock();
            hasLock = false;
            this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_);
            return;
        }
        finally {
            if (oldState != 0 || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        CachedKeyData s1_ = this.cachedKey_cache;
        while (s1_ != null) {
            ++cacheCount;
            s1_ = s1_.next_;
        }
        ArrayIndexData s3_ = this.arrayIndex_cache;
        while (s3_ != null) {
            ++cacheCount;
            s3_ = s3_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedKeyData s1_ = this.cachedKey_cache;
            ArrayIndexData s3_ = this.arrayIndex_cache;
            if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedKeyData s1_ = this.cachedKey_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedKey_, s1_.propertyNode_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIntIndex";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.intIndex_jsclassProfile_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doArrayIndex";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ArrayIndexData s3_ = this.arrayIndex_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(s3_.toArrayIndexNode_, s3_.jsclassProfile_));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doProxy";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.proxy_proxySet_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s5_ = this.generic_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create(data);
    }

    public static CachedSetPropertyNode create(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        return new CachedSetPropertyNodeGen(context, strict, setOwn, superProperty);
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile getType_;
        @CompilerDirectives.CompilationFinal
        JSClassProfile jsclassProfile_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class ArrayIndexData
    extends Node {
        @Node.Child
        ArrayIndexData next_;
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        JSClassProfile jsclassProfile_;

        ArrayIndexData(ArrayIndexData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class CachedKeyData
    extends Node {
        @Node.Child
        CachedKeyData next_;
        @CompilerDirectives.CompilationFinal
        Object cachedKey_;
        @Node.Child
        PropertySetNode propertyNode_;

        CachedKeyData(CachedKeyData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

