/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.builtins.math.SignNode;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=SignNode.class)
public final class SignNodeGen
extends SignNode
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private SignNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && (state & 7) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 5) == 0 && (state & 7) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return SignNode.sign(arguments0Value_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0x70) == 0 && (state & 7) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return SignNode.sign(arguments0Value_);
    }

    private Object execute_generic2(VirtualFrame frameValue, int state) {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
            int arguments0Value__ = (Integer)arguments0Value_;
            return SignNode.sign(arguments0Value__);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
            return SignNode.sign(arguments0Value__);
        }
        if ((state & 4) != 0) {
            return this.sign(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 4) == 0 && (state & 6) != 0) {
            return this.executeDouble_double3(frameValue, state);
        }
        return this.executeDouble_generic4(frameValue, state);
    }

    private double executeDouble_double3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0x70) == 0 && (state & 7) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 2) != 0);
        return SignNode.sign(arguments0Value_);
    }

    private double executeDouble_generic4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, arguments0Value_);
            return SignNode.sign(arguments0Value__);
        }
        if ((state & 4) != 0) {
            return this.sign(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int arguments0Value_;
        int state = this.state_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 1) != 0) {
            return SignNode.sign(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 6) == 0 && (state & 7) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 1) == 0 && (state & 7) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state = this.state_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (Integer)arguments0Value;
            this.state_ = state |= 1;
            return SignNode.sign(arguments0Value_);
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
        if (doubleCast0 != 0) {
            double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
            state |= doubleCast0 << 3;
            this.state_ = state |= 2;
            return SignNode.sign(arguments0Value_);
        }
        this.state_ = state |= 4;
        return this.sign(arguments0Value);
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 7 & (state & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "sign";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "sign";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "sign";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create(data);
    }

    public static SignNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new SignNodeGen(context, builtin, arguments);
    }
}

