/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.builtins.math.Log10Node;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=Log10Node.class)
public final class Log10NodeGen
extends Log10Node
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private Log10NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && (state & 3) != 0) {
            return this.execute_double0(frameValue, state);
        }
        return this.execute_generic1(frameValue, state);
    }

    private Object execute_double0(VirtualFrame frameValue, int state) {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0x38) == 0 && (state & 3) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0x34) == 0 && (state & 3) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0x2C) == 0 && (state & 3) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x3C) >>> 2, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return Log10Node.log10(arguments0Value_);
    }

    private Object execute_generic1(VirtualFrame frameValue, int state) {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 1) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C) >>> 2, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x3C) >>> 2, arguments0Value_);
            return Log10Node.log10(arguments0Value__);
        }
        if ((state & 2) != 0) {
            return this.log10(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && (state & 3) != 0) {
            return this.executeDouble_double2(frameValue, state);
        }
        return this.executeDouble_generic3(frameValue, state);
    }

    private double executeDouble_double2(VirtualFrame frameValue, int state) {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0x38) == 0 && (state & 3) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0x34) == 0 && (state & 3) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0x2C) == 0 && (state & 3) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x3C) >>> 2, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return Log10Node.log10(arguments0Value_);
    }

    private double executeDouble_generic3(VirtualFrame frameValue, int state) {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 1) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C) >>> 2, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x3C) >>> 2, arguments0Value_);
            return Log10Node.log10(arguments0Value__);
        }
        if ((state & 2) != 0) {
            return this.log10(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeDouble(frameValue);
    }

    private double executeAndSpecialize(Object arguments0Value) {
        int state = this.state_;
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
        if (doubleCast0 != 0) {
            double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
            state |= doubleCast0 << 2;
            this.state_ = state |= 1;
            return Log10Node.log10(arguments0Value_);
        }
        this.state_ = state |= 2;
        return this.log10(arguments0Value);
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 3 & (state & 3) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "log10";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "log10";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static Log10Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new Log10NodeGen(context, builtin, arguments);
    }
}

