/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.FloorNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FloorNode.class)
public final class FloorNodeGen
extends FloorNode
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile floorMightReturnInt_smaller_;
    @CompilerDirectives.CompilationFinal
    private FloorReturnsDoubleData floorReturnsDouble_cache;

    private FloorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xE) == 0 && state != 0) {
            return this.execute_int0(frameValue, state);
        }
        return this.execute_generic1(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return FloorNode.floor(arguments0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_generic1(VirtualFrame frameValue, int state) {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
            int arguments0Value__ = (Integer)arguments0Value_;
            return FloorNode.floor(arguments0Value__);
        }
        if ((state & 2) != 0 && arguments0Value_ instanceof SafeInteger) {
            SafeInteger arguments0Value__ = (SafeInteger)arguments0Value_;
            return FloorNode.floor(arguments0Value__);
        }
        if ((state & 0xC) != 0) {
            FloorReturnsDoubleData s4_;
            if ((state & 4) != 0) {
                try {
                    return this.floorMightReturnInt(arguments0Value_, this.floorMightReturnInt_smaller_);
                }
                catch (SlowPathException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_ &= 0xFFFFFFFB;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(arguments0Value_);
                }
            }
            if ((state & 8) != 0 && (s4_ = this.floorReturnsDouble_cache) != null) {
                return this.floorReturnsDouble(arguments0Value_, s4_.isNaN_, s4_.isNegativeZero_, s4_.fitsSafeLong_, s4_.smaller_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        FloorReturnsDoubleData s4_;
        int state = this.state_;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 8) != 0 && (s4_ = this.floorReturnsDouble_cache) != null) {
            return this.floorReturnsDouble(arguments0Value_, s4_.isNaN_, s4_.isNegativeZero_, s4_.fitsSafeLong_, s4_.smaller_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 4) == 0 && (state & 5) != 0) {
            return this.executeInt_int2(frameValue, state);
        }
        return this.executeInt_generic3(frameValue, state);
    }

    private int executeInt_int2(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 1) != 0);
        return FloorNode.floor(arguments0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInt_generic3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
            int arguments0Value__ = (Integer)arguments0Value_;
            return FloorNode.floor(arguments0Value__);
        }
        if ((state & 4) != 0) {
            try {
                return this.floorMightReturnInt(arguments0Value_, this.floorMightReturnInt_smaller_);
            }
            catch (SlowPathException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 1;
                    this.state_ &= 0xFFFFFFFB;
                }
                finally {
                    lock.unlock();
                }
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0xA) == 0 && state != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 7) == 0 && state != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object arguments0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = FloorNode.floor(arguments0Value_);
                return n;
            }
            if (arguments0Value instanceof SafeInteger) {
                SafeInteger arguments0Value_ = (SafeInteger)arguments0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                SafeInteger safeInteger = FloorNode.floor(arguments0Value_);
                return safeInteger;
            }
            if (exclude == 0) {
                this.floorMightReturnInt_smaller_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 4;
                try {
                    lock.unlock();
                    hasLock = false;
                    Integer arguments0Value_ = this.floorMightReturnInt(arguments0Value, this.floorMightReturnInt_smaller_);
                    return arguments0Value_;
                }
                catch (SlowPathException ex) {
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_ &= 0xFFFFFFFB;
                    }
                    finally {
                        lock.unlock();
                    }
                    Object object = this.executeAndSpecialize(arguments0Value);
                    if (hasLock) {
                        lock.unlock();
                    }
                    return object;
                }
            }
            FloorReturnsDoubleData s4_ = new FloorReturnsDoubleData();
            s4_.isNaN_ = ConditionProfile.createBinaryProfile();
            s4_.isNegativeZero_ = ConditionProfile.createBinaryProfile();
            s4_.fitsSafeLong_ = ConditionProfile.createBinaryProfile();
            s4_.smaller_ = ConditionProfile.createBinaryProfile();
            this.floorReturnsDouble_cache = s4_;
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Double d = this.floorReturnsDouble(arguments0Value, s4_.isNaN_, s4_.isNegativeZero_, s4_.fitsSafeLong_, s4_.smaller_);
            return d;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<ConditionProfile>> cached;
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "floor";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "floor";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "floorMightReturnInt";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.floorMightReturnInt_smaller_));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "floorReturnsDouble";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            FloorReturnsDoubleData s4_ = this.floorReturnsDouble_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(s4_.isNaN_, s4_.isNegativeZero_, s4_.fitsSafeLong_, s4_.smaller_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        return Introspection.Provider.create(data);
    }

    public static FloorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new FloorNodeGen(context, builtin, arguments);
    }

    @GeneratedBy(value=FloorNode.class)
    private static final class FloorReturnsDoubleData {
        @CompilerDirectives.CompilationFinal
        ConditionProfile isNaN_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isNegativeZero_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile fitsSafeLong_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile smaller_;

        FloorReturnsDoubleData() {
        }
    }
}

