/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSONBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSONBuiltins.class)
public final class JSONBuiltinsFactory {

    @GeneratedBy(value=JSONBuiltins.JSONStringifyNode.class)
    public static final class JSONStringifyNodeGen
    extends JSONBuiltins.JSONStringifyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private StringBuilderProfile stringifyAStringNoReplacer_stringBuilderProfile_;

        private JSONStringifyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if ((state & 1) != 0 && this.isCallable(arguments1Value__)) {
                        return this.stringify(arguments0Value_, arguments1Value__, arguments2Value_);
                    }
                    if ((state & 2) != 0 && this.isArray(arguments1Value__)) {
                        return this.stringifyReplacerArray(arguments0Value_, arguments1Value__, arguments2Value_);
                    }
                }
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0 && JSGuards.isString(arguments0Value_) && !this.isCallable(arguments1Value_) && !this.isArray(arguments1Value_)) {
                        return this.stringifyAStringNoReplacer(arguments0Value_, arguments1Value_, arguments2Value_, this.stringifyAStringNoReplacer_stringBuilderProfile_);
                    }
                    if (!((state & 8) == 0 || JSGuards.isString(arguments0Value_) || this.isCallable(arguments1Value_) || this.isArray(arguments1Value_))) {
                        return this.stringifyNoReplacer(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                Object object;
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                    if (this.isCallable(arguments1Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.stringify(arguments0Value, arguments1Value_, arguments2Value);
                        return object2;
                    }
                    if (this.isArray(arguments1Value_)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object3 = this.stringifyReplacerArray(arguments0Value, arguments1Value_, arguments2Value);
                        return object3;
                    }
                }
                if (JSGuards.isString(arguments0Value) && !this.isCallable(arguments1Value) && !this.isArray(arguments1Value)) {
                    this.stringifyAStringNoReplacer_stringBuilderProfile_ = this.createStringBuilderProfile();
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    object = this.stringifyAStringNoReplacer(arguments0Value, arguments1Value, arguments2Value, this.stringifyAStringNoReplacer_stringBuilderProfile_);
                    return object;
                }
                if (!(JSGuards.isString(arguments0Value) || this.isCallable(arguments1Value) || this.isArray(arguments1Value))) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    object = this.stringifyNoReplacer(arguments0Value, arguments1Value, arguments2Value);
                    return object;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "stringify";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "stringifyReplacerArray";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "stringifyAStringNoReplacer";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                ArrayList<List<StringBuilderProfile>> cached = new ArrayList<List<StringBuilderProfile>>();
                cached.add(Arrays.asList(this.stringifyAStringNoReplacer_stringBuilderProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "stringifyNoReplacer";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create(data);
        }

        public static JSONBuiltins.JSONStringifyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSONStringifyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=JSONBuiltins.JSONParseNode.class)
    public static final class JSONParseNodeGen
    extends JSONBuiltins.JSONParseNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private IsCallableNode isCallable;

        private JSONParseNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0 && this.isCallable.executeBoolean(arguments1Value_)) {
                    return this.parse(arguments0Value_, arguments1Value_, this.isCallable);
                }
                if ((state & 2) != 0 && !this.isCallable.executeBoolean(arguments1Value_)) {
                    return this.parseUnfiltered(arguments0Value_, arguments1Value_, this.isCallable);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                IsCallableNode parseUnfiltered_isCallable__;
                Object parse_isCallable__;
                boolean Parse_duplicateFound_ = false;
                if ((state & 1) != 0 && this.isCallable.executeBoolean(arguments1Value)) {
                    Parse_duplicateFound_ = true;
                }
                if (!Parse_duplicateFound_ && ((IsCallableNode)(parse_isCallable__ = super.insert(IsCallableNode.create()))).executeBoolean(arguments1Value) && (state & 1) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert(parse_isCallable__);
                    }
                    this.state_ = state |= 1;
                    Parse_duplicateFound_ = true;
                }
                if (Parse_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    parse_isCallable__ = this.parse(arguments0Value, arguments1Value, this.isCallable);
                    return parse_isCallable__;
                }
                boolean ParseUnfiltered_duplicateFound_ = false;
                if ((state & 2) != 0 && !this.isCallable.executeBoolean(arguments1Value)) {
                    ParseUnfiltered_duplicateFound_ = true;
                }
                if (!ParseUnfiltered_duplicateFound_ && !(parseUnfiltered_isCallable__ = super.insert(IsCallableNode.create())).executeBoolean(arguments1Value) && (state & 2) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = super.insert(parseUnfiltered_isCallable__);
                    }
                    this.state_ = state |= 2;
                    ParseUnfiltered_duplicateFound_ = true;
                }
                if (ParseUnfiltered_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.parseUnfiltered(arguments0Value, arguments1Value, this.isCallable);
                    return object;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<IsCallableNode>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "parse";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<IsCallableNode>>();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "parseUnfiltered";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create(data);
        }

        public static JSONBuiltins.JSONParseNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSONParseNodeGen(context, builtin, arguments);
        }
    }
}

