/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JSONBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSONData;
import com.oracle.truffle.js.builtins.helper.JSONStringifyStringNode;
import com.oracle.truffle.js.builtins.helper.TruffleJSONParser;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class JSONBuiltins
extends JSBuiltinsContainer.SwitchEnum<JSON> {
    public static final JSBuiltinsContainer BUILTINS = new JSONBuiltins();

    protected JSONBuiltins() {
        super("JSON", JSON.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, JSON builtinEnum) {
        switch (builtinEnum) {
            case parse: {
                return JSONBuiltinsFactory.JSONParseNodeGen.create(context, builtin, JSONBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case stringify: {
                return JSONBuiltinsFactory.JSONStringifyNodeGen.create(context, builtin, JSONBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSONStringifyNode
    extends JSONOperation {
        @Node.Child
        private JSONStringifyStringNode jsonStringifyStringNode;
        @Node.Child
        private CreateDataPropertyNode createWrapperPropertyNode;
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSIsArrayNode isArrayNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        private final BranchProfile spaceIsStringBranch = BranchProfile.create();
        private final ConditionProfile spaceIsUndefinedProfile = ConditionProfile.createBinaryProfile();

        public JSONStringifyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object jsonStr(Object jsonData, String key, DynamicObject holder) {
            if (this.jsonStringifyStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.jsonStringifyStringNode = this.insert(JSONStringifyStringNode.create(this.getContext()));
            }
            return this.jsonStringifyStringNode.execute(jsonData, key, holder);
        }

        @Override
        protected boolean isArray(Object replacer) {
            if (this.isArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isArrayNode = this.insert(JSIsArrayNode.createIsArrayLike());
            }
            return this.isArrayNode.execute(replacer);
        }

        protected boolean isCallable(Object obj) {
            if (this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isCallableNode = this.insert(IsCallableNode.create());
            }
            return this.isCallableNode.executeBoolean(obj);
        }

        @Specialization(guards={"isCallable(replacerFn)"})
        protected Object stringify(Object value, DynamicObject replacerFn, Object spaceParam) {
            assert (JSRuntime.isCallable(replacerFn));
            return this.stringifyIntl(value, spaceParam, replacerFn, null);
        }

        @Specialization(guards={"isArray(replacerObj)"})
        protected Object stringifyReplacerArray(Object value, DynamicObject replacerObj, Object spaceParam) {
            int len = (int)JSRuntime.toLength(JSObject.get(replacerObj, (Object)"length"));
            ArrayList<String> replacerList = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                Object v = JSObject.get(replacerObj, (Object)JSRuntime.toString(i));
                String item = null;
                if (JSRuntime.isString(v)) {
                    item = JSRuntime.toStringIsString(v);
                } else if (JSRuntime.isNumber(v) || JSNumber.isJSNumber(v) || JSString.isJSString(v)) {
                    item = this.toString(v);
                }
                if (item == null) continue;
                JSONStringifyNode.addToReplacer(replacerList, item);
            }
            return this.stringifyIntl(value, spaceParam, null, replacerList);
        }

        @CompilerDirectives.TruffleBoundary
        private static void addToReplacer(List<String> replacerList, String item) {
            if (!replacerList.contains(item)) {
                replacerList.add(item);
            }
        }

        @Specialization(guards={"isString(value)", "!isCallable(replacer)", "!isArray(replacer)"})
        protected Object stringifyAStringNoReplacer(Object value, Object replacer, Object spaceParam, @Cached(value="createStringBuilderProfile()") StringBuilderProfile stringBuilderProfile) {
            String str = JSRuntime.toStringIsString(value);
            StringBuilder builder = new StringBuilder(str.length() + 8);
            JSONStringifyStringNode.jsonQuote(stringBuilderProfile, builder, str);
            return stringBuilderProfile.toString(builder);
        }

        protected StringBuilderProfile createStringBuilderProfile() {
            return StringBuilderProfile.create(this.getContext().getStringLengthLimit());
        }

        @Specialization(guards={"!isString(value)", "!isCallable(replacer)", "!isArray(replacer)"})
        protected Object stringifyNoReplacer(Object value, Object replacer, Object spaceParam) {
            return this.stringifyIntl(value, spaceParam, null, null);
        }

        private Object stringifyIntl(Object value, Object spaceParam, DynamicObject replacerFnObj, List<String> replacerList) {
            String gap = this.spaceIsUndefinedProfile.profile(spaceParam == Undefined.instance) ? "" : this.getGap(spaceParam);
            DynamicObject wrapper = JSUserObject.create(this.getContext());
            if (this.createWrapperPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createWrapperPropertyNode = this.insert(CreateDataPropertyNode.create(this.getContext(), ""));
            }
            this.createWrapperPropertyNode.executeVoid(wrapper, value);
            return this.jsonStr(new JSONData(gap, replacerFnObj, replacerList), "", wrapper);
        }

        private String getGap(Object spaceParam) {
            Object space = spaceParam;
            if (JSObject.isDynamicObject(space)) {
                if (JSNumber.isJSNumber(space)) {
                    space = this.toNumber(space);
                } else if (JSString.isJSString(space)) {
                    space = this.toString(space);
                }
            }
            if (JSRuntime.isNumber(space)) {
                if (this.toIntegerNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toIntegerNode = this.insert(JSToIntegerAsIntNode.create());
                }
                int newSpace = Math.max(0, Math.min(10, this.toIntegerNode.executeInt(space)));
                return JSONStringifyNode.makeGap(newSpace);
            }
            if (JSRuntime.isString(space)) {
                this.spaceIsStringBranch.enter();
                return JSONStringifyNode.makeGap(JSRuntime.toStringIsString(space));
            }
            return "";
        }

        @CompilerDirectives.TruffleBoundary
        private static String makeGap(String spaceStr) {
            if (spaceStr.length() <= 10) {
                return spaceStr;
            }
            return spaceStr.substring(0, 10);
        }

        @CompilerDirectives.TruffleBoundary
        private static String makeGap(int spaceValue) {
            char[] ar = new char[spaceValue];
            Arrays.fill(ar, ' ');
            return new String(ar);
        }

        protected Number toNumber(Object target) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.executeNumber(target);
        }
    }

    public static abstract class JSONParseNode
    extends JSONOperation {
        public JSONParseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isCallable.executeBoolean(reviver)"}, limit="1")
        protected Object parse(Object text, Object reviver, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            Object unfiltered = this.parseIntl(this.toString(text));
            DynamicObject root = JSUserObject.create(this.getContext());
            JSObjectUtil.putDataProperty(this.getContext(), root, "", unfiltered, JSAttributes.getDefault());
            return this.walk((DynamicObject)reviver, root, "");
        }

        @Specialization(guards={"!isCallable.executeBoolean(reviver)"}, limit="1")
        protected Object parseUnfiltered(Object text, Object reviver, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            return this.parseIntl(this.toString(text));
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private Object parseIntl(String jsonString) {
            return new TruffleJSONParser(this.getContext()).parse(jsonString);
        }

        @CompilerDirectives.TruffleBoundary
        private Object walk(DynamicObject reviverFn, DynamicObject holder, String property) {
            Object value;
            block6: {
                value = JSObject.get(holder, (Object)property);
                if (!JSRuntime.isObject(value)) break block6;
                DynamicObject object = (DynamicObject)value;
                if (this.isArray(object)) {
                    int len = (int)JSRuntime.toLength(JSObject.get(object, (Object)"length"));
                    for (int i = 0; i < len; ++i) {
                        String stringIndex = String.valueOf(i);
                        Object newElement = this.walk(reviverFn, object, stringIndex);
                        if (newElement == Undefined.instance) {
                            JSObject.delete(object, i);
                            continue;
                        }
                        JSRuntime.createDataProperty(object, stringIndex, newElement);
                    }
                } else {
                    for (String p : JSObject.enumerableOwnNames(object)) {
                        Object newElement = this.walk(reviverFn, object, p);
                        if (newElement == Undefined.instance) {
                            JSObject.delete(object, p);
                            continue;
                        }
                        JSRuntime.createDataProperty(object, p, newElement);
                    }
                }
            }
            return JSRuntime.call(reviverFn, holder, new Object[]{property, value});
        }
    }

    public static abstract class JSONOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode;

        public JSONOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected String toString(Object target) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(target);
        }

        protected boolean isArray(Object replacer) {
            return JSRuntime.isArray(replacer);
        }
    }

    public static enum JSON implements BuiltinEnum<JSON>
    {
        parse(2),
        stringify(3);

        private final int length;

        private JSON(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

