/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.ErrorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ErrorPrototypeBuiltins
extends JSBuiltinsContainer.Switch {
    public static final JSBuiltinsContainer BUILTINS = new ErrorPrototypeBuiltins();

    protected ErrorPrototypeBuiltins() {
        super("Error.prototype");
        this.defineFunction("toString", 0);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
        switch (builtin.getName()) {
            case "toString": {
                return ErrorPrototypeBuiltinsFactory.ErrorPrototypeToStringNodeGen.create(context, builtin, ErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class ErrorPrototypeGetStackTraceNode
    extends JSBuiltinNode {
        public ErrorPrototypeGetStackTraceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected DynamicObject getStackTrace(Object thisObj) {
            throw Errors.createTypeErrorNotAnObject(thisObj);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getStackTrace(DynamicObject thisObj) {
            Object exception = thisObj.get(JSError.EXCEPTION_PROPERTY_NAME);
            Object[] stackTrace = ErrorPrototypeGetStackTraceNode.getStackTraceFromThrowable(exception);
            return JSArray.createConstant(this.getContext(), stackTrace);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] getStackTraceFromThrowable(Object exception) {
            if (exception instanceof GraalJSException) {
                return ((GraalJSException)exception).getJSStackTrace();
            }
            return new StackTraceElement[0];
        }
    }

    public static abstract class ErrorPrototypeToStringNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getNameNode;
        @Node.Child
        private PropertyGetNode getMessageNode;
        @Node.Child
        private JSToStringNode toStringNode;

        public ErrorPrototypeToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected String toStringNonObject(Object thisObj) {
            String name = this.toStringConv(thisObj);
            String message = JSRuntime.stringConcat("Method Error.prototype.toString called on incompatible receiver ", name);
            throw Errors.createTypeError(message, this);
        }

        @Specialization(guards={"isJSObject(errorObj)"})
        protected String toStringObject(DynamicObject errorObj) {
            String strMessage;
            Object objName = this.getName(errorObj);
            Object objMessage = this.getMessage(errorObj);
            String strName = objName == Undefined.instance ? "Error" : this.toStringConv(objName);
            String string = strMessage = objMessage == Undefined.instance ? "" : this.toStringConv(objMessage);
            if (strName.length() == 0) {
                return strMessage;
            }
            if (strMessage.length() == 0) {
                return strName;
            }
            return ErrorPrototypeToStringNode.toStringIntl(strName, strMessage);
        }

        private String toStringConv(Object value) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(value);
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStringIntl(String strName, String strMessage) {
            return strName + ": " + strMessage;
        }

        protected Object getName(DynamicObject errObj) {
            if (this.getNameNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNameNode = this.insert(PropertyGetNode.create("name", false, this.getContext()));
            }
            return this.getNameNode.getValue(errObj);
        }

        protected Object getMessage(DynamicObject errObj) {
            if (this.getMessageNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMessageNode = this.insert(PropertyGetNode.create("message", false, this.getContext()));
            }
            return this.getMessageNode.getValue(errObj);
        }
    }

    public static final class ErrorPrototypeNashornCompatBuiltins
    extends JSBuiltinsContainer.SwitchEnum<ErrorNashornCompat> {
        public static final JSBuiltinsContainer BUILTINS = new ErrorPrototypeNashornCompatBuiltins();

        protected ErrorPrototypeNashornCompatBuiltins() {
            super("Error.prototype", ErrorNashornCompat.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ErrorNashornCompat builtinEnum) {
            switch (builtinEnum) {
                case getStackTrace: {
                    return ErrorPrototypeBuiltinsFactory.ErrorPrototypeGetStackTraceNodeGen.create(context, builtin, ErrorPrototypeNashornCompatBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum ErrorNashornCompat implements BuiltinEnum<ErrorNashornCompat>
        {
            getStackTrace(0);

            private final int length;

            private ErrorNashornCompat(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }
}

