/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DefaultBlockNode;
import com.oracle.truffle.api.impl.DefaultCallTarget;
import com.oracle.truffle.api.impl.DefaultIndirectCallNode;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import java.io.OutputStream;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

final class DefaultRuntimeAccessor
extends Accessor {
    private static final DefaultRuntimeAccessor ACCESSOR = new DefaultRuntimeAccessor();
    static final Accessor.NodeSupport NODES = ACCESSOR.nodeSupport();
    static final Accessor.SourceSupport SOURCE = ACCESSOR.sourceSupport();
    static final Accessor.InstrumentSupport INSTRUMENT = ACCESSOR.instrumentSupport();
    static final Accessor.LanguageSupport LANGUAGE = ACCESSOR.languageSupport();
    static final Accessor.JDKSupport JDK = ACCESSOR.jdkSupport();
    static final Accessor.EngineSupport ENGINE = ACCESSOR.engineSupport();
    static final Accessor.InteropSupport INTEROP = ACCESSOR.interopSupport();

    private DefaultRuntimeAccessor() {
    }

    static final class DefaultRuntimeSupport
    extends Accessor.RuntimeSupport {
        DefaultRuntimeSupport(Object permission) {
            super(permission);
        }

        @Override
        public IndirectCallNode createUncachedIndirectCall() {
            return DefaultIndirectCallNode.createUncached();
        }

        @Override
        public void onLoopCount(Node source, int iterations) {
        }

        @Override
        public OptionDescriptors getCompilerOptionDescriptors() {
            return OptionDescriptors.EMPTY;
        }

        @Override
        public boolean isGuestCallStackFrame(StackTraceElement e) {
            String methodName = e.getMethodName();
            return methodName.startsWith("call") && e.getClassName().equals(DefaultCallTarget.class.getName());
        }

        @Override
        public void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        }

        @Override
        public <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
            return new DefaultBlockNode(elements, executor);
        }

        @Override
        public void reloadEngineOptions(Object runtimeData, OptionValues optionValues) {
        }

        @Override
        public void onEngineClosed(Object runtimeData) {
        }

        @Override
        public OutputStream getConfiguredLogStream() {
            return null;
        }

        @Override
        public String getSavedProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public Object callInlined(Node callNode, CallTarget target, Object ... arguments) {
            return ((DefaultCallTarget)target).callDirectOrIndirect(callNode, arguments);
        }

        @Override
        public Object callProfiled(CallTarget target, Object ... arguments) {
            return ((DefaultCallTarget)target).call(arguments);
        }

        @Override
        public Object[] castArrayFixedLength(Object[] args, int length) {
            return args;
        }

        @Override
        public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
            return (T)value;
        }

        @Override
        public void reportPolymorphicSpecialize(Node source) {
        }
    }
}

