/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.dawproject;

import com.bitwig.dawproject.Channel;
import com.bitwig.dawproject.ContentType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeUnit;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import java.util.Collections;
import java.util.Set;

public class Utility {
    private Utility() {
    }

    public static Track createTrack(String name, Set<ContentType> contentTypes, MixerRole mixerRole, double volume, double pan) {
        Track track = new Track();
        track.channel = new Channel();
        track.name = name;
        track.channel.volume = Utility.createRealParameter(Unit.LINEAR, volume);
        track.channel.pan = Utility.createRealParameter(Unit.NORMALIZED, pan);
        track.contentType = contentTypes.toArray(new ContentType[0]);
        track.channel.role = mixerRole;
        return track;
    }

    public static Audio createAudio(String relativePath, int sampleRate, int channels, double duration) {
        Audio audio = new Audio();
        audio.timeUnit = TimeUnit.SECONDS;
        audio.file = new FileReference();
        audio.file.path = relativePath;
        audio.file.external = Boolean.FALSE;
        audio.sampleRate = sampleRate;
        audio.channels = channels;
        audio.duration = duration;
        return audio;
    }

    public static Warp createWarp(double time, double contentTime) {
        Warp warp = new Warp();
        warp.time = time;
        warp.contentTime = contentTime;
        return warp;
    }

    public static Clip createClip(Timeline content, double time, double duration) {
        Clip clip = new Clip();
        clip.content = content;
        clip.time = time;
        clip.duration = duration;
        return clip;
    }

    public static Clips createClips(Clip ... clips) {
        Clips timeline = new Clips();
        Collections.addAll(timeline.clips, clips);
        return timeline;
    }

    public static Marker createMarker(double time, String name) {
        Marker markerEvent = new Marker();
        markerEvent.time = time;
        markerEvent.name = name;
        return markerEvent;
    }

    public static RealPoint createPoint(double time, double value, Interpolation interpolation) {
        RealPoint point = new RealPoint();
        point.time = time;
        point.value = value;
        point.interpolation = interpolation;
        return point;
    }

    public static RealParameter createRealParameter(Unit unit, double value) {
        RealParameter param = new RealParameter();
        param.unit = unit;
        param.value = value;
        return param;
    }

    public static RealParameter createRealParameter(Unit unit, double min, double max, double value) {
        RealParameter param = Utility.createRealParameter(unit, value);
        param.min = min;
        param.max = max;
        return param;
    }
}

