/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.dawproject;

import com.bitwig.dawproject.MetaData;
import com.bitwig.dawproject.Project;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.xml.sax.SAXException;

public class DawProject {
    public static final String FORMAT_NAME = "DAWproject exchange format";
    public static final String FILE_EXTENSION = "dawproject";
    private static final String PROJECT_FILE = "project.xml";
    private static final String METADATA_FILE = "metadata.xml";

    private DawProject() {
    }

    public static void exportSchema(final File file, Class<?> cls) throws IOException {
        try (final FileOutputStream fileOutputStream = new FileOutputStream(file);){
            SchemaOutputResolver resolver = new SchemaOutputResolver(){

                @Override
                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    StreamResult result = new StreamResult(new Writer(){
                        private final PrintWriter pw;
                        {
                            this.pw = new PrintWriter(this, new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8)){

                                @Override
                                public void println() {
                                    this.write(10);
                                }
                            };
                        }

                        @Override
                        public void write(String str) throws IOException {
                            this.pw.write(str);
                        }

                        @Override
                        public void write(int c) throws IOException {
                            this.pw.write(c);
                        }

                        @Override
                        public void write(char[] cbuf, int off, int len) throws IOException {
                            this.pw.write(cbuf, off, len);
                        }

                        @Override
                        public void flush() throws IOException {
                            this.pw.flush();
                        }

                        @Override
                        public void close() throws IOException {
                            this.pw.close();
                        }
                    });
                    result.setSystemId(file.getName());
                    return result;
                }
            };
            DawProject.createContext(cls).generateSchema(resolver);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    public static void saveXML(Project project, File file) throws IOException {
        String projectXML = DawProject.toXML(project);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(projectXML.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void save(Project project, MetaData metadata, Map<File, String> embeddedFiles, File file) throws IOException {
        String metadataXML = DawProject.toXML(metadata);
        String projectXML = DawProject.toXML(project);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            DawProject.addToZip(zos, METADATA_FILE, metadataXML.getBytes(StandardCharsets.UTF_8));
            DawProject.addToZip(zos, PROJECT_FILE, projectXML.getBytes(StandardCharsets.UTF_8));
            for (Map.Entry<File, String> entry : embeddedFiles.entrySet()) {
                DawProject.addToZip(zos, entry.getValue(), entry.getKey());
            }
        }
    }

    public static Project loadProject(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Project project;
            block11: {
                ZipEntry projectEntry = zipFile.getEntry(PROJECT_FILE);
                InputStreamReader reader = DawProject.stripBom(zipFile.getInputStream(projectEntry));
                try {
                    project = DawProject.fromXML(reader, Project.class);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return project;
        }
    }

    public static MetaData loadMetadata(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            MetaData metaData;
            block11: {
                ZipEntry entry = zipFile.getEntry(METADATA_FILE);
                InputStreamReader reader = DawProject.stripBom(zipFile.getInputStream(entry));
                try {
                    metaData = DawProject.fromXML(reader, MetaData.class);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return metaData;
        }
    }

    public static byte[] loadEmbedded(File file, String embeddedPath) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            byte[] byArray;
            block11: {
                ZipEntry entry = zipFile.getEntry(embeddedPath);
                InputStream zipInputStream = zipFile.getInputStream(entry);
                try {
                    byArray = zipInputStream.readAllBytes();
                    if (zipInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                zipInputStream.close();
            }
            return byArray;
        }
    }

    public static void validate(Project project) throws IOException {
        String projectXML = DawProject.toXML(project);
        try {
            JAXBContext context = DawProject.createContext(Project.class);
            File schemaFile = File.createTempFile("schema", ".xml");
            DawProject.exportSchema(schemaFile, Project.class);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(schemaFile);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.unmarshal(new StringReader(projectXML));
        }
        catch (JAXBException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    private static String toXML(Object object) throws IOException {
        try {
            JAXBContext context = DawProject.createContext(object.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            StringWriter sw = new StringWriter();
            marshaller.marshal(object, sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static JAXBContext createContext(Class<?> cls) throws JAXBException {
        return JAXBContext.newInstance(cls);
    }

    private static <T> T fromXML(InputStreamReader reader, Class<T> cls) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(cls);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return cls.cast(unmarshaller.unmarshal(reader));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private static void addToZip(ZipOutputStream zos, String path, byte[] data) throws IOException {
        ZipEntry entry = new ZipEntry(path);
        zos.putNextEntry(entry);
        zos.write(data);
        zos.closeEntry();
    }

    private static void addToZip(ZipOutputStream zos, String path, File file) throws IOException {
        ZipEntry entry = new ZipEntry(path);
        zos.putNextEntry(entry);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] data = new byte[65536];
            int size = 0;
            while ((size = fileInputStream.read(data)) != -1) {
                zos.write(data, 0, size);
            }
            zos.flush();
        }
        zos.closeEntry();
    }

    private static InputStreamReader stripBom(InputStream inputStream) throws IOException {
        Charset charset;
        BOMInputStream bomInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(inputStream)).setByteOrderMarks(ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE).get();
        if (!bomInputStream.hasBOM()) {
            charset = StandardCharsets.UTF_8;
        } else if (bomInputStream.hasBOM(ByteOrderMark.UTF_8)) {
            charset = StandardCharsets.UTF_8;
        } else if (bomInputStream.hasBOM(ByteOrderMark.UTF_16LE)) {
            charset = StandardCharsets.UTF_16LE;
        } else if (bomInputStream.hasBOM(ByteOrderMark.UTF_16BE)) {
            charset = StandardCharsets.UTF_16BE;
        } else {
            throw new IOException("The charset is not supported.");
        }
        return new InputStreamReader((InputStream)bomInputStream, charset);
    }
}

