/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgeauth;

import com.akamai.edgeauth.EdgeAuth;
import com.akamai.edgeauth.EdgeAuthException;

public class EdgeAuthBuilder {
    private String tokenType = null;
    private String tokenName = "__token__";
    private String key = null;
    private String algorithm = "sha256";
    private String salt = null;
    private String ip = null;
    private String payload = null;
    private String sessionId = null;
    private Long startTime = null;
    private Long endTime = null;
    private Long windowSeconds = null;
    private char fieldDelimiter = (char)126;
    private char aclDelimiter = (char)33;
    private boolean escapeEarly = false;
    private boolean verbose = false;

    public EdgeAuthBuilder tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public EdgeAuthBuilder tokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    public EdgeAuthBuilder key(String key) {
        this.key = key;
        return this;
    }

    public EdgeAuthBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public EdgeAuthBuilder salt(String salt) {
        this.salt = salt;
        return this;
    }

    public EdgeAuthBuilder ip(String ip) {
        this.ip = ip;
        return this;
    }

    public EdgeAuthBuilder payload(String payload) {
        this.payload = payload;
        return this;
    }

    public EdgeAuthBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public EdgeAuthBuilder startTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public EdgeAuthBuilder endTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public EdgeAuthBuilder windowSeconds(long windowSeconds) {
        this.windowSeconds = windowSeconds;
        return this;
    }

    public EdgeAuthBuilder fieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
        return this;
    }

    public EdgeAuthBuilder aclDelimiter(char aclDelimiter) {
        this.aclDelimiter = aclDelimiter;
        return this;
    }

    public EdgeAuthBuilder escapeEarly(boolean escapeEarly) {
        this.escapeEarly = escapeEarly;
        return this;
    }

    public EdgeAuthBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public EdgeAuth build() throws EdgeAuthException {
        return new EdgeAuth(this.tokenType, this.tokenName, this.key, this.algorithm, this.salt, this.ip, this.payload, this.sessionId, this.startTime, this.endTime, this.windowSeconds, this.fieldDelimiter, this.aclDelimiter, this.escapeEarly, this.verbose);
    }
}

