/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgeauth;

import com.akamai.edgeauth.EdgeAuthException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class EdgeAuth {
    public static final Long NOW = 0L;
    private String tokenType;
    private String tokenName;
    private String key;
    private String algorithm;
    private String salt;
    private String ip;
    private String payload;
    private String sessionId;
    private Long startTime;
    private Long endTime;
    private Long windowSeconds;
    private char fieldDelimiter;
    private char aclDelimiter;
    private boolean escapeEarly;
    private boolean verbose;

    public EdgeAuth(String tokenType, String tokenName, String key, String algorithm, String salt, String ip, String payload, String sessionId, Long startTime, Long endTime, Long windowSeconds, char fieldDelimiter, char aclDelimiter, boolean escapeEarly, boolean verbose) throws EdgeAuthException {
        this.setTokenType(tokenType);
        this.setTokenName(tokenName);
        this.setKey(key);
        this.setAlgorithm(algorithm);
        this.setSalt(salt);
        this.setIp(ip);
        this.setPayload(payload);
        this.setSessionId(sessionId);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setWindowSeconds(windowSeconds);
        this.setFieldDelimiter(fieldDelimiter);
        this.setAclDelimiter(aclDelimiter);
        this.setEscapeEarly(escapeEarly);
        this.setVerbose(verbose);
    }

    public static String join(char delimiter, String[] lists) throws EdgeAuthException {
        try {
            StringBuilder sb = new StringBuilder();
            for (String list : lists) {
                if (sb.length() > 0) {
                    sb.append(delimiter);
                }
                sb.append(list);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new EdgeAuthException(e.getMessage());
        }
    }

    private String escapeEarly(String text) throws EdgeAuthException {
        if (this.escapeEarly) {
            try {
                StringBuilder newText = new StringBuilder(URLEncoder.encode(text, "UTF-8"));
                Pattern pattern = Pattern.compile("%..");
                Matcher matcher = pattern.matcher(newText);
                while (matcher.find()) {
                    String tmpText = newText.substring(matcher.start(), matcher.end()).toLowerCase();
                    newText.replace(matcher.start(), matcher.end(), tmpText);
                }
                return newText.toString();
            }
            catch (UnsupportedEncodingException e) {
                return text;
            }
            catch (Exception e) {
                throw new EdgeAuthException(e.getMessage());
            }
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateToken(String path, boolean isUrl) throws EdgeAuthException {
        Long startTime = this.startTime;
        Long endTime = this.endTime;
        if (startTime == NOW) {
            startTime = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
        } else if (startTime != null && startTime < 0L) {
            throw new EdgeAuthException("startTime must be ( > 0 )");
        }
        if (endTime == null) {
            if (this.windowSeconds == null || this.windowSeconds <= 0L) throw new EdgeAuthException("You must provide an expiration time or a duration window ( > 0 )");
            endTime = startTime == null ? Long.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L + this.windowSeconds) : Long.valueOf(startTime + this.windowSeconds);
        } else if (endTime <= 0L) {
            throw new EdgeAuthException("endTime must be ( > 0 )");
        }
        if (startTime != null && endTime <= startTime) {
            throw new EdgeAuthException("Token will have already expired.");
        }
        if (this.verbose) {
            System.out.println("Akamai Token Generation Parameters");
            if (isUrl) {
                System.out.println("    URL             : " + path);
            } else {
                System.out.println("    ACL             : " + path);
            }
            System.out.println("    Token Type      : " + this.tokenType);
            System.out.println("    Token Name      : " + this.tokenName);
            System.out.println("    Key/Secret      : " + this.key);
            System.out.println("    Algo            : " + this.algorithm);
            System.out.println("    Salt            : " + this.salt);
            System.out.println("    IP              : " + this.ip);
            System.out.println("    Payload         : " + this.payload);
            System.out.println("    Session ID      : " + this.sessionId);
            System.out.println("    Start Time      : " + this.startTime);
            System.out.println("    Window(seconds) : " + this.windowSeconds);
            System.out.println("    End Time        : " + this.endTime);
            System.out.println("    Field Delimiter : " + this.fieldDelimiter);
            System.out.println("    ACL Delimiter   : " + this.aclDelimiter);
            System.out.println("    Escape Early    : " + this.escapeEarly);
        }
        StringBuilder newToken = new StringBuilder();
        if (this.ip != null) {
            newToken.append("ip=");
            newToken.append(this.escapeEarly(this.ip));
            newToken.append(this.fieldDelimiter);
        }
        if (this.startTime != null) {
            newToken.append("st=");
            newToken.append(startTime.toString());
            newToken.append(this.fieldDelimiter);
        }
        newToken.append("exp=");
        newToken.append(endTime.toString());
        newToken.append(this.fieldDelimiter);
        if (!isUrl) {
            newToken.append("acl=");
            newToken.append(this.escapeEarly(path));
            newToken.append(this.fieldDelimiter);
        }
        if (this.sessionId != null) {
            newToken.append("id=");
            newToken.append(this.escapeEarly(this.sessionId));
            newToken.append(this.fieldDelimiter);
        }
        if (this.payload != null) {
            newToken.append("data=");
            newToken.append(this.escapeEarly(this.payload));
            newToken.append(this.fieldDelimiter);
        }
        StringBuilder hashSource = new StringBuilder(newToken);
        if (isUrl) {
            hashSource.append("url=");
            hashSource.append(this.escapeEarly(path));
            hashSource.append(this.fieldDelimiter);
        }
        if (this.salt != null) {
            hashSource.append("salt=");
            hashSource.append(this.salt);
            hashSource.append(this.fieldDelimiter);
        }
        hashSource.deleteCharAt(hashSource.length() - 1);
        try {
            Mac hmac = Mac.getInstance(this.algorithm);
            byte[] keyBytes = DatatypeConverter.parseHexBinary(this.key);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, this.algorithm);
            hmac.init(secretKey);
            byte[] hmacBytes = hmac.doFinal(hashSource.toString().getBytes());
            return newToken.toString() + "hmac=" + String.format("%0" + 2 * hmac.getMacLength() + "x", new BigInteger(1, hmacBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EdgeAuthException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new EdgeAuthException(e.toString());
        }
    }

    public String generateURLToken(String url) throws EdgeAuthException {
        if (url == null || url == "") {
            throw new EdgeAuthException("You must provide a URL.");
        }
        return this.generateToken(url, true);
    }

    public String generateACLToken(String acl) throws EdgeAuthException {
        if (acl == null || acl == "") {
            throw new EdgeAuthException("You must provide an ACL.");
        }
        return this.generateToken(acl, false);
    }

    public String generateACLToken(String[] acl) throws EdgeAuthException {
        if (acl == null || acl.length == 0) {
            throw new EdgeAuthException("You must provide an ACL.");
        }
        String newAcl = EdgeAuth.join(this.getAclDelimiter(), acl);
        return this.generateToken(newAcl, false);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setTokenName(String tokenName) throws EdgeAuthException {
        if (tokenName == null || tokenName == "") {
            throw new EdgeAuthException("You must provide a token name.");
        }
        this.tokenName = tokenName;
    }

    public void setKey(String key) throws EdgeAuthException {
        if (key == null || key == "") {
            throw new EdgeAuthException("You must provide a secret in order to generate a new token.");
        }
        this.key = key;
    }

    public void setAlgorithm(String algorithm) throws EdgeAuthException {
        if (algorithm.equalsIgnoreCase("sha256")) {
            this.algorithm = "HmacSHA256";
        } else if (algorithm.equalsIgnoreCase("sha1")) {
            this.algorithm = "HmacSHA1";
        } else if (algorithm.equalsIgnoreCase("md5")) {
            this.algorithm = "HmacMD5";
        } else {
            throw new EdgeAuthException("Unknown Algorithm");
        }
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setWindowSeconds(Long windowSeconds) {
        this.windowSeconds = windowSeconds;
    }

    public void setAclDelimiter(char aclDelimiter) {
        this.aclDelimiter = aclDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setEscapeEarly(boolean escapeEarly) {
        this.escapeEarly = escapeEarly;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getwindowSeconds() {
        return this.windowSeconds;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public char getAclDelimiter() {
        return this.aclDelimiter;
    }

    public boolean isEscapeEarly() {
        return this.escapeEarly;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

