/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageMemoryBind;

public class VkSparseImageMemoryBindInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    VkSparseImageMemoryBindInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageMemoryBindInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageMemoryBindInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long image() {
        return VkSparseImageMemoryBindInfo.nimage(this.address());
    }

    public int bindCount() {
        return VkSparseImageMemoryBindInfo.nbindCount(this.address());
    }

    public VkSparseImageMemoryBind.Buffer pBinds() {
        return VkSparseImageMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseImageMemoryBindInfo image(long value) {
        VkSparseImageMemoryBindInfo.nimage(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo pBinds(VkSparseImageMemoryBind.Buffer value) {
        VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(long image, VkSparseImageMemoryBind.Buffer pBinds) {
        this.image(image);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseImageMemoryBindInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(VkSparseImageMemoryBindInfo src) {
        return this.nset(src.address());
    }

    public static VkSparseImageMemoryBindInfo malloc() {
        return VkSparseImageMemoryBindInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo calloc() {
        return VkSparseImageMemoryBindInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo create() {
        return new VkSparseImageMemoryBindInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo create(long address) {
        return address == 0L ? null : new VkSparseImageMemoryBindInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryBindInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryBindInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSparseImageMemoryBindInfo mallocStack() {
        return VkSparseImageMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBindInfo callocStack() {
        return VkSparseImageMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseImageMemoryBind.Buffer npBinds(long struct) {
        return VkSparseImageMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseImageMemoryBindInfo.nbindCount(struct));
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseImageMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseImageMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseImageMemoryBindInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryBindInfo.__struct(VkSparseImageMemoryBindInfo.__member(8), VkSparseImageMemoryBindInfo.__member(4), VkSparseImageMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkSparseImageMemoryBindInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageMemoryBindInfo newInstance(long address) {
            return new VkSparseImageMemoryBindInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long image() {
            return VkSparseImageMemoryBindInfo.nimage(this.address());
        }

        public int bindCount() {
            return VkSparseImageMemoryBindInfo.nbindCount(this.address());
        }

        public VkSparseImageMemoryBind.Buffer pBinds() {
            return VkSparseImageMemoryBindInfo.npBinds(this.address());
        }

        public Buffer image(long value) {
            VkSparseImageMemoryBindInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer pBinds(VkSparseImageMemoryBind.Buffer value) {
            VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

