/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    VkFormatProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkFormatProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFormatProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int linearTilingFeatures() {
        return VkFormatProperties.nlinearTilingFeatures(this.address());
    }

    public int optimalTilingFeatures() {
        return VkFormatProperties.noptimalTilingFeatures(this.address());
    }

    public int bufferFeatures() {
        return VkFormatProperties.nbufferFeatures(this.address());
    }

    public static VkFormatProperties malloc() {
        return VkFormatProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkFormatProperties calloc() {
        return VkFormatProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkFormatProperties create() {
        return new VkFormatProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFormatProperties create(long address) {
        return address == 0L ? null : new VkFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkFormatProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFormatProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkFormatProperties mallocStack() {
        return VkFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties callocStack() {
        return VkFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties mallocStack(MemoryStack stack) {
        return VkFormatProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFormatProperties callocStack(MemoryStack stack) {
        return VkFormatProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlinearTilingFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINEARTILINGFEATURES);
    }

    public static int noptimalTilingFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OPTIMALTILINGFEATURES);
    }

    public static int nbufferFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERFEATURES);
    }

    static {
        Struct.Layout layout = VkFormatProperties.__struct(VkFormatProperties.__member(4), VkFormatProperties.__member(4), VkFormatProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LINEARTILINGFEATURES = layout.offsetof(0);
        OPTIMALTILINGFEATURES = layout.offsetof(1);
        BUFFERFEATURES = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkFormatProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFormatProperties newInstance(long address) {
            return new VkFormatProperties(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int linearTilingFeatures() {
            return VkFormatProperties.nlinearTilingFeatures(this.address());
        }

        public int optimalTilingFeatures() {
            return VkFormatProperties.noptimalTilingFeatures(this.address());
        }

        public int bufferFeatures() {
            return VkFormatProperties.nbufferFeatures(this.address());
        }
    }
}

