/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent3D
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    VkExtent3D(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExtent3D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExtent3D.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return VkExtent3D.nwidth(this.address());
    }

    public int height() {
        return VkExtent3D.nheight(this.address());
    }

    public int depth() {
        return VkExtent3D.ndepth(this.address());
    }

    public VkExtent3D width(int value) {
        VkExtent3D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent3D height(int value) {
        VkExtent3D.nheight(this.address(), value);
        return this;
    }

    public VkExtent3D depth(int value) {
        VkExtent3D.ndepth(this.address(), value);
        return this;
    }

    public VkExtent3D set(int width, int height, int depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public VkExtent3D nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkExtent3D set(VkExtent3D src) {
        return this.nset(src.address());
    }

    public static VkExtent3D malloc() {
        return VkExtent3D.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExtent3D calloc() {
        return VkExtent3D.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExtent3D create() {
        return new VkExtent3D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExtent3D create(long address) {
        return address == 0L ? null : new VkExtent3D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExtent3D.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExtent3D.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExtent3D mallocStack() {
        return VkExtent3D.mallocStack(MemoryStack.stackGet());
    }

    public static VkExtent3D callocStack() {
        return VkExtent3D.callocStack(MemoryStack.stackGet());
    }

    public static VkExtent3D mallocStack(MemoryStack stack) {
        return VkExtent3D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtent3D callocStack(MemoryStack stack) {
        return VkExtent3D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExtent3D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExtent3D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = VkExtent3D.__struct(VkExtent3D.__member(4), VkExtent3D.__member(4), VkExtent3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkExtent3D, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExtent3D newInstance(long address) {
            return new VkExtent3D(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int width() {
            return VkExtent3D.nwidth(this.address());
        }

        public int height() {
            return VkExtent3D.nheight(this.address());
        }

        public int depth() {
            return VkExtent3D.ndepth(this.address());
        }

        public Buffer width(int value) {
            VkExtent3D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            VkExtent3D.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(int value) {
            VkExtent3D.ndepth(this.address(), value);
            return this;
        }
    }
}

