/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectTagInfoEXT
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int TAGNAME;
    public static final int TAGSIZE;
    public static final int PTAG;

    VkDebugMarkerObjectTagInfoEXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDebugMarkerObjectTagInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugMarkerObjectTagInfoEXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
    }

    public long pNext() {
        return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
    }

    public int objectType() {
        return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
    }

    public long object() {
        return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
    }

    public long tagName() {
        return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
    }

    public long tagSize() {
        return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
    }

    public ByteBuffer pTag() {
        return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
    }

    public VkDebugMarkerObjectTagInfoEXT sType(int value) {
        VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT pNext(long value) {
        VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT objectType(int value) {
        VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT object(long value) {
        VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT tagName(long value) {
        VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT pTag(ByteBuffer value) {
        VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(int sType, long pNext, int objectType, long object, long tagName, ByteBuffer pTag) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.tagName(tagName);
        this.pTag(pTag);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(VkDebugMarkerObjectTagInfoEXT src) {
        return this.nset(src.address());
    }

    public static VkDebugMarkerObjectTagInfoEXT malloc() {
        return VkDebugMarkerObjectTagInfoEXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT calloc() {
        return VkDebugMarkerObjectTagInfoEXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT create() {
        return new VkDebugMarkerObjectTagInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT create(long address) {
        return address == 0L ? null : new VkDebugMarkerObjectTagInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDebugMarkerObjectTagInfoEXT mallocStack() {
        return VkDebugMarkerObjectTagInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerObjectTagInfoEXT callocStack() {
        return VkDebugMarkerObjectTagInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerObjectTagInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nobjectType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OBJECT);
    }

    public static long ntagName(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TAGNAME);
    }

    public static long ntagSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TAGSIZE);
    }

    public static ByteBuffer npTag(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PTAG), (int)VkDebugMarkerObjectTagInfoEXT.ntagSize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OBJECT, value);
    }

    public static void ntagName(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TAGNAME, value);
    }

    public static void ntagSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TAGSIZE, value);
    }

    public static void npTag(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTAG, MemoryUtil.memAddress(value));
        VkDebugMarkerObjectTagInfoEXT.ntagSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PTAG));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugMarkerObjectTagInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectTagInfoEXT.__struct(VkDebugMarkerObjectTagInfoEXT.__member(4), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member(4), VkDebugMarkerObjectTagInfoEXT.__member(8), VkDebugMarkerObjectTagInfoEXT.__member(8), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        TAGNAME = layout.offsetof(4);
        TAGSIZE = layout.offsetof(5);
        PTAG = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<VkDebugMarkerObjectTagInfoEXT, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugMarkerObjectTagInfoEXT newInstance(long address) {
            return new VkDebugMarkerObjectTagInfoEXT(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
        }

        public long pNext() {
            return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
        }

        public int objectType() {
            return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
        }

        public long object() {
            return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
        }

        public long tagName() {
            return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
        }

        public long tagSize() {
            return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
        }

        public ByteBuffer pTag() {
            return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
        }

        public Buffer sType(int value) {
            VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(int value) {
            VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(long value) {
            VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer tagName(long value) {
            VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
            return this;
        }

        public Buffer pTag(ByteBuffer value) {
            VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
            return this;
        }
    }
}

