/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerMarkerInfoEXT
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PMARKERNAME;
    public static final int COLOR;

    VkDebugMarkerMarkerInfoEXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDebugMarkerMarkerInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugMarkerMarkerInfoEXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
    }

    public long pNext() {
        return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
    }

    public ByteBuffer pMarkerName() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
    }

    public String pMarkerNameString() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
    }

    public FloatBuffer color() {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
    }

    public float color(int index) {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
    }

    public VkDebugMarkerMarkerInfoEXT sType(int value) {
        VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT pNext(long value) {
        VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT pMarkerName(ByteBuffer value) {
        VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(FloatBuffer value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(int index, float value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(int sType, long pNext, ByteBuffer pMarkerName, FloatBuffer color) {
        this.sType(sType);
        this.pNext(pNext);
        this.pMarkerName(pMarkerName);
        this.color(color);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(VkDebugMarkerMarkerInfoEXT src) {
        return this.nset(src.address());
    }

    public static VkDebugMarkerMarkerInfoEXT malloc() {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT calloc() {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT create() {
        return new VkDebugMarkerMarkerInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT create(long address) {
        return address == 0L ? null : new VkDebugMarkerMarkerInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDebugMarkerMarkerInfoEXT mallocStack() {
        return VkDebugMarkerMarkerInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerMarkerInfoEXT callocStack() {
        return VkDebugMarkerMarkerInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerMarkerInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npMarkerName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static String npMarkerNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static FloatBuffer ncolor(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)COLOR, 4);
    }

    public static float ncolor(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR + (long)(index * 4));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npMarkerName(long struct, ByteBuffer value) {
        if (Checks.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PMARKERNAME, MemoryUtil.memAddress(value));
    }

    public static void ncolor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLOR, value.remaining() * 4);
    }

    public static void ncolor(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR + (long)(index * 4), value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugMarkerMarkerInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugMarkerMarkerInfoEXT.__struct(VkDebugMarkerMarkerInfoEXT.__member(4), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PMARKERNAME = layout.offsetof(2);
        COLOR = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<VkDebugMarkerMarkerInfoEXT, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugMarkerMarkerInfoEXT newInstance(long address) {
            return new VkDebugMarkerMarkerInfoEXT(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
        }

        public long pNext() {
            return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
        }

        public ByteBuffer pMarkerName() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
        }

        public String pMarkerNameString() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
        }

        public FloatBuffer color() {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
        }

        public float color(int index) {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
        }

        public Buffer sType(int value) {
            VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pMarkerName(ByteBuffer value) {
            VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
            return this;
        }

        public Buffer color(FloatBuffer value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(int index, float value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
            return this;
        }
    }
}

