/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.POINTFLOAT;

public class GLYPHMETRICSFLOAT
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GMFBLACKBOXX;
    public static final int GMFBLACKBOXY;
    public static final int GMFPTGLYPHORIGIN;
    public static final int GMFCELLINCX;
    public static final int GMFCELLINCY;

    GLYPHMETRICSFLOAT(long address, ByteBuffer container) {
        super(address, container);
    }

    public GLYPHMETRICSFLOAT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), GLYPHMETRICSFLOAT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float gmfBlackBoxX() {
        return GLYPHMETRICSFLOAT.ngmfBlackBoxX(this.address());
    }

    public float gmfBlackBoxY() {
        return GLYPHMETRICSFLOAT.ngmfBlackBoxY(this.address());
    }

    public POINTFLOAT gmfptGlyphOrigin() {
        return GLYPHMETRICSFLOAT.ngmfptGlyphOrigin(this.address());
    }

    public float gmfCellIncX() {
        return GLYPHMETRICSFLOAT.ngmfCellIncX(this.address());
    }

    public float gmfCellIncY() {
        return GLYPHMETRICSFLOAT.ngmfCellIncY(this.address());
    }

    public static GLYPHMETRICSFLOAT malloc() {
        return GLYPHMETRICSFLOAT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static GLYPHMETRICSFLOAT calloc() {
        return GLYPHMETRICSFLOAT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static GLYPHMETRICSFLOAT create() {
        return new GLYPHMETRICSFLOAT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static GLYPHMETRICSFLOAT create(long address) {
        return address == 0L ? null : new GLYPHMETRICSFLOAT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return GLYPHMETRICSFLOAT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return GLYPHMETRICSFLOAT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static GLYPHMETRICSFLOAT mallocStack() {
        return GLYPHMETRICSFLOAT.mallocStack(MemoryStack.stackGet());
    }

    public static GLYPHMETRICSFLOAT callocStack() {
        return GLYPHMETRICSFLOAT.callocStack(MemoryStack.stackGet());
    }

    public static GLYPHMETRICSFLOAT mallocStack(MemoryStack stack) {
        return GLYPHMETRICSFLOAT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GLYPHMETRICSFLOAT callocStack(MemoryStack stack) {
        return GLYPHMETRICSFLOAT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GLYPHMETRICSFLOAT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GLYPHMETRICSFLOAT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return GLYPHMETRICSFLOAT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return GLYPHMETRICSFLOAT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float ngmfBlackBoxX(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GMFBLACKBOXX);
    }

    public static float ngmfBlackBoxY(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GMFBLACKBOXY);
    }

    public static POINTFLOAT ngmfptGlyphOrigin(long struct) {
        return POINTFLOAT.create(struct + (long)GMFPTGLYPHORIGIN);
    }

    public static float ngmfCellIncX(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GMFCELLINCX);
    }

    public static float ngmfCellIncY(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GMFCELLINCY);
    }

    static {
        Struct.Layout layout = GLYPHMETRICSFLOAT.__struct(GLYPHMETRICSFLOAT.__member(4), GLYPHMETRICSFLOAT.__member(4), GLYPHMETRICSFLOAT.__member(POINTFLOAT.SIZEOF, POINTFLOAT.ALIGNOF), GLYPHMETRICSFLOAT.__member(4), GLYPHMETRICSFLOAT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GMFBLACKBOXX = layout.offsetof(0);
        GMFBLACKBOXY = layout.offsetof(1);
        GMFPTGLYPHORIGIN = layout.offsetof(2);
        GMFCELLINCX = layout.offsetof(3);
        GMFCELLINCY = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<GLYPHMETRICSFLOAT, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected GLYPHMETRICSFLOAT newInstance(long address) {
            return new GLYPHMETRICSFLOAT(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float gmfBlackBoxX() {
            return GLYPHMETRICSFLOAT.ngmfBlackBoxX(this.address());
        }

        public float gmfBlackBoxY() {
            return GLYPHMETRICSFLOAT.ngmfBlackBoxY(this.address());
        }

        public POINTFLOAT gmfptGlyphOrigin() {
            return GLYPHMETRICSFLOAT.ngmfptGlyphOrigin(this.address());
        }

        public float gmfCellIncX() {
            return GLYPHMETRICSFLOAT.ngmfCellIncX(this.address());
        }

        public float gmfCellIncY() {
            return GLYPHMETRICSFLOAT.ngmfCellIncY(this.address());
        }
    }
}

