/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.jemalloc.ChunkAlloc;
import org.lwjgl.system.jemalloc.ChunkAllocI;
import org.lwjgl.system.jemalloc.ChunkCommit;
import org.lwjgl.system.jemalloc.ChunkCommitI;
import org.lwjgl.system.jemalloc.ChunkDalloc;
import org.lwjgl.system.jemalloc.ChunkDallocI;
import org.lwjgl.system.jemalloc.ChunkDecommit;
import org.lwjgl.system.jemalloc.ChunkDecommitI;
import org.lwjgl.system.jemalloc.ChunkMerge;
import org.lwjgl.system.jemalloc.ChunkMergeI;
import org.lwjgl.system.jemalloc.ChunkPurge;
import org.lwjgl.system.jemalloc.ChunkPurgeI;
import org.lwjgl.system.jemalloc.ChunkSplit;
import org.lwjgl.system.jemalloc.ChunkSplitI;

public class ChunkHooks
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC;
    public static final int DALLOC;
    public static final int COMMIT;
    public static final int DECOMMIT;
    public static final int PURGE;
    public static final int SPLIT;
    public static final int MERGE;

    ChunkHooks(long address, ByteBuffer container) {
        super(address, container);
    }

    public ChunkHooks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ChunkHooks.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ChunkAlloc alloc() {
        return ChunkAlloc.create(ChunkHooks.nalloc(this.address()));
    }

    public ChunkDalloc dalloc() {
        return ChunkDalloc.create(ChunkHooks.ndalloc(this.address()));
    }

    public ChunkCommit commit() {
        return ChunkCommit.create(ChunkHooks.ncommit(this.address()));
    }

    public ChunkDecommit decommit() {
        return ChunkDecommit.create(ChunkHooks.ndecommit(this.address()));
    }

    public ChunkPurge purge() {
        return ChunkPurge.create(ChunkHooks.npurge(this.address()));
    }

    public ChunkSplit split() {
        return ChunkSplit.create(ChunkHooks.nsplit(this.address()));
    }

    public ChunkMerge merge() {
        return ChunkMerge.create(ChunkHooks.nmerge(this.address()));
    }

    public ChunkHooks alloc(ChunkAllocI value) {
        ChunkHooks.nalloc(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks dalloc(ChunkDallocI value) {
        ChunkHooks.ndalloc(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks commit(ChunkCommitI value) {
        ChunkHooks.ncommit(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks decommit(ChunkDecommitI value) {
        ChunkHooks.ndecommit(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks purge(ChunkPurgeI value) {
        ChunkHooks.npurge(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks split(ChunkSplitI value) {
        ChunkHooks.nsplit(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks merge(ChunkMergeI value) {
        ChunkHooks.nmerge(this.address(), ChunkHooks.addressSafe(value));
        return this;
    }

    public ChunkHooks set(ChunkAllocI alloc, ChunkDallocI dalloc, ChunkCommitI commit, ChunkDecommitI decommit, ChunkPurgeI purge, ChunkSplitI split, ChunkMergeI merge) {
        this.alloc(alloc);
        this.dalloc(dalloc);
        this.commit(commit);
        this.decommit(decommit);
        this.purge(purge);
        this.split(split);
        this.merge(merge);
        return this;
    }

    public ChunkHooks nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public ChunkHooks set(ChunkHooks src) {
        return this.nset(src.address());
    }

    public static ChunkHooks malloc() {
        return ChunkHooks.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ChunkHooks calloc() {
        return ChunkHooks.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ChunkHooks create() {
        return new ChunkHooks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ChunkHooks create(long address) {
        return address == 0L ? null : new ChunkHooks(address, null);
    }

    public static Buffer malloc(int capacity) {
        return ChunkHooks.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ChunkHooks.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static ChunkHooks mallocStack() {
        return ChunkHooks.mallocStack(MemoryStack.stackGet());
    }

    public static ChunkHooks callocStack() {
        return ChunkHooks.callocStack(MemoryStack.stackGet());
    }

    public static ChunkHooks mallocStack(MemoryStack stack) {
        return ChunkHooks.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ChunkHooks callocStack(MemoryStack stack) {
        return ChunkHooks.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ChunkHooks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ChunkHooks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ChunkHooks.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ChunkHooks.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nalloc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOC);
    }

    public static long ndalloc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DALLOC);
    }

    public static long ncommit(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COMMIT);
    }

    public static long ndecommit(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DECOMMIT);
    }

    public static long npurge(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PURGE);
    }

    public static long nsplit(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPLIT);
    }

    public static long nmerge(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MERGE);
    }

    public static void nalloc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ALLOC, Checks.checkPointer(value));
    }

    public static void ndalloc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DALLOC, Checks.checkPointer(value));
    }

    public static void ncommit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)COMMIT, Checks.checkPointer(value));
    }

    public static void ndecommit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DECOMMIT, Checks.checkPointer(value));
    }

    public static void npurge(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PURGE, Checks.checkPointer(value));
    }

    public static void nsplit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SPLIT, Checks.checkPointer(value));
    }

    public static void nmerge(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MERGE, Checks.checkPointer(value));
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)ALLOC));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)DALLOC));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)COMMIT));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)DECOMMIT));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PURGE));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)SPLIT));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)MERGE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ChunkHooks.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = ChunkHooks.__struct(ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE), ChunkHooks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOC = layout.offsetof(0);
        DALLOC = layout.offsetof(1);
        COMMIT = layout.offsetof(2);
        DECOMMIT = layout.offsetof(3);
        PURGE = layout.offsetof(4);
        SPLIT = layout.offsetof(5);
        MERGE = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<ChunkHooks, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ChunkHooks newInstance(long address) {
            return new ChunkHooks(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ChunkAlloc alloc() {
            return ChunkAlloc.create(ChunkHooks.nalloc(this.address()));
        }

        public ChunkDalloc dalloc() {
            return ChunkDalloc.create(ChunkHooks.ndalloc(this.address()));
        }

        public ChunkCommit commit() {
            return ChunkCommit.create(ChunkHooks.ncommit(this.address()));
        }

        public ChunkDecommit decommit() {
            return ChunkDecommit.create(ChunkHooks.ndecommit(this.address()));
        }

        public ChunkPurge purge() {
            return ChunkPurge.create(ChunkHooks.npurge(this.address()));
        }

        public ChunkSplit split() {
            return ChunkSplit.create(ChunkHooks.nsplit(this.address()));
        }

        public ChunkMerge merge() {
            return ChunkMerge.create(ChunkHooks.nmerge(this.address()));
        }

        public Buffer alloc(ChunkAllocI value) {
            ChunkHooks.nalloc(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer dalloc(ChunkDallocI value) {
            ChunkHooks.ndalloc(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer commit(ChunkCommitI value) {
            ChunkHooks.ncommit(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer decommit(ChunkDecommitI value) {
            ChunkHooks.ndecommit(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer purge(ChunkPurgeI value) {
            ChunkHooks.npurge(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer split(ChunkSplitI value) {
            ChunkHooks.nsplit(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }

        public Buffer merge(ChunkMergeI value) {
            ChunkHooks.nmerge(this.address(), ChunkHooks.addressSafe(value));
            return this;
        }
    }
}

