/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JAWTRectangle
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;

    JAWTRectangle(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWTRectangle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWTRectangle.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return JAWTRectangle.nx(this.address());
    }

    public int y() {
        return JAWTRectangle.ny(this.address());
    }

    public int width() {
        return JAWTRectangle.nwidth(this.address());
    }

    public int height() {
        return JAWTRectangle.nheight(this.address());
    }

    public JAWTRectangle x(int value) {
        JAWTRectangle.nx(this.address(), value);
        return this;
    }

    public JAWTRectangle y(int value) {
        JAWTRectangle.ny(this.address(), value);
        return this;
    }

    public JAWTRectangle width(int value) {
        JAWTRectangle.nwidth(this.address(), value);
        return this;
    }

    public JAWTRectangle height(int value) {
        JAWTRectangle.nheight(this.address(), value);
        return this;
    }

    public JAWTRectangle set(int x, int y, int width, int height) {
        this.x(x);
        this.y(y);
        this.width(width);
        this.height(height);
        return this;
    }

    public JAWTRectangle nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public JAWTRectangle set(JAWTRectangle src) {
        return this.nset(src.address());
    }

    public static JAWTRectangle malloc() {
        return JAWTRectangle.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static JAWTRectangle calloc() {
        return JAWTRectangle.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static JAWTRectangle create() {
        return new JAWTRectangle(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static JAWTRectangle create(long address) {
        return address == 0L ? null : new JAWTRectangle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return JAWTRectangle.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return JAWTRectangle.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static JAWTRectangle mallocStack() {
        return JAWTRectangle.mallocStack(MemoryStack.stackGet());
    }

    public static JAWTRectangle callocStack() {
        return JAWTRectangle.callocStack(MemoryStack.stackGet());
    }

    public static JAWTRectangle mallocStack(MemoryStack stack) {
        return JAWTRectangle.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JAWTRectangle callocStack(MemoryStack stack) {
        return JAWTRectangle.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return JAWTRectangle.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return JAWTRectangle.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JAWTRectangle.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JAWTRectangle.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = JAWTRectangle.__struct(JAWTRectangle.__member(4), JAWTRectangle.__member(4), JAWTRectangle.__member(4), JAWTRectangle.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<JAWTRectangle, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWTRectangle newInstance(long address) {
            return new JAWTRectangle(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return JAWTRectangle.nx(this.address());
        }

        public int y() {
            return JAWTRectangle.ny(this.address());
        }

        public int width() {
            return JAWTRectangle.nwidth(this.address());
        }

        public int height() {
            return JAWTRectangle.nheight(this.address());
        }

        public Buffer x(int value) {
            JAWTRectangle.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            JAWTRectangle.ny(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            JAWTRectangle.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            JAWTRectangle.nheight(this.address(), value);
            return this;
        }
    }
}

