/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = Configuration.LIBRARY_NAME.get(System.getProperty("os.arch").contains("64") ? "lwjgl" : "lwjgl32");
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(File.pathSeparator);

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String name) throws UnsatisfiedLinkError {
        APIUtil.apiLog("Loading library (system): " + name);
        if (new File(name).isAbsolute()) {
            System.load(name);
            APIUtil.apiLog("\tSuccess");
            return;
        }
        try {
            Library.loadSystemRelative(name);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                SharedLibraryLoader.load(name);
                Library.loadSystemRelative(name);
            }
            catch (Throwable t) {
                Library.printError(t);
                throw e;
            }
        }
    }

    private static void loadSystemRelative(String name) {
        String libName = Platform.get().mapLibraryName(name);
        String override = Configuration.LIBRARY_PATH.get();
        if (override != null && Library.loadSystem(libName, Configuration.LIBRARY_PATH.getProperty(), override)) {
            return;
        }
        override = System.getProperty(JAVA_LIBRARY_PATH);
        if (override != null && Library.loadSystem(libName, JAVA_LIBRARY_PATH, override)) {
            return;
        }
        throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
    }

    private static boolean loadSystem(String libName, String property, String paths) {
        File libFile = Library.findLibrary(paths, libName).orElse(null);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return false;
        }
        System.load(libFile.getAbsolutePath());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile.getPath()));
        return true;
    }

    public static SharedLibrary loadNative(String name) {
        APIUtil.apiLog("Loading library: " + name);
        if (new File(name).isAbsolute()) {
            SharedLibrary lib = APIUtil.apiCreateLibrary(name);
            APIUtil.apiLog("\tSuccess");
            return lib;
        }
        try {
            return Library.loadNativeRelative(name);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                SharedLibraryLoader.load(name);
                return Library.loadNativeRelative(name);
            }
            catch (Throwable t) {
                Library.printError(t);
                throw e;
            }
        }
    }

    private static SharedLibrary loadNativeRelative(String name) {
        SharedLibrary lib;
        String libName = Platform.get().mapLibraryName(name);
        String override = Configuration.LIBRARY_PATH.get();
        if (override != null && (lib = Library.loadNative(libName, Configuration.LIBRARY_PATH.getProperty(), override)) != null) {
            return lib;
        }
        override = System.getProperty(JAVA_LIBRARY_PATH);
        if (override != null && (lib = Library.loadNative(libName, JAVA_LIBRARY_PATH, override)) != null) {
            return lib;
        }
        try {
            lib = APIUtil.apiCreateLibrary(libName);
            APIUtil.apiLog("\tLoaded from system paths");
            return lib;
        }
        catch (UnsatisfiedLinkError e) {
            APIUtil.apiLog(String.format("\t%s not found in system paths", libName));
            throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
        }
    }

    private static SharedLibrary loadNative(String libName, String property, String paths) {
        File libFile = Library.findLibrary(paths, libName).orElse(null);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return null;
        }
        SharedLibrary lib = APIUtil.apiCreateLibrary(libFile.getPath());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile.getPath()));
        return lib;
    }

    public static SharedLibrary loadNative(Configuration<String> name, String ... defaultNames) {
        SharedLibrary library;
        block8: {
            if (name.get() != null) {
                return Library.loadNative(name.get());
            }
            if (defaultNames.length <= 1) {
                if (defaultNames.length == 0) {
                    throw new RuntimeException("No default names specified.");
                }
                return Library.loadNative(defaultNames[0]);
            }
            library = null;
            try {
                library = Library.loadNative(defaultNames[0]);
            }
            catch (Throwable t) {
                for (int i = 1; i < defaultNames.length; ++i) {
                    try {
                        library = Library.loadNative(defaultNames[i]);
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (library != null) break block8;
                throw t;
            }
        }
        return library;
    }

    private static Optional<File> findLibrary(String path, String libName) {
        return PATH_SEPARATOR.splitAsStream(path).map(it -> new File(it + File.separator + libName)).filter(File::isFile).findFirst();
    }

    private static void printError(Throwable t) {
        if (Checks.DEBUG) {
            t.printStackTrace(APIUtil.DEBUG_STREAM);
        }
        APIUtil.DEBUG_STREAM.println("[LWJGL] Failed to load a library. Possible solutions:\n\ta) Set -Djava.library.path or -Dorg.lwjgl.librarypath to the directory that contains the shared libraries.\n\tb) Add the JAR(s) containing the shared libraries to the classpath.");
        if (!Checks.DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] Enable debug mode with -Dorg.lwjgl.util.Debug=true for better diagnostics.");
        }
    }

    private static void checkHash() {
        String libName = Platform.get().mapLibraryName(JNI_LIBRARY_NAME);
        String expected = APIUtil.apiGetManifestValue(libName.replace('.', '-')).orElse(null);
        if (expected == null) {
            return;
        }
        File libFile = null;
        String override = Configuration.LIBRARY_PATH.get();
        if (override != null) {
            libFile = Library.findLibrary(override, libName).orElse(null);
        }
        if (libFile == null) {
            libFile = Library.findLibrary(System.getProperty(JAVA_LIBRARY_PATH), libName).orElse(null);
        }
        if (libFile == null && !(libFile = new File("./" + libName)).isFile()) {
            return;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            try (DigestInputStream dis = new DigestInputStream(new FileInputStream(libFile), sha1);){
                byte[] buffer = new byte[8192];
                while (dis.read(buffer) != -1) {
                }
            }
            byte[] digest = sha1.digest();
            StringBuilder actual = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                int b = digest[i] & 0xFF;
                if (b < 16) {
                    actual.append('0');
                }
                actual.append(Integer.toHexString(b));
            }
            if (!expected.contentEquals(actual)) {
                APIUtil.DEBUG_STREAM.println("[LWJGL] [WARNING] Mismatch detected between the Java and native LWJGL libraries." + (Checks.DEBUG ? "" : "\n\tLaunch the JVM with -Dorg.lwjgl.util.Debug=true for more information."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.apiLog("Version: " + Version.getVersion());
            APIUtil.apiLog("\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
            APIUtil.apiLog("\tJRE: " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
            APIUtil.apiLog("\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        }
        Library.loadSystem(JNI_LIBRARY_NAME);
        Library.checkHash();
    }
}

