/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.StructBuffer;

public final class Checks {
    public static final boolean CHECKS = Configuration.DISABLE_CHECKS.get(false) == false;
    public static final boolean DEBUG = Configuration.DEBUG.get(false);
    public static final boolean DEBUG_FUNCTIONS = Configuration.DEBUG_FUNCTIONS.get(false);

    private Checks() {
    }

    public static boolean checkFunctions(long ... functions) {
        for (long pointer : functions) {
            if (pointer != 0L) continue;
            return false;
        }
        return true;
    }

    public static long checkFunctionAddress(long pointer) {
        if (pointer == 0L) {
            throw new IllegalStateException("This function is not available.");
        }
        return pointer;
    }

    public static long checkPointer(long pointer) {
        if (pointer == 0L) {
            throw new NullPointerException();
        }
        return pointer;
    }

    public static ByteBuffer checkNT1(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT2(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 2);
        if (buf.getShort(buf.limit() - 2) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT4(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 4);
        if (buf.getInt(buf.limit() - 4) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT4(ByteBuffer buf, int terminator) {
        Checks.checkBuffer((Buffer)buf, 4);
        if (buf.getInt(buf.limit() - 4) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT8(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 8);
        if (buf.getLong(buf.limit() - 8) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNTP(ByteBuffer buf) {
        return Checks.checkNTP(buf, 0L);
    }

    public static ByteBuffer checkNTP(ByteBuffer buf, long terminator) {
        Checks.checkBuffer((Buffer)buf, Pointer.POINTER_SIZE);
        if (PointerBuffer.get(buf, buf.limit() - Pointer.POINTER_SIZE) != terminator) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static IntBuffer checkNT(IntBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static int[] checkNT(int[] buf) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static IntBuffer checkNT(IntBuffer buf, int terminator) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
        return buf;
    }

    public static int[] checkNT(int[] buf, int terminator) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
        return buf;
    }

    public static LongBuffer checkNT(LongBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static long[] checkNT(long[] buf) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static FloatBuffer checkNT(FloatBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0.0f) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static float[] checkNT(float[] buf) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != 0.0f) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static PointerBuffer checkNT(PointerBuffer buf) {
        Checks.checkBuffer(buf, 1);
        if (buf.get(buf.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static PointerBuffer checkNT(PointerBuffer buf, long terminator) {
        Checks.checkBuffer(buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
        return buf;
    }

    public static void checkBuffer(short[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(int[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(long[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(float[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(double[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(CharSequence text, int size) {
        if (text.length() < size) {
            Checks.throwSizeException(text, size);
        }
    }

    public static void checkBuffer(Buffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(Buffer buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkBuffer(PointerBuffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(PointerBuffer buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkBuffer(StructBuffer<?, ?> buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(StructBuffer<?, ?> buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkArray(Object[] array, int size) {
        if (array.length < size) {
            Checks.throwSizeException(array, size);
        }
    }

    public static void checkBufferGT(Buffer buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    public static void checkBufferGT(PointerBuffer buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    public static void checkBufferGT(StructBuffer<?, ?> buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    private static void throwSizeException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwSizeException(PointerBuffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining pointer values in buffer is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwSizeException(StructBuffer<?, ?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining struct values in buffer is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwSizeException(Object[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(short[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(int[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(long[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(float[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(double[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(CharSequence text, int size) {
        throw new IllegalArgumentException("Number of characters is " + text.length() + ", must be at least " + size);
    }

    private static void throwBufferSizeGTException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    private static void throwBufferSizeGTException(PointerBuffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    private static void throwBufferSizeGTException(StructBuffer<?, ?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    static {
        if (DEBUG_FUNCTIONS && !DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] The DEBUG_FUNCTIONS option requires DEBUG to produce output.");
        }
    }
}

