/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBImage {
    public static final int STBI_default = 0;
    public static final int STBI_grey = 1;
    public static final int STBI_grey_alpha = 2;
    public static final int STBI_rgb = 3;
    public static final int STBI_rgb_alpha = 4;

    protected STBImage() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbi_load(long var0, long var2, long var4, long var6, int var8);

    public static ByteBuffer stbi_load(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_load(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load(MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), user, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_loadf(long var0, long var2, long var4, long var6, int var8);

    public static FloatBuffer stbi_loadf(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer stbi_loadf(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
            FloatBuffer floatBuffer = MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), user, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native void stbi_hdr_to_ldr_gamma(float var0);

    public static native void stbi_hdr_to_ldr_scale(float var0);

    public static native void stbi_ldr_to_hdr_gamma(float var0);

    public static native void stbi_ldr_to_hdr_scale(float var0);

    public static native int nstbi_is_hdr(long var0);

    public static int stbi_is_hdr(ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return STBImage.nstbi_is_hdr(MemoryUtil.memAddress(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_is_hdr(CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImage.nstbi_is_hdr(MemoryUtil.memAddress(filenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_is_hdr_from_memory(long var0, int var2);

    public static int stbi_is_hdr_from_memory(ByteBuffer buffer) {
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining());
    }

    public static native int nstbi_is_hdr_from_callbacks(long var0, long var2);

    public static int stbi_is_hdr_from_callbacks(STBIIOCallbacks clbk, long user) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_is_hdr_from_callbacks(clbk.address(), user);
    }

    public static native long nstbi_failure_reason();

    public static String stbi_failure_reason() {
        long __result = STBImage.nstbi_failure_reason();
        return MemoryUtil.memASCII(__result);
    }

    public static native void nstbi_image_free(long var0);

    public static void stbi_image_free(ByteBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(retval_from_stbi_load));
    }

    public static void stbi_image_free(FloatBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(retval_from_stbi_load));
    }

    public static native int nstbi_info(long var0, long var2, long var4, long var6);

    public static int stbi_info(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_info(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImage.nstbi_info(MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, long var3, long var5, long var7);

    public static int stbi_info_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, long var4, long var6, long var8);

    public static int stbi_info_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static native void stbi_set_unpremultiply_on_load(int var0);

    public static native void stbi_convert_iphone_png_to_rgb(int var0);

    public static native void stbi_set_flip_vertically_on_load(int var0);

    public static native long nstbi_zlib_decode_malloc_guesssize(long var0, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(ByteBuffer buffer, int initial_size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress(buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress(outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc_guesssize_headerflag(long var0, int var2, int var3, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(ByteBuffer buffer, int initial_size, int parse_header) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress(buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress(outlen), parse_header);
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc(ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress(obuffer), obuffer.remaining(), MemoryUtil.memAddress(ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_zlib_decode_noheader_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_noheader_malloc(ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(__result, outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_noheader_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_noheader_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress(obuffer), obuffer.remaining(), MemoryUtil.memAddress(ibuffer), ibuffer.remaining());
    }

    public static native void nstbi_image_free(float[] var0);

    public static void stbi_image_free(float[] retval_from_stbi_load) {
        STBImage.nstbi_image_free(retval_from_stbi_load);
    }

    public static native int nstbi_info(long var0, int[] var2, int[] var3, int[] var4);

    public static int stbi_info(ByteBuffer filename, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer(x, 1);
            Checks.checkBuffer(y, 1);
            Checks.checkBuffer(comp, 1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(filename), x, y, comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_info(CharSequence filename, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(x, 1);
            Checks.checkBuffer(y, 1);
            Checks.checkBuffer(comp, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImage.nstbi_info(MemoryUtil.memAddress(filenameEncoded), x, y, comp);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5);

    public static int stbi_info_from_memory(ByteBuffer buffer, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(x, 1);
            Checks.checkBuffer(y, 1);
            Checks.checkBuffer(comp, 1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), x, y, comp);
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6);

    public static int stbi_info_from_callbacks(STBIIOCallbacks clbk, long user, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(x, 1);
            Checks.checkBuffer(y, 1);
            Checks.checkBuffer(comp, 1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, x, y, comp);
    }

    static {
        Library.initialize();
        MemoryUtil.getAllocator();
    }
}

