/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTrackingState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADPOSE;
    public static final int STATUSFLAGS;
    public static final int HANDPOSES;
    public static final int HANDSTATUSFLAGS;
    public static final int CALIBRATEDORIGIN;

    OVRTrackingState(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackingState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRTrackingState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRPoseStatef HeadPose() {
        return OVRTrackingState.nHeadPose(this.address());
    }

    public int StatusFlags() {
        return OVRTrackingState.nStatusFlags(this.address());
    }

    public OVRPoseStatef.Buffer HandPoses() {
        return OVRTrackingState.nHandPoses(this.address());
    }

    public OVRPoseStatef HandPoses(int index) {
        return OVRTrackingState.nHandPoses(this.address(), index);
    }

    public IntBuffer HandStatusFlags() {
        return OVRTrackingState.nHandStatusFlags(this.address());
    }

    public int HandStatusFlags(int index) {
        return OVRTrackingState.nHandStatusFlags(this.address(), index);
    }

    public OVRPosef CalibratedOrigin() {
        return OVRTrackingState.nCalibratedOrigin(this.address());
    }

    public static OVRTrackingState malloc() {
        return OVRTrackingState.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTrackingState calloc() {
        return OVRTrackingState.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTrackingState create() {
        return new OVRTrackingState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRTrackingState create(long address) {
        return address == 0L ? null : new OVRTrackingState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackingState.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackingState.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRTrackingState mallocStack() {
        return OVRTrackingState.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState callocStack() {
        return OVRTrackingState.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState mallocStack(MemoryStack stack) {
        return OVRTrackingState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackingState callocStack(MemoryStack stack) {
        return OVRTrackingState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackingState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackingState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackingState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackingState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPoseStatef nHeadPose(long struct) {
        return OVRPoseStatef.create(struct + (long)HEADPOSE);
    }

    public static int nStatusFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STATUSFLAGS);
    }

    public static OVRPoseStatef.Buffer nHandPoses(long struct) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES, 2);
    }

    public static OVRPoseStatef nHandPoses(long struct, int index) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES + (long)(index * OVRPoseStatef.SIZEOF));
    }

    public static IntBuffer nHandStatusFlags(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)HANDSTATUSFLAGS, 2);
    }

    public static int nHandStatusFlags(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)HANDSTATUSFLAGS + (long)(index * 4));
    }

    public static OVRPosef nCalibratedOrigin(long struct) {
        return OVRPosef.create(struct + (long)CALIBRATEDORIGIN);
    }

    static {
        Struct.Layout layout = OVRTrackingState.__struct(OVRTrackingState.__member(OVRPoseStatef.SIZEOF, OVRPoseStatef.ALIGNOF), OVRTrackingState.__member(4), OVRTrackingState.__array(OVRPoseStatef.SIZEOF, OVRPoseStatef.ALIGNOF, 2), OVRTrackingState.__array(4, 2), OVRTrackingState.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADPOSE = layout.offsetof(0);
        STATUSFLAGS = layout.offsetof(1);
        HANDPOSES = layout.offsetof(2);
        HANDSTATUSFLAGS = layout.offsetof(3);
        CALIBRATEDORIGIN = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRTrackingState, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRTrackingState newInstance(long address) {
            return new OVRTrackingState(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRPoseStatef HeadPose() {
            return OVRTrackingState.nHeadPose(this.address());
        }

        public int StatusFlags() {
            return OVRTrackingState.nStatusFlags(this.address());
        }

        public OVRPoseStatef.Buffer HandPoses() {
            return OVRTrackingState.nHandPoses(this.address());
        }

        public OVRPoseStatef HandPoses(int index) {
            return OVRTrackingState.nHandPoses(this.address(), index);
        }

        public IntBuffer HandStatusFlags() {
            return OVRTrackingState.nHandStatusFlags(this.address());
        }

        public int HandStatusFlags(int index) {
            return OVRTrackingState.nHandStatusFlags(this.address(), index);
        }

        public OVRPosef CalibratedOrigin() {
            return OVRTrackingState.nCalibratedOrigin(this.address());
        }
    }
}

