/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTrackerDesc
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRUSTUMHFOVINRADIANS;
    public static final int FRUSTUMVFOVINRADIANS;
    public static final int FRUSTUMNEARZINMETERS;
    public static final int FRUSTUMFARZINMETERS;

    OVRTrackerDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackerDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRTrackerDesc.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float FrustumHFovInRadians() {
        return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
    }

    public float FrustumVFovInRadians() {
        return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
    }

    public float FrustumNearZInMeters() {
        return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
    }

    public float FrustumFarZInMeters() {
        return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
    }

    public OVRTrackerDesc FrustumHFovInRadians(float value) {
        OVRTrackerDesc.nFrustumHFovInRadians(this.address(), value);
        return this;
    }

    public OVRTrackerDesc FrustumVFovInRadians(float value) {
        OVRTrackerDesc.nFrustumVFovInRadians(this.address(), value);
        return this;
    }

    public OVRTrackerDesc FrustumNearZInMeters(float value) {
        OVRTrackerDesc.nFrustumNearZInMeters(this.address(), value);
        return this;
    }

    public OVRTrackerDesc FrustumFarZInMeters(float value) {
        OVRTrackerDesc.nFrustumFarZInMeters(this.address(), value);
        return this;
    }

    public OVRTrackerDesc set(float FrustumHFovInRadians, float FrustumVFovInRadians, float FrustumNearZInMeters, float FrustumFarZInMeters) {
        this.FrustumHFovInRadians(FrustumHFovInRadians);
        this.FrustumVFovInRadians(FrustumVFovInRadians);
        this.FrustumNearZInMeters(FrustumNearZInMeters);
        this.FrustumFarZInMeters(FrustumFarZInMeters);
        return this;
    }

    public OVRTrackerDesc nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRTrackerDesc set(OVRTrackerDesc src) {
        return this.nset(src.address());
    }

    public static OVRTrackerDesc malloc() {
        return OVRTrackerDesc.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTrackerDesc calloc() {
        return OVRTrackerDesc.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTrackerDesc create() {
        return new OVRTrackerDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRTrackerDesc create(long address) {
        return address == 0L ? null : new OVRTrackerDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackerDesc.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackerDesc.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRTrackerDesc mallocStack() {
        return OVRTrackerDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerDesc callocStack() {
        return OVRTrackerDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerDesc mallocStack(MemoryStack stack) {
        return OVRTrackerDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackerDesc callocStack(MemoryStack stack) {
        return OVRTrackerDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackerDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackerDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nFrustumHFovInRadians(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FRUSTUMHFOVINRADIANS);
    }

    public static float nFrustumVFovInRadians(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FRUSTUMVFOVINRADIANS);
    }

    public static float nFrustumNearZInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FRUSTUMNEARZINMETERS);
    }

    public static float nFrustumFarZInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FRUSTUMFARZINMETERS);
    }

    public static void nFrustumHFovInRadians(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FRUSTUMHFOVINRADIANS, value);
    }

    public static void nFrustumVFovInRadians(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FRUSTUMVFOVINRADIANS, value);
    }

    public static void nFrustumNearZInMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FRUSTUMNEARZINMETERS, value);
    }

    public static void nFrustumFarZInMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FRUSTUMFARZINMETERS, value);
    }

    static {
        Struct.Layout layout = OVRTrackerDesc.__struct(OVRTrackerDesc.__member(4), OVRTrackerDesc.__member(4), OVRTrackerDesc.__member(4), OVRTrackerDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRUSTUMHFOVINRADIANS = layout.offsetof(0);
        FRUSTUMVFOVINRADIANS = layout.offsetof(1);
        FRUSTUMNEARZINMETERS = layout.offsetof(2);
        FRUSTUMFARZINMETERS = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<OVRTrackerDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRTrackerDesc newInstance(long address) {
            return new OVRTrackerDesc(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float FrustumHFovInRadians() {
            return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
        }

        public float FrustumVFovInRadians() {
            return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
        }

        public float FrustumNearZInMeters() {
            return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
        }

        public float FrustumFarZInMeters() {
            return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
        }

        public Buffer FrustumHFovInRadians(float value) {
            OVRTrackerDesc.nFrustumHFovInRadians(this.address(), value);
            return this;
        }

        public Buffer FrustumVFovInRadians(float value) {
            OVRTrackerDesc.nFrustumVFovInRadians(this.address(), value);
            return this;
        }

        public Buffer FrustumNearZInMeters(float value) {
            OVRTrackerDesc.nFrustumNearZInMeters(this.address(), value);
            return this;
        }

        public Buffer FrustumFarZInMeters(float value) {
            OVRTrackerDesc.nFrustumFarZInMeters(this.address(), value);
            return this;
        }
    }
}

