/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet {
    public static final int GL_TEXTURE_WIDTH_QCOM = 35794;
    public static final int GL_TEXTURE_HEIGHT_QCOM = 35795;
    public static final int GL_TEXTURE_DEPTH_QCOM = 35796;
    public static final int GL_TEXTURE_INTERNAL_FORMAT_QCOM = 35797;
    public static final int GL_TEXTURE_FORMAT_QCOM = 35798;
    public static final int GL_TEXTURE_TYPE_QCOM = 35799;
    public static final int GL_TEXTURE_IMAGE_VALID_QCOM = 35800;
    public static final int GL_TEXTURE_NUM_LEVELS_QCOM = 35801;
    public static final int GL_TEXTURE_TARGET_QCOM = 35802;
    public static final int GL_TEXTURE_OBJECT_VALID_QCOM = 35803;
    public static final int GL_STATE_RESTORE = 35804;

    protected QCOMExtendedGet() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glExtGetTexturesQCOM, caps.glExtGetBuffersQCOM, caps.glExtGetRenderbuffersQCOM, caps.glExtGetFramebuffersQCOM, caps.glExtGetTexLevelParameterivQCOM, caps.glExtTexObjectStateOverrideiQCOM, caps.glExtGetTexSubImageQCOM, caps.glExtGetBufferPointervQCOM);
    }

    public static void nglExtGetTexturesQCOM(long textures, int maxTextures, long numTextures) {
        long __functionAddress = GLES.getCapabilities().glExtGetTexturesQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, textures, maxTextures, numTextures);
    }

    public static void glExtGetTexturesQCOM(IntBuffer textures, IntBuffer numTextures) {
        if (Checks.CHECKS && numTextures != null) {
            Checks.checkBuffer((Buffer)numTextures, 1);
        }
        QCOMExtendedGet.nglExtGetTexturesQCOM(MemoryUtil.memAddressSafe(textures), textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(numTextures));
    }

    public static void nglExtGetBuffersQCOM(long buffers, int maxBuffers, long numBuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetBuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffers, maxBuffers, numBuffers);
    }

    public static void glExtGetBuffersQCOM(IntBuffer buffers, IntBuffer numBuffers) {
        if (Checks.CHECKS && numBuffers != null) {
            Checks.checkBuffer((Buffer)numBuffers, 1);
        }
        QCOMExtendedGet.nglExtGetBuffersQCOM(MemoryUtil.memAddressSafe(buffers), buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(numBuffers));
    }

    public static void nglExtGetRenderbuffersQCOM(long renderbuffers, int maxRenderbuffers, long numRenderbuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetRenderbuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, renderbuffers, maxRenderbuffers, numRenderbuffers);
    }

    public static void glExtGetRenderbuffersQCOM(IntBuffer renderbuffers, IntBuffer numRenderbuffers) {
        if (Checks.CHECKS && numRenderbuffers != null) {
            Checks.checkBuffer((Buffer)numRenderbuffers, 1);
        }
        QCOMExtendedGet.nglExtGetRenderbuffersQCOM(MemoryUtil.memAddressSafe(renderbuffers), renderbuffers == null ? 0 : renderbuffers.remaining(), MemoryUtil.memAddressSafe(numRenderbuffers));
    }

    public static void nglExtGetFramebuffersQCOM(long framebuffers, int maxFramebuffers, long numFramebuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetFramebuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, framebuffers, maxFramebuffers, numFramebuffers);
    }

    public static void glExtGetFramebuffersQCOM(IntBuffer framebuffers, IntBuffer numFramebuffers) {
        if (Checks.CHECKS && numFramebuffers != null) {
            Checks.checkBuffer((Buffer)numFramebuffers, 1);
        }
        QCOMExtendedGet.nglExtGetFramebuffersQCOM(MemoryUtil.memAddressSafe(framebuffers), framebuffers == null ? 0 : framebuffers.remaining(), MemoryUtil.memAddressSafe(numFramebuffers));
    }

    public static void nglExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glExtGetTexLevelParameterivQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, face, level, pname, params);
    }

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glExtGetTexLevelParameteriQCOM(int texture, int face, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glExtTexObjectStateOverrideiQCOM(int target, int pname, int param) {
        long __functionAddress = GLES.getCapabilities().glExtTexObjectStateOverrideiQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, pname, param);
    }

    public static void nglExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long texels) {
        long __functionAddress = GLES.getCapabilities().glExtGetTexSubImageQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    }

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer texels) {
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(texels));
    }

    public static void nglExtGetBufferPointervQCOM(int target, long params) {
        long __functionAddress = GLES.getCapabilities().glExtGetBufferPointervQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, params);
    }

    public static void glExtGetBufferPointervQCOM(int target, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glExtGetBufferPointerQCOM(int target) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glExtGetTexturesQCOM(int[] textures, int[] numTextures) {
        long __functionAddress = GLES.getCapabilities().glExtGetTexturesQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numTextures != null) {
                Checks.checkBuffer(numTextures, 1);
            }
        }
        JNI.callPPV(__functionAddress, textures, textures == null ? 0 : textures.length, numTextures);
    }

    public static void glExtGetBuffersQCOM(int[] buffers, int[] numBuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetBuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numBuffers != null) {
                Checks.checkBuffer(numBuffers, 1);
            }
        }
        JNI.callPPV(__functionAddress, buffers, buffers == null ? 0 : buffers.length, numBuffers);
    }

    public static void glExtGetRenderbuffersQCOM(int[] renderbuffers, int[] numRenderbuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetRenderbuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numRenderbuffers != null) {
                Checks.checkBuffer(numRenderbuffers, 1);
            }
        }
        JNI.callPPV(__functionAddress, renderbuffers, renderbuffers == null ? 0 : renderbuffers.length, numRenderbuffers);
    }

    public static void glExtGetFramebuffersQCOM(int[] framebuffers, int[] numFramebuffers) {
        long __functionAddress = GLES.getCapabilities().glExtGetFramebuffersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numFramebuffers != null) {
                Checks.checkBuffer(numFramebuffers, 1);
            }
        }
        JNI.callPPV(__functionAddress, framebuffers, framebuffers == null ? 0 : framebuffers.length, numFramebuffers);
    }

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glExtGetTexLevelParameterivQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, face, level, pname, params);
    }
}

